/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.DevAppServerImpl;
import com.google.appengine.tools.info.SdkInfo;
import java.util.Iterator;
import sun.misc.Service;

class ContainerUtils {
    ContainerUtils() {
    }

    static ContainerService loadContainer() {
        Iterator containerLoader = Service.providers(ContainerService.class, (ClassLoader)DevAppServerImpl.class.getClassLoader());
        String containerClazz = System.getProperty("devappserver.container");
        ContainerService result = null;
        while (containerLoader.hasNext()) {
            ContainerService container = (ContainerService)containerLoader.next();
            if (containerClazz == null || containerClazz.length() == 0) {
                if (result == null) {
                    result = container;
                    continue;
                }
                System.err.println("Warning: Found more than one servlet container provider: " + result.getClass() + ", " + container.getClass() + ". And the first one will be used!");
                break;
            }
            if (!container.getClass().getName().endsWith(containerClazz)) continue;
            result = container;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot load any servlet container.");
        }
        return result;
    }

    static String getServerInfo() {
        return "Google App Engine Development/" + SdkInfo.getLocalVersion().getRelease();
    }
}

