/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import java.util.Arrays;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.store.StoreManager;

public enum StorageVersion {
    PARENTS_DO_NOT_REFER_TO_CHILDREN,
    WRITE_OWNED_CHILD_KEYS_TO_PARENTS,
    READ_OWNED_CHILD_KEYS_FROM_PARENTS;

    public static final String STORAGE_VERSION_PROPERTY = "datanucleus.appengine.storageVersion";
    private static final StorageVersion DEFAULT;

    static StorageVersion fromStoreManager(StoreManager storeMgr) {
        String val = storeMgr.getStringProperty(STORAGE_VERSION_PROPERTY);
        if (val == null) {
            return DEFAULT;
        }
        try {
            return StorageVersion.valueOf(val);
        }
        catch (IllegalArgumentException iae) {
            throw new NucleusFatalUserException(String.format("'%s' is an unknwon value for %s.  Legal values are %s.", val, STORAGE_VERSION_PROPERTY, Arrays.toString((Object[])StorageVersion.values())));
        }
    }

    static {
        DEFAULT = READ_OWNED_CHILD_KEYS_FROM_PARENTS;
    }
}

