/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractMemberMetaData
extends MetaData
implements Comparable,
ColumnMetaDataContainer {
    protected ColumnMetaData[] columnMetaData;
    protected ContainerMetaData container;
    protected EmbeddedMetaData embeddedMetaData;
    protected JoinMetaData joinMetaData;
    protected ElementMetaData elementMetaData;
    protected KeyMetaData keyMetaData;
    protected ValueMetaData valueMetaData;
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected UniqueMetaData uniqueMetaData;
    protected boolean uniqueConstraint = false;
    protected OrderMetaData orderMetaData;
    protected ForeignKeyMetaData foreignKeyMetaData;
    protected Boolean defaultFetchGroup;
    protected String column;
    protected String mappedBy;
    protected Boolean embedded;
    protected Boolean dependent;
    protected Boolean serialized;
    protected boolean cacheable = true;
    protected Boolean cascadePersist;
    protected Boolean cascadeUpdate;
    protected Boolean cascadeDelete;
    protected Boolean cascadeRefresh;
    protected String loadFetchGroup;
    public static final int DEFAULT_RECURSION_DEPTH = 1;
    public static final int UNDEFINED_RECURSION_DEPTH = 0;
    protected int recursionDepth = 0;
    protected final String name;
    protected NullValue nullValue = NullValue.NONE;
    protected FieldPersistenceModifier persistenceModifier = FieldPersistenceModifier.DEFAULT;
    protected Boolean primaryKey;
    protected String table;
    protected String catalog;
    protected String schema;
    protected IdentityStrategy valueStrategy;
    protected String valueGeneratorName;
    protected String sequence;
    protected String className = null;
    protected String fullFieldName = null;
    protected String[] fieldTypes;
    protected Class type;
    protected int modifiers;
    protected int fieldId = -1;
    protected int relationType = -1;
    protected AbstractMemberMetaData[] relatedMemberMetaData = null;
    protected boolean ordered = false;
    protected List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
    protected String targetClassName = null;
    protected boolean storeInLob = false;
    protected byte jdoFieldFlag;

    public AbstractMemberMetaData(MetaData parent, AbstractMemberMetaData fmd) {
        super(parent);
        int i;
        this.name = fmd.name;
        this.primaryKey = fmd.primaryKey;
        this.defaultFetchGroup = fmd.defaultFetchGroup;
        this.column = fmd.column;
        this.mappedBy = fmd.mappedBy;
        this.dependent = fmd.dependent;
        this.embedded = fmd.embedded;
        this.serialized = fmd.serialized;
        this.cascadePersist = fmd.cascadePersist;
        this.cascadeUpdate = fmd.cascadeUpdate;
        this.cascadeDelete = fmd.cascadeDelete;
        this.cascadeRefresh = fmd.cascadeRefresh;
        this.nullValue = fmd.nullValue;
        this.persistenceModifier = fmd.persistenceModifier;
        this.table = fmd.table;
        this.indexed = fmd.indexed;
        this.valueStrategy = fmd.valueStrategy;
        this.valueGeneratorName = fmd.valueGeneratorName;
        this.sequence = fmd.sequence;
        this.uniqueConstraint = fmd.uniqueConstraint;
        this.loadFetchGroup = fmd.loadFetchGroup;
        if (fmd.fieldTypes != null) {
            this.fieldTypes = new String[fmd.fieldTypes.length];
            for (i = 0; i < fmd.fieldTypes.length; ++i) {
                this.fieldTypes[i] = fmd.fieldTypes[i];
            }
        }
        if (fmd.joinMetaData != null) {
            this.setJoinMetaData(new JoinMetaData(fmd.joinMetaData));
        }
        if (fmd.elementMetaData != null) {
            this.setElementMetaData(new ElementMetaData(fmd.elementMetaData));
        }
        if (fmd.keyMetaData != null) {
            this.setKeyMetaData(new KeyMetaData(fmd.keyMetaData));
        }
        if (fmd.valueMetaData != null) {
            this.setValueMetaData(new ValueMetaData(fmd.valueMetaData));
        }
        if (fmd.orderMetaData != null) {
            this.setOrderMetaData(new OrderMetaData(fmd.orderMetaData));
        }
        if (fmd.indexMetaData != null) {
            this.setIndexMetaData(new IndexMetaData(fmd.indexMetaData));
        }
        if (fmd.uniqueMetaData != null) {
            this.setUniqueMetaData(new UniqueMetaData(fmd.uniqueMetaData));
        }
        if (fmd.foreignKeyMetaData != null) {
            this.setForeignKeyMetaData(new ForeignKeyMetaData(fmd.foreignKeyMetaData));
        }
        if (fmd.embeddedMetaData != null) {
            this.setEmbeddedMetaData(new EmbeddedMetaData(fmd.embeddedMetaData));
        }
        if (fmd.container != null) {
            if (fmd.container instanceof CollectionMetaData) {
                this.setContainer(new CollectionMetaData((CollectionMetaData)fmd.container));
            } else if (fmd.container instanceof MapMetaData) {
                this.setContainer(new MapMetaData((MapMetaData)fmd.container));
            } else if (fmd.container instanceof ArrayMetaData) {
                this.setContainer(new ArrayMetaData((ArrayMetaData)fmd.container));
            }
        }
        for (i = 0; i < fmd.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData(fmd.columns.get(i)));
        }
    }

    public AbstractMemberMetaData(MetaData parent, String name) {
        super(parent);
        if (name == null) {
            throw new NucleusUserException(LOCALISER.msg("044041", (Object)"name", (Object)this.getClassName(true), (Object)"field"));
        }
        if (name.indexOf(46) >= 0) {
            this.className = name.substring(0, name.lastIndexOf(46));
            this.name = name.substring(name.lastIndexOf(46) + 1);
        } else {
            this.name = name;
        }
    }

    public synchronized void populate(ClassLoaderResolver clr, Field field, Method method, ClassLoader primary) {
        String valueType;
        if (this.isPopulated() || this.isInitialised()) {
            return;
        }
        if (this.getMetaDataManager() != null) {
            ApiAdapter apiAdapter = this.getMetaDataManager().getOMFContext().getApiAdapter();
            if (this.cascadePersist == null) {
                this.cascadePersist = apiAdapter.getDefaultCascadePersistForField();
            }
            if (this.cascadeUpdate == null) {
                this.cascadeUpdate = apiAdapter.getDefaultCascadeUpdateForField();
            }
            if (this.cascadeDelete == null) {
                this.cascadeDelete = apiAdapter.getDefaultCascadeDeleteForField();
            }
            if (this.cascadeRefresh == null) {
                this.cascadeRefresh = apiAdapter.getDefaultCascadeRefreshForField();
            }
        }
        if (field == null && method == null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044106", (Object)this.name, (Object)this.getClassName(false)));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Field.PopulateWithNullError", (Object)this.name, this.getClassName(false));
        }
        if (clr == null) {
            NucleusLogger.METADATA.warn(LOCALISER.msg("044067", (Object)this.name, (Object)this.getClassName(true)));
            clr = this.getAbstractClassMetaData().getMetaDataManager().getOMFContext().getClassLoaderResolver(null);
        }
        if (field != null) {
            this.type = field.getType();
            this.modifiers = field.getModifiers();
        } else if (method != null) {
            this.type = method.getReturnType();
            this.modifiers = method.getModifiers();
        }
        if (this.className != null) {
            Class thisClass = null;
            try {
                thisClass = clr.classForName(this.getAbstractClassMetaData().getPackageName() + "." + this.getAbstractClassMetaData().getName());
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            Class fieldClass = null;
            try {
                fieldClass = clr.classForName(this.className);
            }
            catch (ClassNotResolvedException cnre) {
                try {
                    fieldClass = clr.classForName(this.getAbstractClassMetaData().getPackageName() + "." + this.className);
                    this.className = this.getAbstractClassMetaData().getPackageName() + "." + this.className;
                }
                catch (ClassNotResolvedException cnre2) {
                    NucleusLogger.METADATA.error(LOCALISER.msg("044113", (Object)this.getAbstractClassMetaData().getName(), (Object)this.name, (Object)this.className));
                    throw new InvalidMetaDataException(LOCALISER, "044113", (Object)this.getAbstractClassMetaData().getName(), (Object)this.name, this.className);
                }
            }
            if (fieldClass != null && !fieldClass.isAssignableFrom(thisClass)) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044114", (Object)this.getAbstractClassMetaData().getName(), (Object)this.name, (Object)this.className));
                throw new InvalidMetaDataException(LOCALISER, "044114", (Object)this.getAbstractClassMetaData().getName(), (Object)this.name, this.className);
            }
        }
        if (this.primaryKey == null) {
            this.primaryKey = Boolean.FALSE;
        }
        if (this.primaryKey == Boolean.FALSE && this.embedded == null) {
            Class<?> element_type = this.getType();
            if (element_type.isArray()) {
                element_type = element_type.getComponentType();
                if (this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(element_type)) {
                    this.embedded = Boolean.TRUE;
                }
            } else if (this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(element_type)) {
                this.embedded = Boolean.TRUE;
            }
        }
        if (this.embedded == null) {
            this.embedded = Boolean.FALSE;
        }
        if (FieldPersistenceModifier.DEFAULT.equals(this.persistenceModifier)) {
            boolean isPcClass;
            boolean bl = isPcClass = this.getType().isArray() ? this.isFieldArrayTypePersistable() : this.isFieldTypePersistable();
            if (!isPcClass) {
                if (this.getType().isArray() && this.getType().getComponentType().isInterface()) {
                    isPcClass = this.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(this.getType().getComponentType(), clr) != null;
                } else if (this.getType().isInterface()) {
                    isPcClass = this.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(this.getType(), clr) != null;
                }
            }
            this.persistenceModifier = this.getDefaultFieldPersistenceModifier(this.getType(), this.modifiers, isPcClass);
        }
        if (this.defaultFetchGroup == null && this.persistenceModifier.equals(FieldPersistenceModifier.NONE)) {
            this.defaultFetchGroup = Boolean.FALSE;
        } else if (this.defaultFetchGroup == null && this.persistenceModifier.equals(FieldPersistenceModifier.TRANSACTIONAL)) {
            this.defaultFetchGroup = Boolean.FALSE;
        } else if (this.defaultFetchGroup == null) {
            this.defaultFetchGroup = Boolean.FALSE;
            if (!this.primaryKey.equals(Boolean.TRUE) && this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultFetchGroup(this.getType())) {
                this.defaultFetchGroup = Boolean.TRUE;
            }
        }
        if ((this.persistenceModifier.equals(FieldPersistenceModifier.TRANSACTIONAL) || this.persistenceModifier.equals(FieldPersistenceModifier.NONE)) && (this.defaultFetchGroup == Boolean.TRUE || this.primaryKey == Boolean.TRUE)) {
            throw new InvalidMetaDataException(LOCALISER, "044109", (Object)this.name, (Object)this.getClassName(true), (Object)this.getType().getName(), this.persistenceModifier.toString());
        }
        if (this.storeInLob) {
            boolean useClob = false;
            if (this.type == String.class || this.type.isArray() && this.type.getComponentType() == Character.class || this.type.isArray() && this.type.getComponentType() == Character.TYPE) {
                ColumnMetaData colmd;
                useClob = true;
                if (this.columns == null || this.columns.size() == 0) {
                    colmd = new ColumnMetaData();
                    colmd.setName(this.column);
                    colmd.setJdbcType("CLOB");
                    this.addColumn(colmd);
                } else {
                    colmd = this.columns.get(0);
                    colmd.setJdbcType("CLOB");
                }
            }
            if (!useClob) {
                this.serialized = Boolean.TRUE;
            }
        }
        if (this.container == null) {
            if (this.type.isArray()) {
                Class<?> arrayCls = this.type.getComponentType();
                ArrayMetaData arrmd = new ArrayMetaData();
                arrmd.setElementType(arrayCls.getName());
                this.setContainer(arrmd);
            } else if (Collection.class.isAssignableFrom(this.type)) {
                if (this.targetClassName != null) {
                    CollectionMetaData collmd = new CollectionMetaData();
                    collmd.setElementType(this.targetClassName);
                    this.setContainer(collmd);
                } else {
                    CollectionMetaData collmd;
                    String elementType = null;
                    elementType = field != null ? ClassUtils.getCollectionElementType(field) : ClassUtils.getCollectionElementType(method);
                    if (elementType != null) {
                        collmd = new CollectionMetaData();
                        collmd.setElementType(elementType);
                        this.setContainer(collmd);
                    } else {
                        collmd = new CollectionMetaData();
                        collmd.setElementType(Object.class.getName());
                        this.setContainer(collmd);
                        NucleusLogger.METADATA.info(LOCALISER.msg("044003", (Object)this.getFullFieldName()));
                    }
                }
            } else if (Map.class.isAssignableFrom(this.type)) {
                if (this.targetClassName != null) {
                    MapMetaData mapmd = new MapMetaData();
                    mapmd.setValueType(this.targetClassName);
                    this.setContainer(mapmd);
                } else {
                    MapMetaData mapmd;
                    String keyType = null;
                    valueType = null;
                    keyType = field != null ? ClassUtils.getMapKeyType(field) : ClassUtils.getMapKeyType(method);
                    valueType = field != null ? ClassUtils.getMapValueType(field) : ClassUtils.getMapValueType(method);
                    if (keyType != null && valueType != null) {
                        mapmd = new MapMetaData();
                        mapmd.setKeyType(keyType);
                        mapmd.setValueType(valueType);
                        this.setContainer(mapmd);
                    } else {
                        if (keyType == null) {
                            keyType = Object.class.getName();
                        }
                        if (valueType == null) {
                            valueType = Object.class.getName();
                        }
                        mapmd = new MapMetaData();
                        mapmd.setKeyType(keyType);
                        mapmd.setValueType(valueType);
                        this.setContainer(mapmd);
                        NucleusLogger.METADATA.info(LOCALISER.msg("044004", (Object)this.getFullFieldName()));
                    }
                }
            }
        } else if (this.type.isArray()) {
            if (this.getArray().element.type == null) {
                Class<?> arrayCls = this.type.getComponentType();
                this.getArray().setElementType(arrayCls.getName());
            }
        } else if (Collection.class.isAssignableFrom(this.type)) {
            String elementType = null;
            elementType = field != null ? ClassUtils.getCollectionElementType(field) : ClassUtils.getCollectionElementType(method);
            if (elementType != null && (this.getCollection().element.type == null || this.getCollection().element.type.equals(ClassNameConstants.Object))) {
                this.getCollection().element.type = elementType;
            }
        } else if (Map.class.isAssignableFrom(this.type)) {
            String keyType = null;
            valueType = null;
            keyType = field != null ? ClassUtils.getMapKeyType(field) : ClassUtils.getMapKeyType(method);
            valueType = field != null ? ClassUtils.getMapValueType(field) : ClassUtils.getMapValueType(method);
            if (keyType != null && valueType != null) {
                if (this.getMap().key.type == null || this.getMap().key.type.equals(ClassNameConstants.Object)) {
                    this.getMap().key.type = keyType;
                }
                if (this.getMap().value.type == null || this.getMap().value.type.equals(ClassNameConstants.Object)) {
                    this.getMap().value.type = valueType;
                }
            }
        }
        if (this.hasCollection() && this.ordered && this.orderMetaData == null) {
            OrderMetaData ordmd = new OrderMetaData();
            ordmd.setOrdering("#PK");
            this.setOrderMetaData(ordmd);
        }
        if (this.elementMetaData == null && !this.isSerialized() && !this.isEmbedded() && this.columnMetaData != null && (this.hasCollection() || this.hasArray())) {
            ElementMetaData elemmd = new ElementMetaData();
            this.setElementMetaData(elemmd);
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                elemmd.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.valueMetaData == null && this.hasMap() && !this.isEmbedded() && !this.isSerialized() && this.columnMetaData != null) {
            ValueMetaData valmd = new ValueMetaData();
            this.setValueMetaData(valmd);
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                valmd.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.container != null && this.dependent != null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044110", (Object)this.name, (Object)this.getClassName(false), (Object)((ClassMetaData)this.parent).getName()));
            throw new InvalidMetaDataException(LOCALISER, "044110", (Object)this.name, (Object)this.getClassName(false), ((ClassMetaData)this.parent).getName());
        }
        if (this.elementMetaData != null) {
            this.elementMetaData.populate(clr, primary);
        }
        if (this.keyMetaData != null) {
            this.keyMetaData.populate(clr, primary);
        }
        if (this.valueMetaData != null) {
            this.valueMetaData.populate(clr, primary);
        }
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.populate(clr, primary);
            this.embedded = Boolean.TRUE;
        }
        if (this.elementMetaData != null && this.elementMetaData.mappedBy != null && this.mappedBy == null) {
            this.mappedBy = this.elementMetaData.mappedBy;
        }
        if (this.container != null && this.persistenceModifier == FieldPersistenceModifier.PERSISTENT) {
            if (this.container instanceof CollectionMetaData) {
                if (this.cascadeDelete.booleanValue()) {
                    this.getCollection().element.dependent = Boolean.TRUE;
                }
                this.getCollection().populate(clr, primary);
            } else if (this.container instanceof MapMetaData) {
                String keyCascadeVal = this.getValueForExtension("cascade-delete-key");
                if (this.cascadeDelete.booleanValue()) {
                    this.getMap().key.dependent = Boolean.FALSE;
                    this.getMap().value.dependent = Boolean.TRUE;
                }
                if (keyCascadeVal != null) {
                    this.getMap().key.dependent = keyCascadeVal.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                this.getMap().populate(clr, primary);
            } else if (this.container instanceof ArrayMetaData) {
                if (this.cascadeDelete.booleanValue()) {
                    this.getArray().element.dependent = Boolean.TRUE;
                }
                this.getArray().populate(clr, primary);
            }
        }
        if (this.isFieldTypePersistable() && this.cascadeDelete.booleanValue()) {
            this.setDependent(true);
        }
        if (this.hasExtension("implementation-classes")) {
            StringBuffer str = new StringBuffer();
            String[] implTypes = this.getValuesForExtension("implementation-classes");
            for (int i = 0; i < implTypes.length; ++i) {
                String implTypeName = ClassUtils.createFullClassName(this.getAbstractClassMetaData().getPackageName(), implTypes[i]);
                if (i > 0) {
                    str.append(",");
                }
                try {
                    clr.classForName(implTypeName);
                    str.append(implTypeName);
                    continue;
                }
                catch (ClassNotResolvedException cnre) {
                    try {
                        String langClassName = ClassUtils.getJavaLangClassForType(implTypeName);
                        clr.classForName(langClassName);
                        str.append(langClassName);
                        continue;
                    }
                    catch (ClassNotResolvedException cnre2) {
                        throw new InvalidMetaDataException(LOCALISER, "044116", (Object)this.name, (Object)this.getClassName(false), implTypes[i]);
                    }
                }
            }
            this.addExtension("datanucleus", "implementation-classes", str.toString());
        }
        int serializable = 0;
        if (Serializable.class.isAssignableFrom(this.getType()) || this.getType().isPrimitive()) {
            serializable = 16;
        }
        this.jdoFieldFlag = FieldPersistenceModifier.NONE.equals(this.persistenceModifier) ? (byte)0 : (FieldPersistenceModifier.TRANSACTIONAL.equals(this.persistenceModifier) && Modifier.isTransient(this.modifiers) ? (byte)(4 | serializable) : (this.primaryKey != false ? (byte)(8 | serializable) : (this.defaultFetchGroup != false ? (byte)(5 | serializable) : (this.defaultFetchGroup == false ? (byte)(0xA | serializable) : (byte)0))));
        this.setPopulated();
    }

    public final FieldPersistenceModifier getDefaultFieldPersistenceModifier(Class c, int modifier, boolean isPCclass) {
        if (Modifier.isStatic(modifier) || Modifier.isTransient(modifier) || Modifier.isFinal(modifier)) {
            return FieldPersistenceModifier.NONE;
        }
        if (isPCclass) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        if (c == null) {
            throw new NucleusException("class is null");
        }
        if (c.isArray() && this.getMetaDataManager().getOMFContext().getApiAdapter().isPersistable(c.getComponentType())) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        if (this.getMetaDataManager().getOMFContext().getTypeManager().isDefaultPersistent(c)) {
            return FieldPersistenceModifier.PERSISTENT;
        }
        return FieldPersistenceModifier.NONE;
    }

    public synchronized void initialise(ClassLoaderResolver clr) {
        int i;
        if (this.persistenceModifier == FieldPersistenceModifier.NONE) {
            this.setInitialised();
            return;
        }
        if (this.columns.size() == 0 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData();
            this.columnMetaData[0].setName(this.column);
            this.columnMetaData[0].parent = this;
            this.columnMetaData[0].initialise(clr);
        } else if (this.columns.size() == 1 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = this.columns.get(0);
            if (this.columnMetaData[0].getName() == null) {
                this.columnMetaData[0].setName(this.column);
            }
            this.columnMetaData[0].initialise(clr);
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = this.columns.get(i);
                this.columnMetaData[i].initialise(clr);
            }
        }
        if (this.container != null) {
            this.container.initialise(clr);
        }
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.initialise(clr);
        }
        if (this.joinMetaData != null) {
            this.joinMetaData.initialise(clr);
        }
        if (this.elementMetaData != null) {
            this.elementMetaData.initialise(clr);
        }
        if (this.keyMetaData != null) {
            this.keyMetaData.initialise(clr);
        }
        if (this.valueMetaData != null) {
            this.valueMetaData.initialise(clr);
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData();
            this.indexMetaData.setUnique(this.indexed == IndexedValue.UNIQUE);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise(clr);
        }
        if (this.uniqueMetaData == null && this.uniqueConstraint) {
            this.uniqueMetaData = new UniqueMetaData();
            this.uniqueMetaData.setTable(this.column);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise(clr);
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise(clr);
        }
        if (this.orderMetaData != null) {
            this.orderMetaData.initialise(clr);
        }
        if (this.hasExtension("cascade-persist")) {
            String cascadeValue = this.getValueForExtension("cascade-persist");
            if (cascadeValue.equalsIgnoreCase("true")) {
                this.cascadePersist = true;
            } else if (cascadeValue.equalsIgnoreCase("false")) {
                this.cascadePersist = false;
            }
        }
        if (this.hasExtension("cascade-update")) {
            String cascadeValue = this.getValueForExtension("cascade-update");
            if (cascadeValue.equalsIgnoreCase("true")) {
                this.cascadeUpdate = true;
            } else if (cascadeValue.equalsIgnoreCase("false")) {
                this.cascadeUpdate = false;
            }
        }
        if (this.hasExtension("cascade-refresh")) {
            String cascadeValue = this.getValueForExtension("cascade-refresh");
            if (cascadeValue.equalsIgnoreCase("true")) {
                this.cascadeRefresh = true;
            } else if (cascadeValue.equalsIgnoreCase("false")) {
                this.cascadeRefresh = false;
            }
        }
        this.setInitialised();
    }

    public boolean isFieldTypePersistable() {
        AbstractClassMetaData cmd;
        if (this.getAbstractClassMetaData().getMetaDataManager().isEnhancing() && (cmd = this.getAbstractClassMetaData().getMetaDataManager().readMetaDataForClass(this.type.getName())) != null && cmd instanceof ClassMetaData && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return true;
        }
        return this.getMetaDataManager().getOMFContext().getApiAdapter().isPersistable(this.type);
    }

    public boolean isFieldArrayTypePersistable() {
        AbstractClassMetaData cmd;
        if (!this.type.isArray()) {
            return false;
        }
        if (this.getAbstractClassMetaData().getMetaDataManager().isEnhancing() && (cmd = this.getAbstractClassMetaData().getMetaDataManager().readMetaDataForClass(this.type.getComponentType().getName())) != null && cmd instanceof ClassMetaData && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return true;
        }
        return this.getMetaDataManager().getOMFContext().getApiAdapter().isPersistable(this.type.getComponentType());
    }

    public boolean isStatic() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isTransient() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isTransient(this.modifiers);
    }

    public boolean isPublic() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isProtected() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPrivate() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isAbstract() {
        if (!this.isPopulated()) {
            return false;
        }
        return Modifier.isAbstract(this.modifiers);
    }

    public IdentityStrategy getValueStrategy() {
        return this.valueStrategy;
    }

    public void setValueStrategy(IdentityStrategy valueStrategy) {
        this.valueStrategy = valueStrategy;
    }

    public void setValueStrategy(String strategy) {
        this.valueStrategy = strategy == null ? null : IdentityStrategy.getIdentityStrategy(strategy);
    }

    public String getValueGeneratorName() {
        return this.valueGeneratorName;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = StringUtils.isWhitespace(sequence) ? null : sequence;
    }

    public boolean isCacheable() {
        if (this.hasExtension("cacheable")) {
            return !this.getValueForExtension("cacheable").equalsIgnoreCase("false");
        }
        return this.cacheable;
    }

    public void setCacheable(boolean cache) {
        this.cacheable = cache;
    }

    public String getLoadFetchGroup() {
        return this.loadFetchGroup;
    }

    public void setLoadFetchGroup(String loadFetchGroup) {
        this.loadFetchGroup = loadFetchGroup;
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    public void setRecursionDepth(int depth) {
        this.recursionDepth = depth;
    }

    public void setRecursionDepth(String depth) {
        if (!StringUtils.isWhitespace(depth)) {
            try {
                this.recursionDepth = Integer.parseInt(depth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected MetaData getOverallParentClassMetaData(MetaData metadata) {
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof AbstractClassMetaData) {
            return metadata;
        }
        return this.getOverallParentClassMetaData(metadata.getParent());
    }

    public AbstractClassMetaData getAbstractClassMetaData() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof AbstractClassMetaData) {
            return (AbstractClassMetaData)this.parent;
        }
        if (this.parent instanceof EmbeddedMetaData) {
            MetaData parentMd = ((EmbeddedMetaData)this.parent).getParent();
            return (AbstractClassMetaData)this.getOverallParentClassMetaData(parentMd.getParent());
        }
        return null;
    }

    public final OrderMetaData getOrderMetaData() {
        return this.orderMetaData;
    }

    public String getName() {
        return this.name;
    }

    public String getFullFieldName() {
        if (this.fullFieldName == null) {
            this.fullFieldName = this.className != null ? this.className + "." + this.name : this.getClassName(true) + "." + this.name;
        }
        return this.fullFieldName;
    }

    public boolean fieldBelongsToClass() {
        return this.className == null;
    }

    public String getClassName() {
        return this.getClassName(true);
    }

    void setClassName(String className) {
        this.className = className;
    }

    public String getClassName(boolean fully_qualified) {
        MetaData grandparent;
        if (this.className != null) {
            return this.className;
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof AbstractClassMetaData) {
            AbstractClassMetaData cmd = (AbstractClassMetaData)this.parent;
            if (fully_qualified) {
                return cmd.getFullClassName();
            }
            return cmd.getName();
        }
        if (this.parent instanceof EmbeddedMetaData) {
            MetaData parentMd = ((EmbeddedMetaData)this.parent).getParent();
            if (parentMd instanceof AbstractMemberMetaData) {
                return ((AbstractMemberMetaData)parentMd).getTypeName();
            }
            if (parentMd instanceof ElementMetaData) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)((ElementMetaData)parentMd).getParent();
                return fmd.getCollection().getElementType();
            }
            if (parentMd instanceof KeyMetaData) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)((KeyMetaData)parentMd).getParent();
                return fmd.getMap().getKeyType();
            }
            if (parentMd instanceof ValueMetaData) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)((ValueMetaData)parentMd).getParent();
                return fmd.getMap().getValueType();
            }
            return null;
        }
        if (this.parent instanceof UniqueMetaData && (grandparent = ((UniqueMetaData)this.parent).getParent()) instanceof AbstractClassMetaData) {
            return ((AbstractClassMetaData)grandparent).getFullClassName();
        }
        return null;
    }

    public FieldPersistenceModifier getPersistenceModifier() {
        return this.persistenceModifier;
    }

    public void setPersistenceModifier(String modifier) {
        if (!StringUtils.isWhitespace(modifier)) {
            this.persistenceModifier = FieldPersistenceModifier.getFieldPersistenceModifier(modifier);
        }
        if (this.persistenceModifier == null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044117", (Object)this.name, (Object)this.getClassName(false), (Object)modifier, (Object)"persistence-modifier"));
            throw new InvalidMetaDataException(LOCALISER, "044117", (Object)this.name, (Object)this.getClassName(false), (Object)modifier, "persistence-modifier");
        }
    }

    public void setNotPersistent() {
        this.persistenceModifier = FieldPersistenceModifier.NONE;
    }

    public void setTransactional() {
        this.persistenceModifier = FieldPersistenceModifier.TRANSACTIONAL;
    }

    public boolean isDefaultFetchGroup() {
        if (this.defaultFetchGroup == null) {
            return false;
        }
        return this.defaultFetchGroup;
    }

    public void setDefaultFetchGroup(boolean dfg) {
        this.defaultFetchGroup = new Boolean(dfg);
    }

    public void setDefaultFetchGroup(String dfg) {
        if (!StringUtils.isWhitespace(dfg)) {
            if (dfg.equalsIgnoreCase("true")) {
                this.defaultFetchGroup = Boolean.TRUE;
            } else if (dfg.equalsIgnoreCase("false")) {
                this.defaultFetchGroup = Boolean.FALSE;
            } else {
                throw new InvalidMetaDataException(LOCALISER, "044001", (Object)this.name, (Object)"defaultFetchGroup", (Object)dfg, "true|false");
            }
        }
    }

    public boolean isDependent() {
        if (this.dependent == null) {
            return false;
        }
        return this.dependent;
    }

    public void setDependent(boolean dependent) {
        this.dependent = new Boolean(dependent);
    }

    public void setDependent(String dependent) {
        if (!StringUtils.isWhitespace(dependent)) {
            if (dependent.equalsIgnoreCase("true")) {
                this.dependent = Boolean.TRUE;
            } else if (dependent.equalsIgnoreCase("false")) {
                this.dependent = Boolean.FALSE;
            } else {
                throw new InvalidMetaDataException(LOCALISER, "044001", (Object)this.name, (Object)"dependent", (Object)dependent, "true|false");
            }
        }
    }

    public boolean isEmbedded() {
        if (this.embedded == null) {
            return false;
        }
        return this.embedded;
    }

    public void setEmbedded(String val) {
        if (!StringUtils.isWhitespace(val)) {
            if (val.equalsIgnoreCase("true")) {
                this.embedded = Boolean.TRUE;
            } else if (val.equalsIgnoreCase("false")) {
                this.embedded = Boolean.FALSE;
            } else {
                throw new InvalidMetaDataException(LOCALISER, "044001", (Object)this.name, (Object)"embedded", (Object)val, "true|false");
            }
        }
    }

    public void setEmbedded(boolean val) {
        this.embedded = val;
    }

    public boolean isSerialized() {
        if (this.serialized == null) {
            return false;
        }
        return this.serialized;
    }

    public void setSerialised(boolean flag) {
        this.serialized = flag;
    }

    public void setSerialised(String val) {
        if (!StringUtils.isWhitespace(val)) {
            if (val.equalsIgnoreCase("true")) {
                this.serialized = Boolean.TRUE;
            } else if (val.equalsIgnoreCase("false")) {
                this.serialized = Boolean.FALSE;
            } else {
                throw new InvalidMetaDataException(LOCALISER, "044001", (Object)this.name, (Object)"serialized", (Object)val, "true|false");
            }
        }
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public boolean isCascadeUpdate() {
        return this.cascadeUpdate;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public boolean isPrimaryKey() {
        if (this.primaryKey == null) {
            return false;
        }
        return this.primaryKey;
    }

    public AbstractMemberMetaData setPrimaryKey(boolean flag) {
        this.primaryKey = flag;
        if (this.primaryKey.booleanValue()) {
            this.defaultFetchGroup = Boolean.TRUE;
        }
        return this;
    }

    public AbstractMemberMetaData setPrimaryKey(String pk) {
        if (!StringUtils.isWhitespace(pk)) {
            if (pk.equalsIgnoreCase("true")) {
                this.primaryKey = Boolean.TRUE;
                this.defaultFetchGroup = Boolean.TRUE;
            } else {
                this.primaryKey = Boolean.FALSE;
            }
        }
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public AbstractMemberMetaData setColumn(String col) {
        this.column = StringUtils.isWhitespace(col) ? null : col;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public AbstractMemberMetaData setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? null : table;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public AbstractMemberMetaData setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? null : catalog;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public AbstractMemberMetaData setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? null : schema;
        return this;
    }

    public boolean isUnique() {
        return this.uniqueConstraint;
    }

    public AbstractMemberMetaData setUnique(String unique) {
        if (!StringUtils.isWhitespace(unique)) {
            this.uniqueConstraint = Boolean.parseBoolean(unique);
        }
        return this;
    }

    public AbstractMemberMetaData setUnique(boolean unique) {
        this.uniqueConstraint = unique;
        return this;
    }

    public IndexedValue getIndexed() {
        return this.indexed;
    }

    public AbstractMemberMetaData setIndexed(IndexedValue val) {
        this.indexed = val;
        return this;
    }

    public NullValue getNullValue() {
        return this.nullValue;
    }

    public AbstractMemberMetaData setNullValue(NullValue val) {
        this.nullValue = val;
        return this;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public final String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(String types) {
        if (!StringUtils.isWhitespace(types)) {
            this.fieldTypes = MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(types);
        }
    }

    public int getAbsoluteFieldNumber() {
        if (this.className == null) {
            return this.fieldId + this.getAbstractClassMetaData().getNoOfInheritedManagedMembers();
        }
        return this.getAbstractClassMetaData().getAbsolutePositionOfMember(this.name);
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        if (this.type == null) {
            return null;
        }
        return this.type.getName();
    }

    public ContainerMetaData getContainer() {
        return this.container;
    }

    public ArrayMetaData getArray() {
        if (this.container != null && this.container instanceof ArrayMetaData) {
            return (ArrayMetaData)this.container;
        }
        return null;
    }

    public CollectionMetaData getCollection() {
        if (this.container != null && this.container instanceof CollectionMetaData) {
            return (CollectionMetaData)this.container;
        }
        return null;
    }

    public MapMetaData getMap() {
        if (this.container != null && this.container instanceof MapMetaData) {
            return (MapMetaData)this.container;
        }
        return null;
    }

    public final String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = StringUtils.isWhitespace(mappedBy) ? null : mappedBy;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final ElementMetaData getElementMetaData() {
        return this.elementMetaData;
    }

    public final KeyMetaData getKeyMetaData() {
        return this.keyMetaData;
    }

    public final ValueMetaData getValueMetaData() {
        return this.valueMetaData;
    }

    public final EmbeddedMetaData getEmbeddedMetaData() {
        return this.embeddedMetaData;
    }

    public void setDeleteAction(String action) {
        if (action != null) {
            this.foreignKeyMetaData = new ForeignKeyMetaData();
            this.foreignKeyMetaData.setDeleteAction(ForeignKeyAction.getForeignKeyAction(action));
        }
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final JoinMetaData getJoinMetaData() {
        return this.joinMetaData;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            this.columnMetaData[i] = this.columns.get(i);
        }
    }

    public ColumnMetaData newColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addColumn(colmd);
        return colmd;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public boolean hasArray() {
        if (this.container == null) {
            return false;
        }
        return this.container instanceof ArrayMetaData;
    }

    public boolean hasCollection() {
        if (this.container == null) {
            return false;
        }
        return this.container instanceof CollectionMetaData;
    }

    public boolean hasMap() {
        if (this.container == null) {
            return false;
        }
        return this.container instanceof MapMetaData;
    }

    public byte getJdoFieldFlag() {
        return this.jdoFieldFlag;
    }

    public boolean isJdoField() {
        if (this.isPopulated() && (this.isStatic() || this.isFinal())) {
            return false;
        }
        if (this.persistenceModifier == null) {
            return false;
        }
        return !this.persistenceModifier.equals(FieldPersistenceModifier.NONE);
    }

    public void setOrdered() {
        this.ordered = true;
    }

    public void setTargetClassName(String target) {
        if (!StringUtils.isWhitespace(target)) {
            this.targetClassName = target;
        }
    }

    public void setStoreInLob() {
        this.storeInLob = true;
    }

    public void setCascadePersist(boolean cascade) {
        this.cascadePersist = cascade;
    }

    public void setCascadeUpdate(boolean cascade) {
        this.cascadeUpdate = cascade;
    }

    public void setCascadeDelete(boolean cascade) {
        this.cascadeDelete = cascade;
    }

    public void setCascadeRefresh(boolean cascade) {
        this.cascadeRefresh = cascade;
    }

    public void setValueGeneratorName(String generator) {
        this.valueGeneratorName = StringUtils.isWhitespace(generator) ? null : generator;
    }

    public void setContainer(ContainerMetaData conmd) {
        this.container = conmd;
        this.container.parent = this;
    }

    public CollectionMetaData newCollectionMetaData() {
        CollectionMetaData collmd = new CollectionMetaData();
        this.setContainer(collmd);
        return collmd;
    }

    public ArrayMetaData newArrayMetaData() {
        ArrayMetaData arrmd = new ArrayMetaData();
        this.setContainer(arrmd);
        return arrmd;
    }

    public MapMetaData newMapMetaData() {
        MapMetaData mapmd = new MapMetaData();
        this.setContainer(mapmd);
        return mapmd;
    }

    public final void setElementMetaData(ElementMetaData elementMetaData) {
        this.elementMetaData = elementMetaData;
        this.elementMetaData.parent = this;
    }

    public ElementMetaData newElementMetaData() {
        ElementMetaData elemmd = new ElementMetaData();
        this.setElementMetaData(elemmd);
        return elemmd;
    }

    public final void setKeyMetaData(KeyMetaData keyMetaData) {
        this.keyMetaData = keyMetaData;
        this.keyMetaData.parent = this;
    }

    public KeyMetaData newKeyMetaData() {
        KeyMetaData keymd = new KeyMetaData();
        this.setKeyMetaData(keymd);
        return keymd;
    }

    public final void setValueMetaData(ValueMetaData valueMetaData) {
        this.valueMetaData = valueMetaData;
        this.valueMetaData.parent = this;
    }

    public ValueMetaData newValueMetaData() {
        ValueMetaData valuemd = new ValueMetaData();
        this.setValueMetaData(valuemd);
        return valuemd;
    }

    public final void setOrderMetaData(OrderMetaData orderMetaData) {
        this.orderMetaData = orderMetaData;
        this.orderMetaData.parent = this;
    }

    public OrderMetaData newOrderMetaData() {
        OrderMetaData ordermd = new OrderMetaData();
        this.setOrderMetaData(ordermd);
        return ordermd;
    }

    public final void setEmbeddedMetaData(EmbeddedMetaData embeddedMetaData) {
        this.embeddedMetaData = embeddedMetaData;
        this.embeddedMetaData.parent = this;
    }

    public EmbeddedMetaData newEmbeddedMetaData() {
        EmbeddedMetaData embmd = new EmbeddedMetaData();
        this.setEmbeddedMetaData(embmd);
        return embmd;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
        this.foreignKeyMetaData.parent = this;
    }

    public ForeignKeyMetaData newForeignKeyMetaData() {
        ForeignKeyMetaData fkmd = new ForeignKeyMetaData();
        this.setForeignKeyMetaData(fkmd);
        return fkmd;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
        this.indexMetaData.parent = this;
    }

    public IndexMetaData newIndexMetaData() {
        IndexMetaData idxmd = new IndexMetaData();
        this.setIndexMetaData(idxmd);
        return idxmd;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
        this.uniqueMetaData.parent = this;
    }

    public UniqueMetaData newUniqueMetaData() {
        UniqueMetaData unimd = new UniqueMetaData();
        this.setUniqueMetaData(unimd);
        return unimd;
    }

    public final void setJoinMetaData(JoinMetaData joinMetaData) {
        this.joinMetaData = joinMetaData;
        this.joinMetaData.parent = this;
    }

    public JoinMetaData newJoinMetaData() {
        JoinMetaData joinmd = new JoinMetaData();
        this.setJoinMetaData(joinmd);
        return joinmd;
    }

    public JoinMetaData newJoinMetadata() {
        JoinMetaData joinmd = new JoinMetaData();
        this.setJoinMetaData(joinmd);
        return joinmd;
    }

    void setFieldId(int field_id) {
        this.fieldId = field_id;
    }

    protected void setRelation(ClassLoaderResolver clr) {
        if (this.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            this.relationType = 0;
            this.relatedMemberMetaData = null;
            return;
        }
        AbstractClassMetaData otherCmd = null;
        if (this.hasCollection()) {
            Class elementCls;
            otherCmd = this.getMetaDataManager().getMetaDataForClass(this.getCollection().getElementType(), clr);
            if (otherCmd == null && ClassUtils.isReferenceType(elementCls = clr.classForName(this.getCollection().getElementType()))) {
                try {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this, 3, clr);
                    if (implNames != null && implNames.length > 0) {
                        otherCmd = this.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                    }
                }
                catch (NucleusUserException jpe) {
                    if (!this.getCollection().isSerializedElement() && this.mappedBy != null) {
                        throw jpe;
                    }
                    NucleusLogger.METADATA.info("Field " + this.getFullFieldName() + " is a collection of elements of reference type yet no implementation-classes are provided." + " Assuming they arent PersistenceCapable");
                }
            }
        } else if (this.hasMap()) {
            otherCmd = ((MapMetaData)this.container).getValueClassMetaData(clr);
            if (otherCmd == null) {
                otherCmd = ((MapMetaData)this.container).getKeyClassMetaData(clr);
            }
            if (otherCmd == null) {
                // empty if block
            }
        } else if (this.hasArray()) {
            otherCmd = ((ArrayMetaData)this.container).getElementClassMetaData(clr);
        } else if (this.getType().isInterface()) {
            String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this, 2, clr);
            if (implNames != null && implNames.length > 0) {
                otherCmd = this.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
            }
        } else {
            otherCmd = this.getMetaDataManager().getMetaDataForClass(this.getType(), clr);
        }
        if (otherCmd == null) {
            if (this.hasArray() && this.getArray().mayContainPersistenceCapableElements()) {
                this.relatedMemberMetaData = null;
                this.relationType = 3;
            } else {
                this.relatedMemberMetaData = null;
                this.relationType = 0;
            }
        } else if (this.mappedBy != null) {
            AbstractMemberMetaData otherMmd = otherCmd.getMetaDataForMember(this.mappedBy);
            if (otherMmd == null) {
                throw new NucleusUserException(LOCALISER.msg("044115", (Object)this.getAbstractClassMetaData().getFullClassName(), (Object)this.name, (Object)this.mappedBy, (Object)otherCmd.getFullClassName())).setFatal();
            }
            this.relatedMemberMetaData = new AbstractMemberMetaData[]{otherMmd};
            this.relationType = this.hasContainer() && this.relatedMemberMetaData[0].hasContainer() ? 5 : (this.hasContainer() && !this.relatedMemberMetaData[0].hasContainer() ? 4 : (!this.hasContainer() && this.relatedMemberMetaData[0].hasContainer() ? 6 : 2));
        } else {
            int[] otherFieldNumbers = otherCmd.getAllMemberPositions();
            HashSet<AbstractMemberMetaData> relatedFields = new HashSet<AbstractMemberMetaData>();
            for (int i = 0; i < otherFieldNumbers.length; ++i) {
                AbstractMemberMetaData otherFmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(otherFieldNumbers[i]);
                if (otherFmd.getMappedBy() == null || !otherFmd.getMappedBy().equals(this.name)) continue;
                if (otherFmd.hasContainer()) {
                    if (!(otherFmd.hasCollection() && otherFmd.getCollection().getElementType().equals(this.getClassName(true)) || otherFmd.hasArray() && otherFmd.getArray().getElementType().equals(this.getClassName(true)) || otherFmd.hasMap() && otherFmd.getMap().getKeyType().equals(this.getClassName(true))) && (!otherFmd.hasMap() || !otherFmd.getMap().getValueType().equals(this.getClassName(true)))) continue;
                    relatedFields.add(otherFmd);
                    if (this.hasContainer()) {
                        this.relationType = 5;
                        continue;
                    }
                    this.relationType = 6;
                    continue;
                }
                Class cls = clr.classForName(this.getClassName(true));
                if (!otherFmd.getType().isAssignableFrom(cls) && !cls.isAssignableFrom(otherFmd.getType())) continue;
                relatedFields.add(otherFmd);
                this.relationType = this.hasContainer() ? 4 : 2;
            }
            if (relatedFields.size() > 0) {
                this.relatedMemberMetaData = relatedFields.toArray(new AbstractMemberMetaData[relatedFields.size()]);
                relatedFields.clear();
                relatedFields = null;
            } else {
                this.relationType = this.hasContainer() ? 3 : 1;
            }
        }
    }

    public int getRelationType(ClassLoaderResolver clr) {
        if (this.relationType == -1) {
            this.setRelation(clr);
        }
        return this.relationType;
    }

    public boolean isPersistentInterface(ClassLoaderResolver clr) {
        if (this.hasCollection()) {
            if (this.getMetaDataManager().isPersistentInterface(this.getCollection().getElementType())) {
                return true;
            }
        } else if (this.hasMap()) {
            if (this.getMetaDataManager().isPersistentInterface(this.getMap().getKeyType())) {
                return true;
            }
            if (this.getMetaDataManager().isPersistentInterface(this.getMap().getValueType())) {
                return true;
            }
        } else if (this.hasArray()) {
            if (this.getMetaDataManager().isPersistentInterface(this.getArray().getElementType())) {
                return true;
            }
        } else if (this.getType().isInterface()) {
            if (this.getMetaDataManager().isPersistentInterface(this.getTypeName())) {
                return true;
            }
            if (this.fieldTypes != null && this.getMetaDataManager().isPersistentInterface(this.fieldTypes[0])) {
                return true;
            }
        }
        return false;
    }

    public boolean isRelationOwner(ClassLoaderResolver clr) {
        if (this.relationType == -1) {
            this.setRelation(clr);
        }
        if (this.relationType == 0) {
            return true;
        }
        if (this.relationType == 3 || this.relationType == 1) {
            return true;
        }
        if (this.relationType == 5 || this.relationType == 6 || this.relationType == 4 || this.relationType == 2) {
            return this.mappedBy == null;
        }
        return false;
    }

    public AbstractMemberMetaData[] getRelatedMemberMetaData(ClassLoaderResolver clr) {
        if (this.relationType == -1) {
            this.setRelation(clr);
        }
        return this.relatedMemberMetaData;
    }

    public AbstractMemberMetaData getRelatedMemberMetaDataForObject(ClassLoaderResolver clr, Object thisPC, Object otherPC) {
        if (this.relationType == -1) {
            this.setRelation(clr);
        }
        if (this.relatedMemberMetaData == null) {
            return null;
        }
        for (int i = 0; i < this.relatedMemberMetaData.length; ++i) {
            if (this.relationType == 2) {
                if (!this.relatedMemberMetaData[i].getType().isAssignableFrom(thisPC.getClass()) || !this.getType().isAssignableFrom(otherPC.getClass())) continue;
                return this.relatedMemberMetaData[i];
            }
            if (this.relationType != 6) continue;
            if (this.relatedMemberMetaData[i].hasCollection()) {
                Class elementType = clr.classForName(this.relatedMemberMetaData[i].getCollection().getElementType());
                if (!elementType.isAssignableFrom(thisPC.getClass()) || !this.getType().isAssignableFrom(otherPC.getClass())) continue;
                return this.relatedMemberMetaData[i];
            }
            if (!this.relatedMemberMetaData[i].hasMap()) continue;
            Class valueType = clr.classForName(this.relatedMemberMetaData[i].getMap().getValueType());
            if (valueType.isAssignableFrom(thisPC.getClass()) && this.getType().isAssignableFrom(otherPC.getClass())) {
                return this.relatedMemberMetaData[i];
            }
            Class keyType = clr.classForName(this.relatedMemberMetaData[i].getMap().getKeyType());
            if (!keyType.isAssignableFrom(thisPC.getClass()) || !this.getType().isAssignableFrom(otherPC.getClass())) continue;
            return this.relatedMemberMetaData[i];
        }
        return null;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, ClassLoaderResolver clr) {
        AbstractClassMetaData type_cmd = this.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClass(this.getType(), clr);
        if (type_cmd != null) {
            type_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr);
        }
        if (this.container != null) {
            if (this.container instanceof CollectionMetaData) {
                ((CollectionMetaData)this.container).getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr);
            } else if (this.container instanceof MapMetaData) {
                ((MapMetaData)this.container).getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr);
            } else if (this.container instanceof ArrayMetaData) {
                ((ArrayMetaData)this.container).getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr);
            }
        }
    }

    public boolean calcIsSecondClassMutable() {
        if (this.hasExtension("is-second-class")) {
            String isSecondClass = this.getValueForExtension("is-second-class");
            if (isSecondClass.equalsIgnoreCase("true")) {
                return true;
            }
            if (isSecondClass.equalsIgnoreCase("false")) {
                return false;
            }
            if (!isSecondClass.equalsIgnoreCase("default")) {
                throw new InvalidMetaDataException(LOCALISER, "044002", (Object)"is-second-class", (Object)"true/false/default", isSecondClass);
            }
        }
        return this.getMetaDataManager().getOMFContext().getTypeManager().isSecondClassMutableType(this.getTypeName());
    }

    public String toString(String prefix, String indent) {
        return super.toString(prefix, indent);
    }

    public int compareTo(Object o) {
        if (o instanceof AbstractMemberMetaData) {
            AbstractMemberMetaData c = (AbstractMemberMetaData)o;
            return this.name.compareTo(c.name);
        }
        if (o instanceof String) {
            return this.name.compareTo((String)o);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    public MetaDataManager getMetaDataManager() {
        MetaData overallCmd = this.getOverallParentClassMetaData(this);
        return overallCmd != null ? ((AbstractClassMetaData)overallCmd).getMetaDataManager() : null;
    }
}

