/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.AppVersionUpload;
import com.google.appengine.tools.admin.ConfirmationCallback;
import com.google.appengine.tools.admin.CronEntry;
import com.google.appengine.tools.admin.CronEntryImpl;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.IndexDeleter;
import com.google.appengine.tools.admin.LogFetcher;
import com.google.appengine.tools.admin.ResourceLimits;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.admin.ServerConnectionFactory;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.BackendsYamlReader;
import com.google.apphosting.utils.config.CronXml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AppAdminImpl
implements AppAdmin {
    private AppAdminFactory.ConnectOptions options;
    private GenericApplication app;
    private PrintWriter errorWriter;
    private AppAdminFactory.ApplicationProcessingOptions appOptions;
    private final Class<? extends AppVersionUpload> appVersionUploadClass;

    AppAdminImpl(AppAdminFactory.ConnectOptions options, GenericApplication app, PrintWriter errorWriter, AppAdminFactory.ApplicationProcessingOptions appOptions, Class<? extends AppVersionUpload> appVersionUploadClass) {
        this.options = options;
        this.app = app;
        this.errorWriter = errorWriter;
        this.appOptions = appOptions;
        this.appVersionUploadClass = appVersionUploadClass;
    }

    protected ServerConnection getServerConnection(AppAdminFactory.ConnectOptions options) {
        return ServerConnectionFactory.getServerConnection(options);
    }

    @Override
    public void update(UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        this.doUpdate(connection, listener, null);
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void updateBackend(String backendName, UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        this.doUpdate(connection, listener, backendName);
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void updateBackends(List<String> backendNames, UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        for (String backendName : backendNames) {
            this.doUpdate(connection, listener, backendName);
        }
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void updateAllBackends(UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        if (this.app.getBackendsXml() != null) {
            for (BackendsXml.Entry backend : this.app.getBackendsXml().getBackends()) {
                this.doUpdate(connection, listener, backend.getName());
            }
        }
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void rollback() {
        this.rollbackBackend(null);
    }

    @Override
    public void rollbackBackend(String backend) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, backend);
            uploader.forceRollback();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to rollback:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to rollback app: " + t.getMessage(), t);
        }
    }

    @Override
    public void rollbackAllBackends() {
        ServerConnection connection = this.getServerConnection(this.options);
        if (this.app.getBackendsXml() != null) {
            try {
                for (BackendsXml.Entry backend : this.app.getBackendsXml().getBackends()) {
                    AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, backend.getName());
                    uploader.forceRollback();
                }
            }
            catch (Throwable t) {
                this.errorWriter.println("Unable to rollback:");
                t.printStackTrace(this.errorWriter);
                throw new AdminException("Unable to rollback app: " + t.getMessage(), t);
            }
        }
    }

    @Override
    public void setBackendState(String backendName, BackendsXml.State newState) {
        String url;
        switch (newState) {
            case START: {
                url = "/api/backends/start";
                break;
            }
            case STOP: {
                url = "/api/backends/stop";
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot change to state: " + (Object)((Object)newState));
            }
        }
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post(url, "", "app_id", this.app.getAppId(), "backend", backendName);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to change backend state:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to change backend state: " + t.getMessage(), t);
        }
    }

    @Override
    public List<BackendsXml.Entry> listBackends() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            String yaml = connection.post("/api/backends/list", "", "app_id", this.app.getAppId());
            if (yaml.contains("No backends configured")) {
                return Collections.emptyList();
            }
            BackendsXml xml = BackendsYamlReader.parse(yaml);
            return xml.getBackends();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to list backends:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to list backends: " + t.getMessage(), t);
        }
    }

    @Override
    public void deleteBackend(String backendName) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post("/api/backends/delete", "", "app_id", this.app.getAppId(), "backend", backendName);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to delete backend:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to delete backend: " + t.getMessage(), t);
        }
    }

    @Override
    public void configureBackend(String backendName) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post("/api/backends/configure", this.app.getBackendsXml().toYaml(), "app_id", this.app.getAppId(), "backend", backendName);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to configure backend:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to configure backend: " + t.getMessage(), t);
        }
    }

    @Override
    public void updateIndexes() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateIndexes();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update indexes:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update indexes for app: " + t.getMessage(), t);
        }
    }

    @Override
    public void updateCron() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateCron();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update cron entries:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update cron entries for app: " + t.getMessage(), t);
        }
    }

    @Override
    public void updateQueues() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateQueue();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to upload:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update task queues for app: " + t.getMessage(), t);
        }
    }

    @Override
    public void updateDos() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateDos();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update DoS entries:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update DoS entries for app: " + t.getMessage(), t);
        }
    }

    @Override
    public void updatePagespeed() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updatePagespeed();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update PageSpeed entries:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update PageSpeed entries for app: " + t.getMessage(), t);
        }
    }

    @Override
    public void setDefaultVersion() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.setDefaultVersion();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to set default version:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to set default version for app: " + t.getMessage(), t);
        }
    }

    @Override
    public List<CronEntry> cronInfo() {
        try {
            ArrayList<CronEntry> result = new ArrayList<CronEntry>();
            CronXml cron = this.app.getCronXml();
            if (cron == null) {
                return result;
            }
            for (CronXml.Entry entry : cron.getEntries()) {
                result.add(new CronEntryImpl(entry.getUrl(), entry.getDescription(), entry.getSchedule(), entry.getTimezone()));
            }
            return result;
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to display run times for cron entries:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to display run times for cron entries for app: " + t.getMessage(), t);
        }
    }

    @Override
    public ResourceLimits getResourceLimits() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            return ResourceLimits.request(connection, this.app);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to get resource limits:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to get resource limits: " + t.getMessage(), t);
        }
    }

    @Override
    public void vacuumIndexes(ConfirmationCallback<IndexDeleter.DeleteIndexAction> callback, UpdateListener listener) {
        String appID = this.app.getAppId();
        if (null == appID || appID.isEmpty()) {
            String message = "This application does not have an ID.";
            String detailMessage = "The vacuum_indexes operation may not be performed for an application that does not have an ID.";
            AdminException e = new AdminException(message);
            listener.onFailure(new UpdateFailureEvent(e, message, detailMessage));
            throw e;
        }
        ServerConnection connection = this.getServerConnection(this.options);
        IndexDeleter deleter = new IndexDeleter(connection, this.app, callback, this.errorWriter, listener);
        try {
            deleter.deleteUnusedIndexes();
        }
        catch (Exception e) {
            String message = "Unable to perform vacuum_indexes";
            listener.onFailure(new UpdateFailureEvent(e, message, e.getMessage()));
            throw new AdminException(message, e);
        }
    }

    @Override
    public Reader requestLogs(int numDays, AppAdmin.LogSeverity severity) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            File logFile = File.createTempFile(this.app.getAppId() + "-" + this.app.getVersion(), ".log");
            logFile.deleteOnExit();
            LogFetcher logFetcher = new LogFetcher(this.app, connection);
            logFetcher.fetch(numDays, severity, new FileOutputStream(logFile));
            return new BufferedReader(new FileReader(logFile));
        }
        catch (Exception ex) {
            throw new AdminException("Unable to retrieve the remote application logs:", ex);
        }
    }

    private void doUpdate(ServerConnection connection, UpdateListener listener, String backend) {
        StringWriter detailsWriter = new StringWriter();
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, backend);
            ResourceLimits resourceLimits = ResourceLimits.request(connection, this.app);
            this.app.resetProgress();
            this.app.setListener(listener);
            this.app.setDetailsWriter(new PrintWriter((Writer)detailsWriter, true));
            this.app.createStagingDirectory(this.appOptions, resourceLimits);
            uploader.doUpload(resourceLimits);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update:");
            t.printStackTrace(this.errorWriter);
            listener.onFailure(new UpdateFailureEvent(t, t.toString(), detailsWriter.toString()));
            throw new AdminException("Unable to update app: " + t.getMessage(), t);
        }
    }

    private AppVersionUpload createAppVersionUpload(ServerConnection connection, GenericApplication app, String backend) throws Exception {
        Constructor<? extends AppVersionUpload> constructor = this.appVersionUploadClass.getConstructor(ServerConnection.class, GenericApplication.class, String.class, Boolean.TYPE);
        return constructor.newInstance(connection, app, backend, this.appOptions.isBatchModeSet());
    }
}

