/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.AppDownload;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.ClientLoginServerConnection;
import com.google.appengine.tools.admin.ConfirmationCallback;
import com.google.appengine.tools.admin.CronEntry;
import com.google.appengine.tools.admin.IndexDeleter;
import com.google.appengine.tools.admin.LoginReader;
import com.google.appengine.tools.admin.LoginReaderFactory;
import com.google.appengine.tools.admin.ResourceLimits;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.admin.ServerConnectionFactory;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.appengine.tools.info.SupportInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.ClientCookieManager;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.BackendsXml;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;

public class AppCfg {
    private final AppAdminFactory.ConnectOptions options;
    private AppCfgAction action;
    private String applicationDirectory;
    private AppAdmin admin;
    private boolean passin;
    private boolean doBatch = true;
    private boolean doJarSplitting = false;
    private Set<String> jarSplittingExcludeSuffixes = null;
    private boolean disablePrompt = false;
    private File logFile = null;
    private String compileEncoding = null;
    private final String prefsEmail;
    private LoginReader loginReader = null;
    private String overrideAppId;
    private String overrideAppVersion;
    private static final String GENERAL_OPTION_HELP = "  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
    private static final String UPDATE_OPTION_HELP = "  --enable_jar_splitting\n                        Split large jar files (> 10M) into smaller fragments.\n  --jar_splitting_excludes=SUFFIXES\n                        When --enable-jar-splitting is set, files that match\n                        the list of comma separated SUFFIXES will be excluded\n                        from all jars.\n  --retain_upload_dir\n                        Do not delete temporary (staging) directory used in\n                        uploading.\n  --compile_encoding\n                        The character encoding to use when compiling JSPs.\n";
    private static final String LOG_OPTION_HELP = "  -n NUM_DAYS, --num_days=NUM_DAYS\n                        Number of days worth of log data to get. The cut-off\n                        point is midnight UTC. Use 0 to get all available\n                        logs. Default is 1.\n  --severity=SEVERITY   Severity of app-level log messages to get. The range\n                        is 0 (DEBUG) through 4 (CRITICAL). If omitted, only\n                        request logs are returned.\n  -a, --append          Append to existing file.\n";
    private static final String CRON_OPTION_HELP = "  -n NUM_RUNS, --num_runs=NUM_RUNS\n                        Number of scheduled execution times to compute\n";
    private static final String VACUUM_OPTIONS_HELP = "  -f, --force           Force deletion of indexes without being prompted.\n";
    private final List<Option> optionParsers = Arrays.asList(new Option("h", "help", true){

        @Override
        public void apply() {
            AppCfg.printHelp();
            System.exit(1);
        }
    }, new Option("s", "server", false){

        @Override
        public void apply() {
            AppCfg.this.options.setServer(this.getValue());
        }
    }, new Option("e", "email", false){

        @Override
        public void apply() {
            AppCfg.this.options.setUserId(this.getValue());
        }
    }, new Option("H", "host", false){

        @Override
        public void apply() {
            AppCfg.this.options.setHost(this.getValue());
        }
    }, new Option("p", "proxy", false){

        @Override
        public void apply() {
            HostPort hostport = new HostPort(this.getValue());
            System.setProperty("http.proxyHost", hostport.getHost());
            if (hostport.hasPort()) {
                System.setProperty("http.proxyPort", hostport.getPort());
            }
        }
    }, new Option(null, "proxy_https", false){

        @Override
        public void apply() {
            HostPort hostport = new HostPort(this.getValue());
            System.setProperty("https.proxyHost", hostport.getHost());
            if (hostport.hasPort()) {
                System.setProperty("https.proxyPort", hostport.getPort());
            }
        }
    }, new Option(null, "insecure", true){

        @Override
        public void apply() {
            AppCfg.this.options.setSecure(false);
        }
    }, new Option("f", "force", true){

        @Override
        public void apply() {
            if (AppCfg.this.action instanceof VacuumIndexesAction) {
                VacuumIndexesAction viAction = (VacuumIndexesAction)AppCfg.this.action;
                viAction.promptUserForEachDelete = false;
            }
        }
    }, new Option("a", "append", true){

        @Override
        public void apply() {
            RequestLogsAction logsAction = (RequestLogsAction)AppCfg.this.action;
            logsAction.append = true;
        }
    }, new Option("n", "num_days", false){

        @Override
        public void apply() {
            if (AppCfg.this.action instanceof RequestLogsAction) {
                RequestLogsAction logsAction = (RequestLogsAction)AppCfg.this.action;
                try {
                    logsAction.numDays = Integer.parseInt(this.getValue());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("num_days must be an integral number.");
                }
            } else {
                CronInfoAction croninfoAction = (CronInfoAction)AppCfg.this.action;
                croninfoAction.setNumRuns(this.getValue());
            }
        }
    }, new Option(null, "num_runs", false){

        @Override
        public void apply() {
            CronInfoAction croninfoAction = (CronInfoAction)AppCfg.this.action;
            croninfoAction.setNumRuns(this.getValue());
        }
    }, new Option(null, "severity", false){

        @Override
        public void apply() {
            RequestLogsAction logsAction = (RequestLogsAction)AppCfg.this.action;
            try {
                int severity = Integer.parseInt(this.getValue());
                int maxSeverity = AppAdmin.LogSeverity.values().length;
                if (severity < 0 || severity > maxSeverity) {
                    throw new IllegalArgumentException("severity must be between 0 and " + maxSeverity);
                }
                logsAction.severity = severity;
            }
            catch (NumberFormatException e) {
                for (AppAdmin.LogSeverity severity : AppAdmin.LogSeverity.values()) {
                    if (!this.getValue().equalsIgnoreCase(severity.toString())) continue;
                    logsAction.severity = severity.ordinal();
                    return;
                }
                throw new IllegalArgumentException("severity must be an integral number 0-4, or one of DEBUG, INFO, WARN, ERROR, CRITICAL");
            }
        }
    }, new Option(null, "sdk_root", false){

        @Override
        public void apply() {
            AppCfg.this.options.setSdkRoot(this.getValue());
        }
    }, new Option(null, "enable_jar_splitting", true){

        @Override
        public void apply() {
            AppCfg.this.doJarSplitting = true;
        }
    }, new Option(null, "jar_splitting_excludes", false){

        @Override
        public void apply() {
            AppCfg.this.jarSplittingExcludeSuffixes = new HashSet<String>(Arrays.asList(this.getValue().split(",")));
        }
    }, new Option(null, "retain_upload_dir", true){

        @Override
        public void apply() {
            AppCfg.this.options.setRetainUploadDir(true);
        }
    }, new Option(null, "passin", true){

        @Override
        public void apply() {
            AppCfg.this.passin = true;
        }
    }, new Option(null, "no_batch", true){

        @Override
        public void apply() {
            AppCfg.this.doBatch = false;
        }
    }, new Option(null, "compile_encoding", false){

        @Override
        public void apply() {
            AppCfg.this.compileEncoding = this.getValue();
        }
    }, new Option(null, "disable_prompt", true){

        @Override
        public void apply() {
            AppCfg.this.disablePrompt = true;
        }
    }, new Option("A", "application", false){

        @Override
        public void apply() {
            AppCfg.this.overrideAppId = this.getValue();
        }
    }, new Option("V", "version", false){

        @Override
        public void apply() {
            AppCfg.this.overrideAppVersion = this.getValue();
        }
    });
    private final List<Action> actions = Arrays.asList(new UpdateAction(), new RequestLogsAction(), new RollbackAction(), new UpdateIndexesAction(), new UpdateCronAction(), new UpdateDosAction(), new UpdatePagespeedAction(), new UpdateQueueAction(), new CronInfoAction(), new VacuumIndexesAction(), new HelpAction(), new DownloadAppAction(), new VersionAction(), new SetDefaultVersionAction(), new ResourceLimitsInfoAction(), new BackendsListAction(), new BackendsRollbackAction(), new BackendsUpdateAction(), new BackendsStartAction(), new BackendsStopAction(), new BackendsDeleteAction(), new BackendsConfigureAction(), new BackendsAction());

    public static void main(String[] args) {
        Logging.initializeLogging();
        new AppCfg(args);
    }

    protected AppCfg(String[] cmdLineArgs) {
        this(new AppAdminFactory(), cmdLineArgs);
    }

    public AppCfg(AppAdminFactory factory, String[] cmdLineArgs) {
        PrintWriter logWriter;
        this.options = new AppAdminFactory.ConnectOptions();
        Parser parser = new Parser();
        try {
            this.logFile = File.createTempFile("appcfg", ".log");
            logWriter = new PrintWriter((Writer)new FileWriter(this.logFile), true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to enable logging.", e);
        }
        String prefsEmail = null;
        try {
            Parser.ParseResult result = parser.parseArgs(this.actions, this.optionParsers, cmdLineArgs);
            this.action = (AppCfgAction)result.getAction();
            try {
                result.applyArgs();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(logWriter);
                System.out.println("Bad argument: " + e.getMessage());
                System.out.println(this.action.getHelpString());
                System.exit(1);
            }
            if (System.getProperty("http.proxyHost") != null && System.getProperty("https.proxyHost") == null) {
                System.setProperty("https.proxyHost", System.getProperty("http.proxyHost"));
                if (System.getProperty("http.proxyPort") != null && System.getProperty("https.proxyPort") == null) {
                    System.setProperty("https.proxyPort", System.getProperty("http.proxyPort"));
                }
            }
            Application app = null;
            if (this.applicationDirectory != null) {
                File appDirectoryFile = new File(this.applicationDirectory);
                AppCfg.validateWarPath(appDirectoryFile);
                UpdateCheck updateCheck = new UpdateCheck(this.options.getServer(), appDirectoryFile, this.options.getSecure());
                updateCheck.maybePrintNagScreen(System.out);
                updateCheck.checkJavaVersion(System.out);
                prefsEmail = this.loadCookies(this.options);
                factory.setBatchMode(this.doBatch);
                factory.setJarSplittingEnabled(this.doJarSplitting);
                if (this.jarSplittingExcludeSuffixes != null) {
                    factory.setJarSplittingExcludes(this.jarSplittingExcludeSuffixes);
                }
                if (this.compileEncoding != null) {
                    factory.setCompileEncoding(this.compileEncoding);
                }
                System.out.println("Reading application configuration data...");
                app = Application.readApplication(this.applicationDirectory, this.overrideAppId, this.overrideAppVersion);
                app.setListener(new UpdateListener(){

                    @Override
                    public void onProgress(UpdateProgressEvent event) {
                        System.out.println(event.getPercentageComplete() + "% " + event.getMessage());
                    }

                    @Override
                    public void onSuccess(UpdateSuccessEvent event) {
                        System.out.println("Operation complete.");
                    }

                    @Override
                    public void onFailure(UpdateFailureEvent event) {
                        System.out.println(event.getFailureMessage());
                    }
                });
                this.admin = factory.createAppAdmin(this.options, app, logWriter);
                System.out.println("Beginning server interaction for " + app.getAppId() + "...");
            } else {
                this.admin = factory.createAppAdmin(this.options, null, logWriter);
            }
            try {
                this.action.execute();
            }
            catch (AdminException ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace(logWriter);
                this.printLogLocation();
                System.exit(1);
            }
            System.out.println("Success.");
            if (app != null) {
                if (!this.options.getRetainUploadDir()) {
                    System.out.println("Cleaning up temporary files...");
                    app.cleanStagingDirectory();
                } else {
                    File stage = app.getStagingDir();
                    if (stage == null) {
                        System.out.println("Temporary staging directory was not needed, and not created");
                    } else {
                        System.out.println("Temporary staging directory left in " + stage.getCanonicalPath());
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(logWriter);
            System.out.println("Bad argument: " + e.getMessage());
            AppCfg.printHelp();
            System.exit(1);
        }
        catch (AppEngineConfigException e) {
            e.printStackTrace(logWriter);
            System.out.println("Bad configuration: " + e.getMessage());
            if (e.getCause() != null) {
                System.out.println("  Caused by: " + e.getCause().getMessage());
            }
            this.printLogLocation();
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("Encountered a problem: " + e.getMessage());
            e.printStackTrace(logWriter);
            this.printLogLocation();
            System.exit(1);
        }
        this.prefsEmail = prefsEmail;
    }

    private void printLogLocation() {
        if (this.logFile != null) {
            System.out.println("Please see the logs [" + this.logFile.getAbsolutePath() + "] for further information.");
        }
    }

    private String loadCookies(final AppAdminFactory.ConnectOptions options) {
        Preferences prefs = Preferences.userNodeForPackage(ServerConnection.class);
        String prefsEmail = prefs.get("email", null);
        if (prefsEmail != null) {
            ClientCookieManager cookies = null;
            byte[] serializedCookies = prefs.getByteArray("cookies", null);
            if (serializedCookies != null) {
                try {
                    cookies = (ClientCookieManager)new ObjectInputStream(new ByteArrayInputStream(serializedCookies)).readObject();
                }
                catch (ClassNotFoundException ex) {
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (options.getUserId() == null || prefsEmail.equals(options.getUserId())) {
                options.setCookies(cookies);
            }
        }
        options.setPasswordPrompt(new AppAdminFactory.PasswordPrompt(){

            @Override
            public String getPassword() {
                AppCfg.this.doPrompt();
                options.setUserId(AppCfg.this.loginReader.getUsername());
                return AppCfg.this.loginReader.getPassword();
            }
        });
        return prefsEmail;
    }

    private void doPrompt() {
        if (this.disablePrompt) {
            System.out.println("Your authentication credentials can't be found and may have expired.\nPlease run appcfg directly from the command line to re-establish your credentials.");
            System.exit(1);
        }
        this.getLoginReader().doPrompt();
    }

    private LoginReader getLoginReader() {
        if (this.loginReader == null) {
            this.loginReader = LoginReaderFactory.createLoginReader(this.options, this.passin, this.prefsEmail);
        }
        return this.loginReader;
    }

    private static void printHelp() {
        String help = "usage: AppCfg [options] <action> [<app-dir>] [<argument>]\n\nAction must be one of:\n  help: Print help for a specific action.\n  download_app: Download a previously uploaded app version.\n  request_logs: Write request logs in Apache common log format.\n  rollback: Rollback an in-progress update.\n  update: Create or update an app version.\n  update_indexes: Update application indexes.\n  update_cron: Update application cron jobs.\n  update_queues: Update application task queue definitions.\n  update_dos: Update application DoS protection configuration.\n  version: Prints version information.\n  set_default_version: Set the default serving version.\n  cron_info: Displays times for the next several runs of each cron job.\n  resource_limits_info: Display resource limits.\n  vacuum_indexes: Delete unused indexes from application.\n  backends list: List the currently configured backends.\n  backends update: Update the specified backend or all backends.\n  backends rollback: Roll back a previously in-progress update.\n  backends start: Start the specified backend.\n  backends stop: Stop the specified backend.\n  backends delete: Delete the specified backend.\n  backends configure: Configure the specified backend.\nUse 'help <action>' for a detailed description.\n\noptions:\n  -h, --help            Show the help message and exit.\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n  --enable_jar_splitting\n                        Split large jar files (> 10M) into smaller fragments.\n  --jar_splitting_excludes=SUFFIXES\n                        When --enable-jar-splitting is set, files that match\n                        the list of comma separated SUFFIXES will be excluded\n                        from all jars.\n  --retain_upload_dir\n                        Do not delete temporary (staging) directory used in\n                        uploading.\n  --compile_encoding\n                        The character encoding to use when compiling JSPs.\n  -n NUM_DAYS, --num_days=NUM_DAYS\n                        Number of days worth of log data to get. The cut-off\n                        point is midnight UTC. Use 0 to get all available\n                        logs. Default is 1.\n  --severity=SEVERITY   Severity of app-level log messages to get. The range\n                        is 0 (DEBUG) through 4 (CRITICAL). If omitted, only\n                        request logs are returned.\n  -a, --append          Append to existing file.\n  -n NUM_RUNS, --num_runs=NUM_RUNS\n                        Number of scheduled execution times to compute\n";
        System.out.println(help);
    }

    private static void validateWarPath(File war) {
        if (!war.exists()) {
            System.out.println("Unable to find the webapp directory " + war);
            AppCfg.printHelp();
            System.exit(1);
        } else if (!war.isDirectory()) {
            System.out.println("appcfg only accepts webapp directories, not war files.");
            AppCfg.printHelp();
            System.exit(1);
        }
    }

    private static class HostPort {
        private String host;
        private String port;

        public HostPort(String hostport) {
            int colon = hostport.indexOf(58);
            this.host = colon < 0 ? hostport : hostport.substring(0, colon);
            this.port = colon < 0 ? "" : hostport.substring(colon + 1);
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public boolean hasPort() {
            return this.port.length() > 0;
        }
    }

    private static class AppCfgVacuumIndexesListener
    extends AppCfgListener {
        AppCfgVacuumIndexesListener() {
            super("vacuum_indexes");
        }
    }

    private static class AppCfgUpdateListener
    extends AppCfgListener {
        AppCfgUpdateListener() {
            super("Update");
        }
    }

    private static class AppCfgListener
    implements UpdateListener {
        private String operationName;

        AppCfgListener(String opName) {
            this.operationName = opName;
        }

        @Override
        public void onProgress(UpdateProgressEvent event) {
            System.out.println(event.getPercentageComplete() + "% " + event.getMessage());
        }

        @Override
        public void onSuccess(UpdateSuccessEvent event) {
            String details = event.getDetails();
            if (details.length() > 0) {
                System.out.println();
                System.out.println("Details:");
                System.out.println(details);
            }
            System.out.println();
            System.out.println(this.operationName + " completed successfully.");
        }

        @Override
        public void onFailure(UpdateFailureEvent event) {
            String details = event.getDetails();
            if (details.length() > 0) {
                System.out.println();
                System.out.println("Error Details:");
                System.out.println(details);
            }
            System.out.println();
            String failMsg = event.getFailureMessage();
            System.out.println(failMsg);
            if (event.getCause() instanceof ClientLoginServerConnection.ClientAuthFailException) {
                System.out.println("Consider using the -e EMAIL option if that email address is incorrect.");
            }
        }
    }

    class BackendsAction
    extends AppCfgAction {
        private AppCfgAction subAction;

        BackendsAction() {
            super("backends");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() < 2) {
                throw new IllegalArgumentException("Expected backends <app-dir> <sub-command> [...]");
            }
            String dir = this.getArgs().get(0);
            String subCommand = this.getArgs().get(1);
            this.subAction = (AppCfgAction)Parser.lookupAction(AppCfg.this.actions, new String[]{"backends", subCommand}, 0);
            if (this.subAction instanceof BackendsAction) {
                throw new IllegalArgumentException("Unknown backends subcommand.");
            }
            ArrayList<String> newArgs = new ArrayList<String>();
            newArgs.add(dir);
            newArgs.addAll(this.getArgs().subList(2, this.getArgs().size()));
            this.subAction.setArgs(newArgs);
            this.subAction.apply();
        }

        @Override
        public void execute() {
            this.subAction.execute();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends list: List the currently configured backends.\nAppCfg [options] backends update: Update the specified backend or all backends.\nAppCfg [options] backends rollback: Roll back a previously in-progress update.\nAppCfg [options] backends start: Start the specified backend.\nAppCfg [options] backends stop: Stop the specified backend.\nAppCfg [options] backends delete: Delete the specified backend.\nAppCfg [options] backends configure: Configure the specified backend.\n";
        }
    }

    class BackendsConfigureAction
    extends AppCfgAction {
        private String backendName;

        BackendsConfigureAction() {
            super("backends", "configure");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            AppCfg.this.admin.configureBackend(this.backendName);
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends configure <app-dir> <backend>\n\nUpdates the configuration of the backend with the specified name, without stopping instances that are currently running.  Only valid for certain settings (instances, options: failfast, options: public).\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class BackendsDeleteAction
    extends AppCfgAction {
        private String backendName;

        BackendsDeleteAction() {
            super("backends", "delete");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            AppCfg.this.admin.deleteBackend(this.backendName);
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends delete\n\nDeletes the specified backend.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class BackendsStopAction
    extends AppCfgAction {
        private String backendName;

        BackendsStopAction() {
            super("backends", "stop");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            AppCfg.this.admin.setBackendState(this.backendName, BackendsXml.State.STOP);
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends stop <app-dir> <backend>\n\nStops the backend with the specified name.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class BackendsStartAction
    extends AppCfgAction {
        private String backendName;

        BackendsStartAction() {
            super("backends", "start");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the backend name");
            }
            this.backendName = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            AppCfg.this.admin.setBackendState(this.backendName, BackendsXml.State.START);
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends start <app-dir> <backend>\n\nStarts the backend with the specified name.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class BackendsUpdateAction
    extends AppCfgAction {
        private String backendName;

        BackendsUpdateAction() {
            super("backends", "update");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() < 1 || this.getArgs().size() > 2) {
                throw new IllegalArgumentException("Expected <app-dir> [<backend-name>]");
            }
            if (this.getArgs().size() == 2) {
                this.backendName = this.getArgs().get(1);
            }
        }

        @Override
        public void execute() {
            if (this.backendName != null) {
                AppCfg.this.admin.updateBackend(this.backendName, new AppCfgUpdateListener());
            } else {
                AppCfg.this.admin.updateAllBackends(new AppCfgUpdateListener());
            }
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends update <app-dir> [<backend-name>]\n\nUpdate the specified backend or all backends.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class BackendsRollbackAction
    extends AppCfgAction {
        private String backendName;

        BackendsRollbackAction() {
            super("backends", "rollback");
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() < 1 || this.getArgs().size() > 2) {
                throw new IllegalArgumentException("Expected <app-dir> [<backend-name>]");
            }
            if (this.getArgs().size() == 2) {
                this.backendName = this.getArgs().get(1);
            }
        }

        @Override
        public void execute() {
            if (this.backendName != null) {
                AppCfg.this.admin.rollbackBackend(this.backendName);
            } else {
                AppCfg.this.admin.rollbackAllBackends();
            }
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends rollback <app-dir> [<backend-name>]\n\nThe 'backends update' command requires a server-side transaction. Use 'backends rollback' if you experience an error during 'backends update' and want to begin a new update transaction.Options:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class BackendsListAction
    extends AppCfgAction {
        BackendsListAction() {
            super("backends", "list");
        }

        @Override
        public void execute() {
            for (BackendsXml.Entry backend : AppCfg.this.admin.listBackends()) {
                System.out.println(backend.toString());
            }
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] backends list <app-dir>\n\nList the currently configured backends.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class ResourceLimitsInfoAction
    extends AppCfgAction {
        public ResourceLimitsInfoAction() {
            super("resource_limits_info");
        }

        @Override
        public void execute() {
            ResourceLimits resourceLimits = AppCfg.this.admin.getResourceLimits();
            for (String key : new TreeSet<String>(resourceLimits.keySet())) {
                System.out.println(key + ": " + resourceLimits.get(key));
            }
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] resource_limits_info <app-dir>\n\nDisplays the resource limits available to the app. An app will\nnot update if any of the app's resources are larger than the\nappropriate resource limit.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class SetDefaultVersionAction
    extends AppCfgAction {
        SetDefaultVersionAction() {
            super("set_default_version");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.setDefaultVersion();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] set_default_version <app-dir>\n\nSets the default (serving) version.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class VersionAction
    extends AppCfgAction {
        VersionAction() {
            super("version");
        }

        @Override
        public void apply() {
            System.out.println(SupportInfo.getVersionString());
            System.exit(0);
        }

        @Override
        public void execute() {
        }

        @Override
        public String getHelpString() {
            return "AppCfg version\n\nPrints version information.\n";
        }
    }

    class DownloadAppAction
    extends AppCfgAction {
        DownloadAppAction() {
            super("download_app");
        }

        @Override
        public void apply() {
            if (this.getArgs().size() != 1) {
                throw new IllegalArgumentException("Expected download directory as an argument after download_app.");
            }
            File downloadDir = new File(this.getArgs().get(0));
            if (AppCfg.this.overrideAppId == null) {
                throw new IllegalArgumentException("You must specify an app ID via -A or --application");
            }
            AppCfg.this.loadCookies(AppCfg.this.options);
            AppDownload appDownload = new AppDownload(ServerConnectionFactory.getServerConnection(AppCfg.this.options), new AppCfgListener("download_app"));
            int exitCode = appDownload.download(AppCfg.this.overrideAppId, AppCfg.this.overrideAppVersion, downloadDir) ? 0 : 1;
            System.exit(exitCode);
        }

        @Override
        public void execute() {
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] -A app_id [ -V version ] download_app <out-dir>\n\nDownload a previously-uploaded app to the specified directory.  The app\nID is specified by the \"-A\" option.  The optional version is specified\nby the \"-V\" option.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class HelpAction
    extends AppCfgAction {
        HelpAction() {
            super("help");
        }

        @Override
        public void apply() {
            if (this.getArgs().isEmpty()) {
                AppCfg.printHelp();
            } else {
                Action foundAction = Parser.lookupAction(AppCfg.this.actions, this.getArgs().toArray(new String[0]), 0);
                if (foundAction == null) {
                    System.out.println("No such command \"" + this.getArgs().get(0) + "\"\n\n");
                    AppCfg.printHelp();
                } else {
                    System.out.println(((AppCfgAction)foundAction).getHelpString());
                }
            }
            System.exit(1);
        }

        @Override
        public void execute() {
        }

        @Override
        public String getHelpString() {
            return "AppCfg help <command>\n\nPrints help about a specific command.\n";
        }
    }

    class VacuumIndexesAction
    extends AppCfgAction {
        public boolean promptUserForEachDelete;

        VacuumIndexesAction() {
            super("vacuum_indexes");
            this.promptUserForEachDelete = true;
        }

        @Override
        public void execute() {
            ConfirmationCallback<IndexDeleter.DeleteIndexAction> callback = null;
            if (this.promptUserForEachDelete) {
                callback = new ConfirmationCallback<IndexDeleter.DeleteIndexAction>(){

                    @Override
                    public ConfirmationCallback.Response confirmAction(IndexDeleter.DeleteIndexAction action) {
                        String response;
                        do {
                            String prompt = "\n" + action.getPrompt() + " (N/y/a): ";
                            System.out.print(prompt);
                            System.out.flush();
                            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                            try {
                                response = in.readLine();
                            }
                            catch (IOException ioe) {
                                response = null;
                            }
                            String string = response = null == response ? "" : response.trim().toLowerCase();
                            if ("y".equals(response)) {
                                return ConfirmationCallback.Response.YES;
                            }
                            if (!"n".equals(response) && !response.isEmpty()) continue;
                            return ConfirmationCallback.Response.NO;
                        } while (!"a".equals(response));
                        return ConfirmationCallback.Response.YES_ALL;
                    }
                };
            }
            AppCfg.this.admin.vacuumIndexes(callback, new AppCfgVacuumIndexesListener());
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] vacuum_indexes <app-dir>\n\nDeletes indexes on the server that are not present in the local\nindex configuration file.  The user is prompted before each delete.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n  -f, --force           Force deletion of indexes without being prompted.\n";
        }
    }

    class CronInfoAction
    extends AppCfgAction {
        int numRuns;

        CronInfoAction() {
            super("cron_info");
            this.numRuns = 5;
        }

        @Override
        public void execute() {
            List<CronEntry> entries = AppCfg.this.admin.cronInfo();
            if (entries.size() == 0) {
                System.out.println("No cron jobs defined.");
            } else {
                System.out.println(entries.size() + " cron entries defined.\n");
                for (CronEntry entry : entries) {
                    System.out.println(entry.toXml());
                    System.out.println("Next " + this.numRuns + " execution times:");
                    Iterator<String> iter = entry.getNextTimesIterator();
                    for (int i = 0; i < this.numRuns; ++i) {
                        System.out.println("  " + iter.next());
                    }
                    System.out.println("");
                }
            }
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] cron_info <app-dir>\n\nDisplays times for the next several runs of each cron job.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n  -n NUM_RUNS, --num_runs=NUM_RUNS\n                        Number of scheduled execution times to compute\n";
        }

        public void setNumRuns(String numberString) {
            try {
                this.numRuns = Integer.parseInt(numberString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("num_runs must be an integral number.");
            }
            if (this.numRuns < 0) {
                throw new IllegalArgumentException("num_runs must be positive.");
            }
        }
    }

    class UpdateQueueAction
    extends AppCfgAction {
        UpdateQueueAction() {
            super("update_queues");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateQueues();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] " + this.getNameString() + " <app-dir>\n\n" + "Updates any new, removed or changed task queue definitions.\n" + "Does not otherwise alter the running application version.\n\n" + "Options:\n" + AppCfg.GENERAL_OPTION_HELP;
        }
    }

    class UpdatePagespeedAction
    extends AppCfgAction {
        UpdatePagespeedAction() {
            super("update_pagespeed");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updatePagespeed();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] update_pagespeed <app-dir>\n\nUpdates the PageSpeed configuration for the server.\nDoes not otherwise alter the running application version.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class UpdateDosAction
    extends AppCfgAction {
        UpdateDosAction() {
            super("update_dos");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateDos();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] update_dos <app-dir>\n\nUpdates the DoS protection configuration for the server.\nDoes not otherwise alter the running application version.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class UpdateCronAction
    extends AppCfgAction {
        UpdateCronAction() {
            super("update_cron");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateCron();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] update_cron <app-dir>\n\nUpdates the cron jobs for the server. Updates any new, removed or changed.\ncron jobs. Does not otherwise alter the running application version.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class UpdateIndexesAction
    extends AppCfgAction {
        UpdateIndexesAction() {
            super("update_indexes");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.updateIndexes();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] update_indexes <app-dir>\n\nUpdates the datastore indexes for the server to add any in the current\napplication directory.  Does not alter the running application version, nor\nremove any existing indexes.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class RollbackAction
    extends AppCfgAction {
        RollbackAction() {
            super("rollback");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.rollback();
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] rollback <app-dir>\n\nThe 'update' command requires a server-side transaction. Use 'rollback' if you experience an error during 'update' and want to begin a new update transaction.Options:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n";
        }
    }

    class RequestLogsAction
    extends AppCfgAction {
        String outputFile;
        int numDays;
        int severity;
        boolean append;

        RequestLogsAction() {
            super("request_logs");
            this.numDays = 1;
            this.severity = -1;
            this.append = false;
        }

        @Override
        public void apply() {
            super.apply();
            if (this.getArgs().size() != 2) {
                throw new IllegalArgumentException("Expected the application directory and log file as arguments after the request_logs action name.");
            }
            this.outputFile = this.getArgs().get(1);
        }

        @Override
        public void execute() {
            Reader reader = AppCfg.this.admin.requestLogs(this.numDays, this.severity >= 0 ? AppAdmin.LogSeverity.values()[this.severity] : null);
            if (reader == null) {
                return;
            }
            BufferedReader r = new BufferedReader(reader);
            PrintWriter writer = null;
            try {
                writer = this.outputFile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(this.outputFile, this.append));
                String line = null;
                while ((line = r.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read logs: " + e);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] request_logs <app-dir> <output-file>\n\nPopulates the output-file with recent logs from the application.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n  -n NUM_DAYS, --num_days=NUM_DAYS\n                        Number of days worth of log data to get. The cut-off\n                        point is midnight UTC. Use 0 to get all available\n                        logs. Default is 1.\n  --severity=SEVERITY   Severity of app-level log messages to get. The range\n                        is 0 (DEBUG) through 4 (CRITICAL). If omitted, only\n                        request logs are returned.\n  -a, --append          Append to existing file.\n";
        }
    }

    class UpdateAction
    extends AppCfgAction {
        UpdateAction() {
            super("update");
        }

        @Override
        public void execute() {
            AppCfg.this.admin.update(new AppCfgUpdateListener());
        }

        @Override
        public String getHelpString() {
            return "AppCfg [options] update <app-dir>\n\nInstalls a new version of the application onto the server, as the\ndefault version for end users.\n\nOptions:\n  -s SERVER, --server=SERVER\n                        The server to connect to.\n  -e EMAIL, --email=EMAIL\n                        The username to use. Will prompt if omitted.\n  -H HOST, --host=HOST  Overrides the Host header sent with all RPCs.\n  -p PROXYHOST[:PORT], --proxy=PROXYHOST[:PORT]\n                        Proxies requests through the given proxy server.\n                        If --proxy_https is also set, only HTTP will be\n                        proxied here, otherwise both HTTP and HTTPS will.\n  --proxy_https=PROXYHOST[:PORT]\n                        Proxies HTTPS requests through the given proxy server.\n  --sdk_root=root       Overrides where the SDK is located.\n  --passin              Always read the login password from stdin.\n  --insecure            Do not use HTTPS to communicate with the Admin Console.\n  -A APP_ID, --application=APP_ID\n                        Override application id from appengine-web.xml.\n  -V VERSION, --version=VERSION\n                        Override (major) version from appengine-web.xml.\n  --enable_jar_splitting\n                        Split large jar files (> 10M) into smaller fragments.\n  --jar_splitting_excludes=SUFFIXES\n                        When --enable-jar-splitting is set, files that match\n                        the list of comma separated SUFFIXES will be excluded\n                        from all jars.\n  --retain_upload_dir\n                        Do not delete temporary (staging) directory used in\n                        uploading.\n  --compile_encoding\n                        The character encoding to use when compiling JSPs.\n";
        }
    }

    abstract class AppCfgAction
    extends Action {
        AppCfgAction(String ... names) {
            super(names);
        }

        @Override
        protected void setArgs(List<String> args) {
            super.setArgs(args);
        }

        @Override
        public void apply() {
            if (this.getArgs().size() < 1) {
                throw new IllegalArgumentException("Expected the application directory as an argument after the action name.");
            }
            AppCfg.this.applicationDirectory = this.getArgs().get(0);
        }

        public abstract void execute();

        public abstract String getHelpString();
    }
}

