/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ConnectionManager;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.ResourceType;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.management.ManagementManager;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.management.runtime.ConnectionManagerRuntime;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManagerImpl
implements ConnectionManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    OMFContext omfContext;
    ManagedConnectionPool connectionPool = new ManagedConnectionPool();
    ConnectionManagerRuntime connMgrRuntime = null;

    public ConnectionManagerImpl(OMFContext omfContext) {
        this.omfContext = omfContext;
        if (omfContext.getJMXManager() != null) {
            ManagementManager mgmtMgr = this.omfContext.getJMXManager();
            ManagementServer mgmtServer = mgmtMgr.getManagementServer();
            this.connMgrRuntime = new ConnectionManagerRuntime();
            String mbeanName = mgmtMgr.getDomainName() + ":InstanceName=" + mgmtMgr.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.connMgrRuntime.getClass()) + ",Name=ConnectionManagerRuntime";
            mgmtServer.registerMBean(this.connMgrRuntime, mbeanName);
        }
    }

    @Override
    public ManagedConnection allocateConnection(ConnectionFactory factory, ObjectManager om, Map options) {
        ManagedConnection mconnFromPool;
        if (om != null && (mconnFromPool = this.connectionPool.getManagedConnection(factory, om)) != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug("Connection found in the pool : " + mconnFromPool);
            }
            return mconnFromPool;
        }
        Map<String, Object> txOptions = options;
        if (options == null && om != null) {
            txOptions = om.getTransaction().getOptions();
        }
        ManagedConnection mconn = factory.createManagedConnection(om, txOptions);
        this.configureManagedConnectionListener(om, mconn, factory);
        if (om != null) {
            if (om.getTransaction().isActive()) {
                this.configureTransactionEventListener(om, mconn);
                Transaction tx = this.omfContext.getTransactionManager().getTransaction(om);
                mconn.setManagedResource();
                this.enlistResource(mconn, tx, options);
            }
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug("Connection added to the pool : " + mconn);
            }
            this.connectionPool.putManagedConnection(factory, om, mconn);
        }
        return mconn;
    }

    private void configureManagedConnectionListener(final ObjectManager om, final ManagedConnection mconn, final ConnectionFactory factory) {
        mconn.addListener(new ManagedConnectionResourceListener(){

            public void managedConnectionPostClose() {
                if (om != null) {
                    if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                        NucleusLogger.CONNECTION.debug("Connection removed from the pool : " + mconn);
                    }
                    ConnectionManagerImpl.this.connectionPool.removeManagedConnection(factory, om);
                }
            }

            public void managedConnectionPreClose() {
            }

            public void managedConnectionFlushed() {
            }

            public void resourcePostClose() {
            }
        });
    }

    private void configureTransactionEventListener(final ObjectManager om, final ManagedConnection mconn) {
        om.getTransaction().addTransactionEventListener(new TransactionEventListener(){

            public void transactionStarted() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionRolledBack() {
                try {
                    mconn.close();
                }
                finally {
                    om.getTransaction().removeTransactionEventListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionCommitted() {
                try {
                    mconn.close();
                }
                finally {
                    om.getTransaction().removeTransactionEventListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionEnded() {
                try {
                    mconn.close();
                }
                finally {
                    om.getTransaction().removeTransactionEventListener(this);
                }
            }

            public void transactionPreCommit() {
                if (mconn.isLocked()) {
                    throw new NucleusUserException(LOCALISER.msg("009000"));
                }
            }

            public void transactionPreRollBack() {
                if (mconn.isLocked()) {
                    throw new NucleusUserException(LOCALISER.msg("009000"));
                }
            }

            public void transactionFlushed() {
                mconn.flush();
            }
        });
    }

    private void enlistResource(ManagedConnection mconn, Transaction tx, Map<String, Object> options) {
        XAResource res = mconn.getXAResource();
        if (res != null) {
            boolean enlistInLocalTM = true;
            if (options != null && options.get("resource-type") != null && ResourceType.JTA.toString().equalsIgnoreCase((String)options.get("resource-type"))) {
                enlistInLocalTM = false;
            }
            if (enlistInLocalTM) {
                tx.enlistResource(res);
            }
        }
    }

    class ManagedConnectionPool {
        Map<ObjectManager, Map<ConnectionFactory, ManagedConnection>> connectionsPool = new HashMap<ObjectManager, Map<ConnectionFactory, ManagedConnection>>();

        ManagedConnectionPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagedConnection(ConnectionFactory factory, ObjectManager om) {
            Map<ObjectManager, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(om);
                if (connectionsForOM != null) {
                    if (connectionsForOM.remove(factory) != null && ConnectionManagerImpl.this.connMgrRuntime != null) {
                        ConnectionManagerImpl.this.connMgrRuntime.decrementActiveConnections();
                    }
                    if (connectionsForOM.size() == 0) {
                        this.connectionsPool.remove(om);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedConnection getManagedConnection(ConnectionFactory factory, ObjectManager om) {
            Map<ObjectManager, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(om);
                if (connectionsForOM == null) {
                    return null;
                }
                ManagedConnection mconn = connectionsForOM.get(factory);
                if (mconn != null) {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(LOCALISER.msg("009000"));
                    }
                    return mconn;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putManagedConnection(ConnectionFactory factory, ObjectManager om, ManagedConnection mconn) {
            Map<ObjectManager, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(om);
                if (connectionsForOM == null) {
                    connectionsForOM = new HashMap<ConnectionFactory, ManagedConnection>();
                    this.connectionsPool.put(om, connectionsForOM);
                }
                if (connectionsForOM.put(factory, mconn) == null && ConnectionManagerImpl.this.connMgrRuntime != null) {
                    ConnectionManagerImpl.this.connMgrRuntime.incrementActiveConnections();
                }
            }
        }
    }
}

