/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.dev.CreationCostAnalysis;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DatastoreViewerServlet
extends HttpServlet {
    private static final String APPLICATION_NAME = "applicationName";
    private static final String NAMESPACE = "namespace";
    private static final String KIND = "kind";
    private static final String SELECTED_KIND_PROPS = "props";
    private static final String ALL_KINDS = "kinds";
    private static final String START = "start";
    private static final String NUM_PER_PAGE = "numPerPage";
    private static final String ENTITIES = "entities";
    private static final String NUM_ENTITIES = "numEntities";
    private static final String START_BASE_URL = "startBaseURL";
    private static final String ORDER_BASE_URL = "orderBaseURL";
    private static final String ORDER = "order";
    private static final String DELETE_ACTION = "Delete";
    private static final String ACTION = "action";
    private static final String NUM_KEYS = "numkeys";
    private static final String KEY = "key";
    private static final String PAGES = "pages";
    private static final String CURRENT_PAGE = "currentPage";
    private static final String PREV_START = "prevStart";
    private static final String NEXT_START = "nextStart";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String INDEXES = "indexes";
    private static final int MAX_PAGER_LINKS = 8;
    private LocalDatastoreService localDatastoreService;

    public void init() throws ServletException {
        super.init();
        ApiProxyLocal apiProxyLocal = (ApiProxyLocal)this.getServletContext().getAttribute("com.google.appengine.devappserver.ApiProxyLocal");
        this.localDatastoreService = (LocalDatastoreService)apiProxyLocal.getService("datastore_v3");
    }

    private static String urlencode(String val) throws UnsupportedEncodingException {
        return URLEncoder.encode(val, "UTF-8");
    }

    private static int getIntParam(ServletRequest request, String paramName, int defaultVal) {
        String val = request.getParameter(paramName);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    private static String filterURL(HttpServletRequest req, String ... paramsToInclude) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(req.getRequestURI() + "?");
        for (String arg : paramsToInclude) {
            String value = req.getParameter(arg);
            if (value == null) continue;
            sb.append(String.format("&%s=%s", arg, DatastoreViewerServlet.urlencode(value)));
        }
        return sb.toString();
    }

    List<String> getKinds() {
        ArrayList<String> kinds = new ArrayList<String>();
        DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
        Query q = new Query("__kind__").addSort("__key__", Query.SortDirection.ASCENDING);
        for (Entity e : ds.prepare(q).asIterable()) {
            kinds.add(e.getKey().getName());
        }
        return kinds;
    }

    List<String> getProperties(String kind) throws UnsupportedEncodingException {
        ArrayList<String> properties = new ArrayList<String>();
        DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
        Key kindKey = KeyFactory.createKey((String)"__kind__", (String)kind);
        Query q = new Query("__property__").setKeysOnly().setAncestor(kindKey).addSort("__key__", Query.SortDirection.ASCENDING);
        for (Entity e : ds.prepare(q).asIterable()) {
            properties.add(DatastoreViewerServlet.urlencode(e.getKey().getName()));
        }
        return properties;
    }

    List<EntityView> getEntityViews(String kind, String order, int start, int numPerPage) {
        ArrayList<EntityView> entityViews = new ArrayList<EntityView>();
        Query q = new Query(kind);
        Query.SortDirection dir = Query.SortDirection.ASCENDING;
        if (order != null) {
            if (order.charAt(0) == '-') {
                dir = Query.SortDirection.DESCENDING;
                order = order.substring(1);
            }
            q.addSort(order, dir);
        }
        DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
        FetchOptions opts = FetchOptions.Builder.withOffset((int)start).limit(numPerPage);
        for (Entity e : ds.prepare(q).asIterable(opts)) {
            CreationCostAnalysis costAnalysis = this.localDatastoreService.getCreationCostAnalysis(e);
            entityViews.add(new EntityView(e, costAnalysis));
        }
        return entityViews;
    }

    private int countForKind(String kind) {
        DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
        return ds.prepare(new Query(kind)).countEntities();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String subsectionStr = req.getParameter("subsection");
        Subsection subsection = Subsection.datastoreViewer;
        if (subsectionStr != null) {
            subsection = Subsection.valueOf(subsectionStr);
        }
        switch (subsection) {
            case datastoreViewer: {
                this.doGetDatastoreViewer(req, resp);
                break;
            }
            case entityDetails: {
                this.doGetEntityDetails(req, resp);
                break;
            }
            case indexDetails: {
                this.doGetIndexes(req, resp);
                break;
            }
            default: {
                resp.sendError(404);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetIndexes(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestedNamespace = req.getParameter(NAMESPACE);
        String namespace = requestedNamespace != null ? requestedNamespace : "";
        String savedNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)namespace);
            DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
            Map indexes = ds.getIndexes();
            req.setAttribute(INDEXES, (Object)indexes);
            req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
            try {
                this.getServletContext().getRequestDispatcher("/_ah/adminConsole?subsection=" + Subsection.indexDetails.name()).forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (ServletException e) {
                throw new RuntimeException("Could not forward request", e);
            }
        }
        finally {
            NamespaceManager.set((String)savedNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetDatastoreViewer(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int start = DatastoreViewerServlet.getIntParam((ServletRequest)req, START, 0);
        int numPerPage = DatastoreViewerServlet.getIntParam((ServletRequest)req, NUM_PER_PAGE, 10);
        String requestedNamespace = req.getParameter(NAMESPACE);
        String selectedKind = req.getParameter(KIND);
        String namespace = requestedNamespace != null ? requestedNamespace : "";
        String savedNamespace = NamespaceManager.get();
        ArrayList<EntityView> entities = new ArrayList();
        List<Object> kinds = new ArrayList();
        ArrayList<String> props = new ArrayList();
        int countForKind = 0;
        try {
            NamespaceManager.set((String)namespace);
            kinds = this.getKinds();
            if (kinds.contains(selectedKind)) {
                props = this.getProperties(selectedKind);
                entities = this.getEntityViews(selectedKind, req.getParameter(ORDER), start, numPerPage);
                countForKind = this.countForKind(selectedKind);
            }
        }
        catch (IllegalArgumentException e) {
            req.setAttribute(ERROR_MESSAGE, (Object)("Error: " + e.getMessage()));
            selectedKind = null;
        }
        finally {
            NamespaceManager.set((String)savedNamespace);
        }
        Collections.sort(kinds);
        int currentPage = start / numPerPage;
        int numPages = (int)Math.ceil((double)countForKind * (1.0 / (double)numPerPage));
        int pageStart = (int)Math.max(Math.floor(currentPage - 4), 0.0);
        int pageEnd = Math.min(pageStart + 8, numPages);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = pageStart + 1; i < pageEnd + 1; ++i) {
            pages.add(new Page(i, (i - 1) * numPerPage));
        }
        this.setDatastoreViewerAttributes(req, kinds, props, entities, countForKind, pages, currentPage + 1, numPerPage, numPages, requestedNamespace);
        try {
            this.getServletContext().getRequestDispatcher("/_ah/adminConsole?subsection=" + Subsection.datastoreViewer.name()).forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    private void doGetEntityDetails(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String key = req.getParameter(KEY);
        String keyName = null;
        Long keyId = null;
        String kind = null;
        String parentKey = null;
        String parentKind = null;
        if (key != null) {
            Entity e;
            Key k = KeyFactory.stringToKey((String)key);
            if (k.getName() != null) {
                keyName = k.getName();
            } else {
                keyId = k.getId();
            }
            kind = k.getKind();
            if (k.getParent() != null) {
                parentKey = KeyFactory.keyToString((Key)k.getParent());
                parentKind = k.getParent().getKind();
            }
            DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
            try {
                e = ds.get(KeyFactory.stringToKey((String)key));
            }
            catch (EntityNotFoundException e1) {
                throw new RuntimeException("Could not locate entity " + key);
            }
            CreationCostAnalysis creationCostAnalysis = this.localDatastoreService.getCreationCostAnalysis(e);
            req.setAttribute("entity", (Object)new EntityDetailsView(e, creationCostAnalysis));
        }
        String url = String.format("/_ah/adminConsole?subsection=entityDetails&key=%s&keyName=%s&keyId=%d&kind=%s&parentKey=%s&parentKind=%s", key, keyName, keyId, kind, parentKey, parentKind);
        try {
            this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (DELETE_ACTION.equals(req.getParameter(ACTION))) {
            this.deleteEntities(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void deleteEntities(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        DatastoreService ds = DatastoreServiceFactory.getDatastoreService();
        int numDeleted = 0;
        int numKeys = Integer.parseInt(req.getParameter(NUM_KEYS));
        for (int i = 1; i <= numKeys; ++i) {
            String key = req.getParameter(KEY + i);
            if (key == null) continue;
            ds.delete(new Key[]{KeyFactory.stringToKey((String)key)});
            ++numDeleted;
        }
        String message = String.format("%d entit%s deleted.", numDeleted, numDeleted == 1 ? "y" : "ies");
        resp.sendRedirect(String.format("%s&msg=%s", req.getParameter("next"), DatastoreViewerServlet.urlencode(message)));
    }

    private void setDatastoreViewerAttributes(HttpServletRequest req, List<String> kinds, List<String> props, List<EntityView> entities, int countForKind, List<Page> pages, int nextPage, int num, int numPages, String namespace) throws UnsupportedEncodingException {
        req.setAttribute(ALL_KINDS, kinds);
        req.setAttribute(SELECTED_KIND_PROPS, props);
        req.setAttribute(ENTITIES, entities);
        req.setAttribute(NUM_ENTITIES, (Object)countForKind);
        req.setAttribute(START_BASE_URL, (Object)DatastoreViewerServlet.filterURL(req, NAMESPACE, KIND, ORDER, NUM_ENTITIES));
        req.setAttribute(ORDER_BASE_URL, (Object)DatastoreViewerServlet.filterURL(req, NAMESPACE, KIND, NUM_ENTITIES));
        req.setAttribute(NAMESPACE, (Object)namespace);
        req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
        req.setAttribute(PAGES, pages);
        req.setAttribute(CURRENT_PAGE, (Object)nextPage);
        req.setAttribute(NUM_PER_PAGE, (Object)num);
        req.setAttribute(PREV_START, (Object)(nextPage > 1 ? (nextPage - 2) * num : -1));
        req.setAttribute(NEXT_START, (Object)(nextPage < numPages ? nextPage * num : -1));
    }

    public static class EntityDetailsView
    extends EntityView {
        private final Map<String, String> propertyTypes;
        private final List<String> sortedPropertyNames;

        EntityDetailsView(Entity e, CreationCostAnalysis creationCostAnalysis) {
            super(e, creationCostAnalysis);
            this.propertyTypes = EntityDetailsView.buildPropertyTypesMap(e);
            this.sortedPropertyNames = EntityDetailsView.buildSortedPropertyNameList(e);
        }

        public Map<String, String> getPropertyTypes() {
            return this.propertyTypes;
        }

        public List<String> getSortedPropertyNames() {
            return this.sortedPropertyNames;
        }

        private static List<String> buildSortedPropertyNameList(Entity e) {
            ArrayList<String> result = new ArrayList<String>(e.getProperties().keySet());
            Collections.sort(result);
            return result;
        }

        private static Map<String, String> buildPropertyTypesMap(Entity e) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String prop : e.getProperties().keySet()) {
                result.put(prop, "TODO");
            }
            return result;
        }
    }

    public static class EntityView {
        private final String key;
        private final String idOrName;
        private final String editURI;
        private final CreationCostAnalysis creationCostAnalysis;
        private final Map<String, Object> properties;

        EntityView(Entity e, CreationCostAnalysis creationCostAnalysis) {
            this.key = KeyFactory.keyToString((Key)e.getKey());
            this.idOrName = e.getKey().getName() == null ? Long.toString(e.getKey().getId()) : e.getKey().getName();
            this.creationCostAnalysis = creationCostAnalysis;
            this.properties = e.getProperties();
            this.editURI = "/_ah/admin/datastore?subsection=" + Subsection.entityDetails.name() + "&key=" + this.key;
        }

        public String getKey() {
            return this.key;
        }

        public String getIdOrName() {
            return this.idOrName;
        }

        public CreationCostAnalysis getCreationCostAnalysis() {
            return this.creationCostAnalysis;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public String getEditURI() {
            return this.editURI;
        }
    }

    public static final class Page {
        private final int number;
        private final int start;

        private Page(int number, int start) {
            this.number = number;
            this.start = start;
        }

        public int getNumber() {
            return this.number;
        }

        public int getStart() {
            return this.start;
        }
    }

    private static enum Subsection {
        datastoreViewer,
        entityDetails,
        indexDetails;

    }
}

