/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import java.util.regex.Pattern;

public final class NamespaceManager {
    private static final int NAMESPACE_MAX_LENGTH = 100;
    private static final String NAMESPACE_REGEX = "[0-9A-Za-z._-]{0,100}";
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[0-9A-Za-z._-]{0,100}");
    private static final String CURRENT_NAMESPACE_KEY = NamespaceManager.class.getName() + ".currentNamespace";
    private static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";

    public static void set(String newNamespace) {
        if (newNamespace == null) {
            ApiProxy.getCurrentEnvironment().getAttributes().remove(CURRENT_NAMESPACE_KEY);
        } else {
            NamespaceManager.validateNamespace(newNamespace);
            ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
            environment.getAttributes().put(CURRENT_NAMESPACE_KEY, newNamespace);
        }
    }

    public static String get() {
        Map<String, Object> attributes = ApiProxy.getCurrentEnvironment().getAttributes();
        return (String)attributes.get(CURRENT_NAMESPACE_KEY);
    }

    public static String getGoogleAppsNamespace() {
        Map<String, Object> attributes = ApiProxy.getCurrentEnvironment().getAttributes();
        String appsNamespace = (String)attributes.get(APPS_NAMESPACE_KEY);
        return appsNamespace == null ? "" : appsNamespace;
    }

    public static void validateNamespace(String namespace) {
        if (!NAMESPACE_PATTERN.matcher(namespace).matches()) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' does not match pattern '" + NAMESPACE_PATTERN + "'.");
        }
    }

    private NamespaceManager() {
    }
}

