/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

@GoogleInternal
public final class BooleanArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean[] list;
    private int length;

    @Deprecated
    public BooleanArray() {
        this.list = new boolean[4];
        this.length = 0;
    }

    @Deprecated
    public BooleanArray(int capacity) {
        this.list = new boolean[capacity];
        this.length = 0;
    }

    public BooleanArray(boolean[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new boolean[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private BooleanArray(boolean[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static BooleanArray newInstance(boolean ... array) {
        Preconditions.checkNotNull(array);
        return new BooleanArray(array, array.length);
    }

    @Deprecated
    public static BooleanArray newInstance(boolean[] array, int length) {
        Preconditions.checkNotNull(array);
        Preconditions.checkArgument(length >= 0 && length <= array.length);
        return new BooleanArray(array, length);
    }

    public int size() {
        return this.length;
    }

    public boolean get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void set(int i, boolean x) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = x;
    }

    public void add(boolean x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    public void prependSlow(boolean x) {
        this.ensureCapacity(this.length + 1);
        System.arraycopy(this.list, 0, this.list, 1, this.length);
        this.list[0] = x;
        ++this.length;
    }

    public void add(boolean[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(BooleanArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    public void removeLast() {
        X.assertTrue(this.length > 0);
        --this.length;
    }

    public boolean pop() {
        X.assertTrue(this.length > 0);
        return this.list[--this.length];
    }

    public void removeFast(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = this.list[this.length - 1];
        this.removeLast();
    }

    public int indexOf(boolean element) {
        for (int i = 0; i < this.length; ++i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public void removeSlow(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        System.arraycopy(this.list, i + 1, this.list, i, this.length - (i + 1));
        --this.length;
    }

    public void replaceSlow(int start, int rangelen, BooleanArray other) {
        X.assertTrue(other.list != this.list);
        int end = start + rangelen;
        X.assertTrue(start >= 0 && end <= this.length);
        this.ensureCapacity(this.length - rangelen + other.length);
        if (end < this.length) {
            System.arraycopy(this.list, end, this.list, start + other.length, this.length - end);
        }
        System.arraycopy(other.list, 0, this.list, start, other.length);
        this.length = this.length - rangelen + other.length;
    }

    public void ensureCapacity(int n) {
        if (this.list.length < n) {
            int new_size = this.list.length * 2;
            if (new_size < n) {
                new_size = n;
            }
            boolean[] copy = new boolean[new_size];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public boolean[] rep() {
        return this.list;
    }

    public void resize(int n) {
        X.assertTrue(n >= 0);
        this.ensureCapacity(n);
        this.length = n;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    public void swap(BooleanArray other) {
        int tmp_length = this.length;
        this.length = other.length;
        other.length = tmp_length;
        boolean[] tmp_list = this.list;
        this.list = other.list;
        other.list = tmp_list;
    }

    public boolean[] toArray() {
        boolean[] copy = new boolean[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }

    public boolean[] subArray(int start, int len) {
        X.assertTrue(start >= 0);
        X.assertTrue(start + len <= this.length);
        boolean[] copy = new boolean[len];
        System.arraycopy(this.list, start, copy, 0, len);
        return copy;
    }

    public void copy(boolean[] dest, int len, int src_pos, int dest_pos) {
        X.assertTrue(src_pos >= 0);
        X.assertTrue(dest_pos >= 0);
        X.assertTrue(len >= 0);
        X.assertTrue(src_pos + len <= this.length);
        X.assertTrue(dest_pos + len <= dest.length);
        System.arraycopy(this.list, src_pos, dest, dest_pos, len);
    }
}

