/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.util.Localiser;

public class StringIndexOfMethodEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return new Integer(-1);
        }
        if (!(invokedValue instanceof String)) {
            throw new NucleusException(LOCALISER.msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        String arg1 = null;
        Object arg1Obj = null;
        Object param = expr.getArguments().get(0);
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            arg1Obj = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            arg1Obj = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof Literal) {
            arg1Obj = ((Literal)param).getLiteral();
        } else {
            throw new NucleusException(method + "(param[, num1]) where param is instanceof " + param.getClass().getName() + " not supported");
        }
        arg1 = QueryUtils.getStringValue(arg1Obj);
        Integer result = null;
        if (expr.getArguments().size() == 2) {
            Literal param2;
            param = expr.getArguments().get(1);
            int arg2 = -1;
            if (param instanceof Literal) {
                param2 = (Literal)expr.getArguments().get(1);
                if (!(param2.getLiteral() instanceof Number)) {
                    throw new NucleusException(method + "(param1, param2) : param2 must be numeric!");
                }
            } else {
                throw new NucleusException(method + "(param1, param2) where param2 is instanceof " + param.getClass().getName() + " not supported");
            }
            arg2 = ((Number)param2.getLiteral()).intValue();
            result = new Integer(((String)invokedValue).indexOf(arg1, arg2));
        } else {
            result = new Integer(((String)invokedValue).indexOf(arg1));
        }
        return result;
    }

    public boolean supportsType(Class cls) {
        if (cls == null) {
            return false;
        }
        return String.class.isAssignableFrom(cls);
    }
}

