/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.identifier;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierCase;
import org.datanucleus.store.mapped.identifier.ColumnIdentifier;
import org.datanucleus.store.mapped.identifier.JPOXIdentifierFactory;

public class JPOX2IdentifierFactory
extends JPOXIdentifierFactory {
    public JPOX2IdentifierFactory(DatastoreAdapter dba, ClassLoaderResolver clr, Map props) {
        super(dba, clr, props);
    }

    public DatastoreIdentifier newJoinTableFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (destinationId != null) {
            return this.newDatastoreFieldIdentifier(destinationId.getIdentifierName(), embedded, fieldRole);
        }
        String baseName = null;
        baseName = fieldRole == 3 ? "ELEMENT" : (fieldRole == 4 ? "ELEMENT" : (fieldRole == 5 ? "KEY" : (fieldRole == 6 ? "VALUE" : "UNKNOWN")));
        return this.newDatastoreFieldIdentifier(baseName);
    }

    public DatastoreIdentifier newForeignKeyFieldIdentifier(AbstractMemberMetaData ownerFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (fieldRole == 1) {
            return this.newDatastoreFieldIdentifier(ownerFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole);
        }
        if (fieldRole == 7) {
            return this.newDatastoreFieldIdentifier(ownerFmd.getName(), embedded, fieldRole);
        }
        throw new NucleusException("DatastoreField role " + fieldRole + " not supported by this method").setFatal();
    }

    public DatastoreIdentifier newVersionFieldIdentifier() {
        String name = "VERSION";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newIndexFieldIdentifier(AbstractMemberMetaData mmd) {
        String name = "IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newAdapterIndexFieldIdentifier() {
        return this.newIndexFieldIdentifier(null);
    }

    public String generateIdentifierNameForJavaName(String javaName) {
        if (javaName == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < javaName.length(); ++i) {
            char c = javaName.charAt(i);
            if (c >= 'A' && c <= 'Z' && this.identifierCase != IdentifierCase.MIXED_CASE && this.identifierCase != IdentifierCase.MIXED_CASE_QUOTED) {
                s.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z' && (this.identifierCase == IdentifierCase.MIXED_CASE || this.identifierCase == IdentifierCase.MIXED_CASE_QUOTED)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && (this.identifierCase == IdentifierCase.MIXED_CASE || this.identifierCase == IdentifierCase.MIXED_CASE_QUOTED)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && this.identifierCase != IdentifierCase.MIXED_CASE && this.identifierCase != IdentifierCase.MIXED_CASE_QUOTED) {
                s.append((char)(c - 32));
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                s.append(c);
                continue;
            }
            if (c == '.') {
                s.append(this.wordSeparator);
                continue;
            }
            String cval = "000" + Integer.toHexString(c);
            s.append(cval.substring(cval.length() - (c > '\u00ff' ? 4 : 2)));
        }
        while (s.length() > 0 && s.charAt(0) == '_') {
            s.deleteCharAt(0);
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("Illegal Java identifier: " + javaName);
        }
        return s.toString();
    }
}

