/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import java.math.BigInteger;

/**
 * Representation of a Substring expression in a Query.
 *
 * @version $Revision: 1.8 $
 **/
public class SubstringExpression extends StringExpression
{
    /**
     * Constructs the substring
     * @param str the String Expression
     * @param begin The start position
     **/   
    public SubstringExpression(StringExpression str, NumericExpression begin)
    {
        super(str.getQueryExpression());

        st.append("SUBSTRING(").append(str).append(" FROM ")
            .append(begin.add(new IntegerLiteral(qs, mapping, BigInteger.ONE)))
            .append(')');
    }

    /**
     * Constructs the substring
     * @param str the String Expression
     * @param begin The start position
     * @param end The end position expression
     **/   
    public SubstringExpression(StringExpression str, NumericExpression begin, NumericExpression end)
    {
        super(str.getQueryExpression());

        st.append("SUBSTRING(").append(str).append(" FROM ")
            .append(begin.add(new IntegerLiteral(qs, mapping, BigInteger.ONE)))
            .append(" FOR ").append(end.sub(begin)).append(')');
    }
}
