/**********************************************************************
Copyright (c) 2012 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.metadata;

import java.io.Serializable;

/**
 * Mode of usage of a stored procedure query parameter.
 */
public class StoredProcQueryParameterMode implements Serializable
{
    public static final StoredProcQueryParameterMode IN = new StoredProcQueryParameterMode(0);
    public static final StoredProcQueryParameterMode OUT = new StoredProcQueryParameterMode(1);
    public static final StoredProcQueryParameterMode INOUT = new StoredProcQueryParameterMode(2);
    public static final StoredProcQueryParameterMode REF_CURSOR = new StoredProcQueryParameterMode(3);

    private final int typeId;

    private StoredProcQueryParameterMode(int i)
    {
        this.typeId = i;
    }

    public int hashCode()
    {
        return typeId;
    }

    public boolean equals(Object o)
    {
        if (o instanceof StoredProcQueryParameterMode)
        {
            return ((StoredProcQueryParameterMode)o).typeId == typeId;
        }
        return false;
    }

    public String toString()
    {
        switch (typeId)
        {
            case 0 :
                return "IN";
            case 1 :
                return "OUT";
            case 2 :
                return "INOUT";
            case 3 :
                return "REF_CURSOR";
        }
        return "";
    }

    protected int getType()
    {
        return typeId;
    }

    public static StoredProcQueryParameterMode getMode(final String value)
    {
        if (value == null)
        {
            return null;
        }
        else if (StoredProcQueryParameterMode.IN.toString().equalsIgnoreCase(value))
        {
            return StoredProcQueryParameterMode.IN;
        }
        else if (StoredProcQueryParameterMode.OUT.toString().equalsIgnoreCase(value))
        {
            return StoredProcQueryParameterMode.OUT;
        }
        else if (StoredProcQueryParameterMode.INOUT.toString().equalsIgnoreCase(value))
        {
            return StoredProcQueryParameterMode.INOUT;
        }
        else if (StoredProcQueryParameterMode.REF_CURSOR.toString().equalsIgnoreCase(value))
        {
            return StoredProcQueryParameterMode.REF_CURSOR;
        }
        return null;
    }
}