/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Collection;
import javax.jdo.JDOCanRetryException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOQueryInterruptedException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.jdo.JDOQueryCache;
import org.datanucleus.api.jdo.JDOReplicationManager;
import org.datanucleus.api.jdo.exceptions.ClassNotPersistenceCapableException;
import org.datanucleus.api.jdo.exceptions.NoPersistenceInformationException;
import org.datanucleus.api.jdo.exceptions.TransactionNotActiveException;
import org.datanucleus.api.jdo.exceptions.TransactionNotReadableException;
import org.datanucleus.api.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.NucleusCanRetryException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUnsupportedOptionException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.exceptions.DatastoreReadOnlyException;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryTimeoutException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class NucleusJDOHelper
extends JDOHelper {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);

    public static JDOQueryCache getQueryResultCache(PersistenceManagerFactory pmf) {
        return ((JDOPersistenceManagerFactory)pmf).getQueryCache();
    }

    public static void replicate(PersistenceManagerFactory pmf1, PersistenceManagerFactory pmf2, Object ... oids) {
        JDOReplicationManager replicator = new JDOReplicationManager(pmf1, pmf2);
        replicator.replicate(oids);
    }

    public static void replicate(PersistenceManagerFactory pmf1, PersistenceManagerFactory pmf2, Class ... types) {
        JDOReplicationManager replicator = new JDOReplicationManager(pmf1, pmf2);
        replicator.replicate(types);
    }

    public static void replicate(PersistenceManagerFactory pmf1, PersistenceManagerFactory pmf2, String ... classNames) {
        JDOReplicationManager replicator = new JDOReplicationManager(pmf1, pmf2);
        replicator.replicate(classNames);
    }

    public static ClassMetaData getMetaDataForClass(PersistenceManagerFactory pmf, Class cls) {
        if (pmf == null || cls == null) {
            return null;
        }
        if (!(pmf instanceof JDOPersistenceManagerFactory)) {
            return null;
        }
        JDOPersistenceManagerFactory myPMF = (JDOPersistenceManagerFactory)pmf;
        MetaDataManager mdmgr = myPMF.getNucleusContext().getMetaDataManager();
        return (ClassMetaData)mdmgr.getMetaDataForClass(cls, myPMF.getNucleusContext().getClassLoaderResolver(null));
    }

    public static String[] getClassesWithMetaData(PersistenceManagerFactory pmf) {
        if (pmf == null || !(pmf instanceof JDOPersistenceManagerFactory)) {
            return null;
        }
        JDOPersistenceManagerFactory myPMF = (JDOPersistenceManagerFactory)pmf;
        Collection classes = myPMF.getNucleusContext().getMetaDataManager().getClassesWithMetaData();
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getDirtyFields(Object obj, PersistenceManager pm) {
        if (obj == null || !(obj instanceof PersistenceCapable)) {
            return null;
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        if (NucleusJDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            ObjectProvider op = ObjectProviderFactory.newForDetached((ExecutionContext)ec, (Object)pc, (Object)NucleusJDOHelper.getObjectId((Object)pc), null);
            pc.jdoReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] dirtyFieldNames = op.getDirtyFieldNames();
            pc.jdoReplaceStateManager(null);
            return dirtyFieldNames;
        }
        ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
        ObjectProvider sm = ec.findObjectProvider((Object)pc);
        if (sm == null) {
            return null;
        }
        return sm.getDirtyFieldNames();
    }

    public static String[] getLoadedFields(Object obj, PersistenceManager pm) {
        if (obj == null || !(obj instanceof PersistenceCapable)) {
            return null;
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        if (NucleusJDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            ObjectProvider op = ObjectProviderFactory.newForDetached((ExecutionContext)ec, (Object)pc, (Object)NucleusJDOHelper.getObjectId((Object)pc), null);
            pc.jdoReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            String[] loadedFieldNames = op.getLoadedFieldNames();
            pc.jdoReplaceStateManager(null);
            return loadedFieldNames;
        }
        ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
        ObjectProvider sm = ec.findObjectProvider((Object)pc);
        if (sm == null) {
            return null;
        }
        return sm.getLoadedFieldNames();
    }

    public static Boolean isLoaded(Object obj, String memberName, PersistenceManager pm) {
        if (obj == null || !(obj instanceof PersistenceCapable)) {
            return null;
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        if (NucleusJDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            ObjectProvider op = ObjectProviderFactory.newForDetached((ExecutionContext)ec, (Object)pc, (Object)NucleusJDOHelper.getObjectId((Object)pc), null);
            pc.jdoReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            int position = op.getClassMetaData().getAbsolutePositionOfMember(memberName);
            boolean loaded = op.isFieldLoaded(position);
            pc.jdoReplaceStateManager(null);
            return loaded;
        }
        ExecutionContext ec = ((JDOPersistenceManager)pc.jdoGetPersistenceManager()).getExecutionContext();
        ObjectProvider sm = ec.findObjectProvider((Object)pc);
        if (sm == null) {
            return null;
        }
        int position = sm.getClassMetaData().getAbsolutePositionOfMember(memberName);
        return sm.isFieldLoaded(position);
    }

    public static Boolean isDirty(Object obj, String memberName, PersistenceManager pm) {
        if (obj == null || !(obj instanceof PersistenceCapable)) {
            return null;
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        if (NucleusJDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            ObjectProvider op = ObjectProviderFactory.newForDetached((ExecutionContext)ec, (Object)pc, (Object)NucleusJDOHelper.getObjectId((Object)pc), null);
            pc.jdoReplaceStateManager((StateManager)op);
            op.retrieveDetachState(op);
            int position = op.getClassMetaData().getAbsolutePositionOfMember(memberName);
            boolean[] dirtyFieldNumbers = op.getDirtyFields();
            pc.jdoReplaceStateManager(null);
            return dirtyFieldNumbers[position];
        }
        ExecutionContext ec = ((JDOPersistenceManager)pc.jdoGetPersistenceManager()).getExecutionContext();
        ObjectProvider sm = ec.findObjectProvider((Object)pc);
        if (sm == null) {
            return null;
        }
        int position = sm.getClassMetaData().getAbsolutePositionOfMember(memberName);
        boolean[] dirtyFieldNumbers = sm.getDirtyFields();
        return dirtyFieldNumbers[position];
    }

    public static JDOException getJDOExceptionForNucleusException(NucleusException ne) {
        if (ne instanceof ClassNotPersistableException) {
            return new ClassNotPersistenceCapableException(ne.getMessage(), (Exception)((Object)ne));
        }
        if (ne instanceof org.datanucleus.exceptions.NoPersistenceInformationException) {
            return new NoPersistenceInformationException(ne.getMessage(), (Exception)((Object)ne));
        }
        if (ne instanceof org.datanucleus.exceptions.TransactionNotReadableException) {
            return new TransactionNotReadableException(ne.getMessage(), ne.getCause());
        }
        if (ne instanceof org.datanucleus.exceptions.TransactionNotWritableException) {
            return new TransactionNotWritableException(ne.getMessage(), ne.getCause());
        }
        if (ne instanceof org.datanucleus.exceptions.TransactionNotActiveException) {
            return new TransactionNotActiveException(ne.getMessage(), (Object)ne);
        }
        if (ne instanceof QueryInterruptedException) {
            return new JDOQueryInterruptedException(ne.getMessage());
        }
        if (ne instanceof QueryTimeoutException) {
            return new JDODataStoreException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusUnsupportedOptionException) {
            return new JDOUnsupportedOptionException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof DatastoreReadOnlyException) {
            ClassLoaderResolver clr = ((DatastoreReadOnlyException)ne).getClassLoaderResolver();
            try {
                Class cls = clr.classForName("javax.jdo.JDOReadOnlyException");
                throw (JDOUserException)ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class}, (Object[])new Object[]{ne.getMessage()});
            }
            catch (NucleusException ne2) {
                throw new JDOUserException(ne2.getMessage());
            }
        }
        if (ne instanceof NucleusDataStoreException) {
            if (ne.isFatal()) {
                if (ne.getFailedObject() != null) {
                    return new JDOFatalDataStoreException(ne.getMessage(), ne.getFailedObject());
                }
                if (ne.getNestedExceptions() != null) {
                    return new JDOFatalDataStoreException(ne.getMessage(), ne.getNestedExceptions());
                }
                return new JDOFatalDataStoreException(ne.getMessage(), (Throwable)ne);
            }
            if (ne.getNestedExceptions() != null) {
                if (ne.getFailedObject() != null) {
                    return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions());
            }
            if (ne.getFailedObject() != null) {
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDODataStoreException(ne.getMessage(), ne.getFailedObject());
            }
            JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
            return new JDODataStoreException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusObjectNotFoundException) {
            if (ne.getFailedObject() != null) {
                if (ne.getNestedExceptions() != null) {
                    return new JDOObjectNotFoundException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDOObjectNotFoundException(ne.getMessage(), (Throwable)ne, ne.getFailedObject());
            }
            if (ne.getNestedExceptions() != null) {
                return new JDOObjectNotFoundException(ne.getMessage(), ne.getNestedExceptions());
            }
            return new JDOObjectNotFoundException(ne.getMessage(), new Throwable[]{ne});
        }
        if (ne instanceof NucleusCanRetryException) {
            if (ne.getNestedExceptions() != null) {
                if (ne.getFailedObject() != null) {
                    return new JDOCanRetryException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDOCanRetryException(ne.getMessage(), ne.getNestedExceptions());
            }
            if (ne.getFailedObject() != null) {
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDOCanRetryException(ne.getMessage(), ne.getFailedObject());
            }
            JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
            return new JDOCanRetryException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusUserException) {
            if (ne.isFatal()) {
                if (ne.getNestedExceptions() != null) {
                    if (ne.getFailedObject() != null) {
                        return new JDOFatalUserException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                    }
                    return new JDOFatalUserException(ne.getMessage(), ne.getNestedExceptions());
                }
                if (ne.getFailedObject() != null) {
                    JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                    return new JDOFatalUserException(ne.getMessage(), ne.getFailedObject());
                }
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDOFatalUserException(ne.getMessage(), (Throwable)ne);
            }
            if (ne.getNestedExceptions() != null) {
                if (ne.getFailedObject() != null) {
                    return new JDOUserException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDOUserException(ne.getMessage(), ne.getNestedExceptions());
            }
            if (ne.getFailedObject() != null) {
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDOUserException(ne.getMessage(), ne.getFailedObject());
            }
            JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
            return new JDOUserException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusOptimisticException) {
            if (ne.getFailedObject() != null) {
                return new JDOOptimisticVerificationException(ne.getMessage(), ne.getFailedObject());
            }
            if (ne.getNestedExceptions() != null) {
                return new JDOOptimisticVerificationException(ne.getMessage(), ne.getNestedExceptions());
            }
            return new JDOOptimisticVerificationException(ne.getMessage(), (Object)ne);
        }
        if (ne instanceof HeuristicRollbackException && ne.getNestedExceptions().length == 1 && ne.getNestedExceptions()[0].getCause() instanceof SQLException) {
            return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions()[0].getCause());
        }
        if (ne instanceof HeuristicRollbackException && ne.getNestedExceptions().length == 1 && ne.getNestedExceptions()[0] instanceof NucleusDataStoreException) {
            return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions()[0].getCause());
        }
        if (ne.isFatal()) {
            if (ne.getNestedExceptions() != null) {
                return new JDOFatalInternalException(ne.getMessage(), ne.getNestedExceptions());
            }
            return new JDOFatalInternalException(ne.getMessage(), (Throwable)ne);
        }
        if (ne.getNestedExceptions() != null) {
            return new JDOException(ne.getMessage(), ne.getNestedExceptions());
        }
        return new JDOException(ne.getMessage(), (Throwable)ne);
    }

    public static JDOImplHelper getJDOImplHelper() {
        return (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return JDOImplHelper.getInstance();
                }
                catch (SecurityException e) {
                    throw new JDOFatalUserException(LOCALISER.msg("026000"), (Throwable)e);
                }
            }
        });
    }
}

