/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.de;

import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.de.GermanStemmer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;
import java.util.Set;

public final class GermanStemFilter
extends TokenFilter {
    private GermanStemmer stemmer = new GermanStemmer();
    private Set exclusionSet = null;
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);

    public GermanStemFilter(TokenStream in) {
        super(in);
    }

    public GermanStemFilter(TokenStream in, Set exclusionSet) {
        this(in);
        this.exclusionSet = exclusionSet;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s;
            String term = this.termAtt.term();
            if (!(this.exclusionSet != null && this.exclusionSet.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
                this.termAtt.setTermBuffer(s);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(GermanStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionSet(Set exclusionSet) {
        this.exclusionSet = exclusionSet;
    }
}

