/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.time.TimeSource;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public class NeedToWaitTime
extends DatastoreException {
    private final Instant waitUntil;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName((String)"com/google/cloud/datastore/core/exception/NeedToWaitTime");

    public NeedToWaitTime(String message, Instant waitUntil) {
        super(message, DatastorePb.Error.ErrorCode.FAILED_PRECONDITION, null);
        this.waitUntil = waitUntil;
    }

    public Instant waitUntil() {
        return this.waitUntil;
    }

    public void doWait(TimeSource timeSource) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/core/exception/NeedToWaitTime", "doWait", 27, "NeedToWaitTime.java")).log("Waiting because %s\n", (Object)this.getMessage());
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/core/exception/NeedToWaitTime", "doWait", 28, "NeedToWaitTime.java")).log("Will recheck at %s\n", (Object)this.waitUntil());
        while (timeSource.now().isBefore(this.waitUntil())) {
            Duration waitLeft = Duration.between(timeSource.now(), this.waitUntil());
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/cloud/datastore/core/exception/NeedToWaitTime", "doWait", 31, "NeedToWaitTime.java")).log("%s wait left until next step in the change.\n", (Object)waitLeft);
            try {
                Instant endTime = timeSource.now().plusNanos(Math.min(Duration.ofSeconds(5L).toNanos(), waitLeft.toNanos()));
                while (timeSource.now().isBefore(endTime)) {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Don't use Interrupt.", e);
            }
        }
    }
}

