/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.names;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.names.ProjectIds;

public class SingleAppResolver
implements ProjectIdAppIdResolver {
    private final String appId;
    private final String projectId;

    public SingleAppResolver(String appId) {
        this.appId = appId;
        this.projectId = ProjectIds.appToProjectId(appId);
    }

    @Override
    public String toAppId(String projectId) throws InvalidConversionException {
        if (!this.projectId.equals(projectId)) {
            throw new InvalidConversionException(String.format("project ID %s does not match original: %s", projectId, this.projectId));
        }
        return this.appId;
    }

    @Override
    public String toProjectId(String appId) {
        Preconditions.checkArgument((boolean)this.appId.equals(appId), (String)"app ID %s does not match original: %s", (Object)appId, (Object)this.appId);
        return this.projectId;
    }
}

