/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;

public class CastExpression
extends Expression {
    SymbolTable symtbl;
    String className;

    public CastExpression(SymbolTable symtbl, Expression left, String className) {
        this.symtbl = symtbl;
        this.left = left;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public Symbol bind() {
        if (this.left != null) {
            this.symbol = this.left.bind();
        }
        try {
            Class cls = this.symtbl.getSymbolResolver().resolveClass(this.className);
            if (cls != null && !cls.getName().equals(this.className)) {
                this.className = cls.getName();
            }
        }
        catch (ClassNotResolvedException classNotResolvedException) {
            // empty catch block
        }
        return this.symbol;
    }

    public String toString() {
        return "CastExpression(" + this.className + "){[" + this.left + "]}";
    }
}

