/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.PrimaryExpressionIsVariableException;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.StringUtils;

public class InvokeExpression
extends Expression {
    SymbolTable symtbl;
    String methodName;
    List<Expression> arguments;

    public InvokeExpression(SymbolTable symtbl, Expression invoked, String methodName, List args) {
        this.symtbl = symtbl;
        this.left = invoked;
        this.methodName = methodName;
        this.arguments = args;
    }

    public String getOperation() {
        return this.methodName;
    }

    public List getArguments() {
        return this.arguments;
    }

    public Symbol bind() {
        if (this.arguments != null && this.arguments.size() > 0) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                Expression expr = this.arguments.get(i);
                try {
                    expr.bind();
                    continue;
                }
                catch (PrimaryExpressionIsVariableException pive) {
                    VariableExpression ve = pive.getVariableExpression();
                    ve.bind();
                    this.arguments.remove(i);
                    this.arguments.add(i, ve);
                }
            }
        }
        return this.symbol;
    }

    public String toString() {
        return "InvokeExpression{[" + this.left + "]." + this.methodName + "(" + StringUtils.collectionToString(this.arguments) + ")}";
    }
}

