/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.math.BigDecimal;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.StringUtils;

public class FloatingPointLiteral
extends NumericExpression
implements Literal {
    private final BigDecimal value;
    Object rawValue;

    public FloatingPointLiteral(QueryExpression qs, JavaTypeMapping mapping, Float value) {
        super(qs);
        this.mapping = mapping;
        this.value = new BigDecimal(value.toString());
        this.st.appendParameter(qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(Float.class, false, false, qs.getClassLoaderResolver()), value);
    }

    public Object getValue() {
        return this.value;
    }

    public FloatingPointLiteral(QueryExpression qs, JavaTypeMapping mapping, Double value) {
        super(qs);
        this.mapping = mapping;
        this.value = new BigDecimal(value.toString());
        this.st.appendParameter(qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(Double.class, false, false, qs.getClassLoaderResolver()), value);
    }

    public FloatingPointLiteral(QueryExpression qs, BigDecimal value) {
        super(qs);
        this.value = value;
        this.st.append(StringUtils.exponentialFormatBigDecimal(value));
    }

    public BooleanExpression eq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, NumericExpression.class);
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, NumericExpression.class);
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_NOTEQ, literal);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((FloatingPointLiteral)expr).value) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.add(((FloatingPointLiteral)expr).value));
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.subtract(((FloatingPointLiteral)expr).value));
        }
        return super.sub(expr);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.multiply(((FloatingPointLiteral)expr).value));
        }
        return super.mul(expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (expr instanceof FloatingPointLiteral) {
            return new FloatingPointLiteral(this.qs, this.value.divide(((FloatingPointLiteral)expr).value, 1));
        }
        return super.mul(expr);
    }

    public ScalarExpression neg() {
        return new FloatingPointLiteral(this.qs, this.value.negate());
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

