/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.datanucleus.store.mapped.expression.ByteLiteral;
import org.datanucleus.store.mapped.expression.FloatingPointLiteral;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

public class MathExpression
extends ScalarExpression {
    public MathExpression(QueryExpression qs) {
        super(qs);
    }

    public ScalarExpression absMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                BigInteger absValue = new BigInteger(String.valueOf(Math.abs(originalValue)));
                return new ByteLiteral(this.qs, expr.mapping, absValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Integer absValue = new Integer(Math.abs(originalValue));
                return new IntegerLiteral(this.qs, expr.mapping, absValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double absValue = new Double(Math.abs(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, absValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "absMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("abs", expr);
    }

    public ScalarExpression sqrtMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sqrt(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sqrt(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.sqrt(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "sqrtMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("sqrt", expr);
    }

    public ScalarExpression cosMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.cos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.cos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.cos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "cosMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("cos", expr);
    }

    public ScalarExpression sinMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.sin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.sin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "sinMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("sin", expr);
    }

    public ScalarExpression tanMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "tanMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("tan", expr);
    }

    public ScalarExpression acosMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "acosMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("acos", expr);
    }

    public ScalarExpression asinMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.asin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.asin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.asin(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "asinMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("asin", expr);
    }

    public ScalarExpression atanMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.atan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.atan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.atan(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "atanMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("atan", expr);
    }

    public ScalarExpression expMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.exp(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.exp(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.exp(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "expMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("exp", expr);
    }

    public ScalarExpression logMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.log(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.log(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.log(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "logMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("log", expr);
    }

    public ScalarExpression floorMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.floor(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.floor(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.floor(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "floorMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("floor", expr);
    }

    public ScalarExpression ceilMethod(ScalarExpression expr) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.ceil(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double newValue = new Double(Math.ceil(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double newValue = new Double(Math.ceil(originalValue));
                return new FloatingPointLiteral(this.qs, expr.mapping, newValue);
            }
            throw new ScalarExpression.IllegalOperationException(this, "ceilMethod", expr);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("ceil", expr);
    }
}

