/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.datanucleus.DatastoreFieldManager;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.NucleusLogger;

public class FetchFieldManager
extends DatastoreFieldManager {
    private static final int[] NOT_USED = new int[]{0};
    private static final String ILLEGAL_NULL_ASSIGNMENT_ERROR_FORMAT = "Datastore entity with kind %s and key %s has a null property named %s.  This property is mapped to %s, which cannot accept null values.";

    public FetchFieldManager(ObjectProvider op, Entity datastoreEntity, int[] fieldNumbers) {
        super(op, datastoreEntity, fieldNumbers);
    }

    public FetchFieldManager(ObjectProvider op, Entity datastoreEntity) {
        super(op, datastoreEntity, null);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Boolean.valueOf(dflt);
            }
            return false;
        }
        return (Boolean)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Byte.valueOf(dflt);
            }
            return 0;
        }
        return (Byte)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null && dflt.length() > 0) {
                return dflt.charAt(0);
            }
            return '\u0000';
        }
        return ((Character)this.checkAssignmentToNotNullField(value, fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Double.valueOf(dflt);
            }
            return 0.0;
        }
        return (Double)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Float.valueOf(dflt).floatValue();
            }
            return 0.0f;
        }
        return ((Float)this.checkAssignmentToNotNullField(value, fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Integer.valueOf(dflt);
            }
            return 0;
        }
        return (Integer)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Long.valueOf(dflt);
            }
            return 0L;
        }
        return (Long)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        Object value = this.fetchFieldFromEntity(fieldNumber);
        if (value == null) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            String dflt = MetaDataUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Short.valueOf(dflt);
            }
            return 0;
        }
        return (Short)this.checkAssignmentToNotNullField(value, fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        if (this.isPK(fieldNumber)) {
            if (MetaDataUtils.isEncodedPKField(this.getClassMetaData(), fieldNumber)) {
                return KeyFactory.keyToString((Key)this.datastoreEntity.getKey());
            }
            if (this.datastoreEntity.getKey().isComplete() && this.datastoreEntity.getKey().getName() == null) {
                throw new NucleusFatalUserException("The primary key for " + this.getClassMetaData().getFullClassName() + " is an unencoded " + "string but the key of the corresponding entity in the datastore does not have a " + "name.  You may want to either change the primary key to be an encoded string " + "(add the \"" + "gae.encoded-pk" + "\" extension), change the " + "primary key to be of type " + Key.class.getName() + ", or, if you're certain that " + "this class will never have a parent, change the primary key to be of type Long.");
            }
            return this.datastoreEntity.getKey().getName();
        }
        if (MetaDataUtils.isParentPKField(this.getClassMetaData(), fieldNumber)) {
            Key parentKey = this.datastoreEntity.getKey().getParent();
            if (parentKey == null) {
                return null;
            }
            return KeyFactory.keyToString((Key)parentKey);
        }
        if (MetaDataUtils.isPKNameField(this.getClassMetaData(), fieldNumber)) {
            AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
            if (!mmd.getType().equals(String.class)) {
                throw new NucleusFatalUserException("Field with \"gae.pk-name\" extension must be of type String");
            }
            Key key = this.datastoreEntity.getKey();
            if (key.getName() == null) {
                throw new NucleusFatalUserException("Attempting to fetch field with \"gae.pk-name\" extension but the entity is identified by an id, not a name.");
            }
            return this.datastoreEntity.getKey().getName();
        }
        Object fieldVal = this.fetchFieldFromEntity(fieldNumber);
        if (fieldVal instanceof Text) {
            fieldVal = ((Text)fieldVal).getValue();
        }
        return (String)fieldVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        if (mmd.getEmbeddedMetaData() != null && Relation.isRelationSingleValued((int)relationType)) {
            ObjectProvider embeddedOP = this.getEmbeddedObjectProvider(mmd.getType(), fieldNumber, null);
            this.fieldManagerStateStack.addFirst(new DatastoreFieldManager.FieldManagerState(embeddedOP, mmd.getEmbeddedMetaData()));
            try {
                embeddedOP.replaceFields(embeddedOP.getClassMetaData().getAllMemberPositions(), (FieldManager)this);
                if (mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getNullIndicatorColumn() != null) {
                    String nullColumn = mmd.getEmbeddedMetaData().getNullIndicatorColumn();
                    String nullValue = mmd.getEmbeddedMetaData().getNullIndicatorValue();
                    AbstractMemberMetaData[] embMmds = mmd.getEmbeddedMetaData().getMemberMetaData();
                    AbstractMemberMetaData nullMmd = null;
                    for (int i = 0; i < embMmds.length; ++i) {
                        ColumnMetaData[] colmds = embMmds[i].getColumnMetaData();
                        if (colmds == null || colmds.length <= 0 || colmds[0].getName() == null || !colmds[0].getName().equals(nullColumn)) continue;
                        nullMmd = embMmds[i];
                        break;
                    }
                    if (nullMmd != null) {
                        int nullFieldPos = embeddedOP.getClassMetaData().getAbsolutePositionOfMember(nullMmd.getName());
                        Object val = embeddedOP.provideField(nullFieldPos);
                        if (val == null && nullValue == null) {
                            Object var12_29 = null;
                            return var12_29;
                        }
                        if (val != null && nullValue != null && val.equals(nullValue)) {
                            Object var12_30 = null;
                            return var12_30;
                        }
                    }
                    Object nullFieldPos = embeddedOP.getObject();
                    return nullFieldPos;
                }
                Object nullColumn = embeddedOP.getObject();
                return nullColumn;
            }
            finally {
                this.fieldManagerStateStack.removeFirst();
            }
        }
        if (Relation.isRelationMultiValued((int)relationType) && mmd.isEmbedded()) {
            if (mmd.hasCollection()) {
                Collection coll;
                String collPropName = this.getPropertyNameForMember(mmd) + ".size";
                Long collSize = (Long)this.datastoreEntity.getProperty(collPropName);
                if (collSize == null || collSize == -1L) {
                    return null;
                }
                Class elementType = clr.classForName(mmd.getCollection().getElementType());
                AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                EmbeddedMetaData embmd = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getEmbeddedMetaData() : null;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                String collDiscName = null;
                if (elemCmd.hasDiscriminatorStrategy()) {
                    DiscriminatorMetaData dismd;
                    ColumnMetaData discolmd;
                    collDiscName = elemCmd.getDiscriminatorColumnName();
                    if (embmd != null && embmd.getDiscriminatorMetaData() != null && (discolmd = (dismd = embmd.getDiscriminatorMetaData()).getColumnMetaData()) != null && discolmd.getName() != null) {
                        collDiscName = discolmd.getName();
                    }
                    if (collDiscName == null) {
                        collDiscName = this.getPropertyNameForMember(mmd) + ".discrim";
                    }
                }
                int i = 0;
                while ((long)i < collSize) {
                    Class elementCls = elementType;
                    if (collDiscName != null) {
                        Object discVal = this.datastoreEntity.getProperty(collDiscName + "." + i);
                        String className = org.datanucleus.metadata.MetaDataUtils.getClassNameFromDiscriminatorValue((String)((String)discVal), (DiscriminatorMetaData)elemCmd.getDiscriminatorMetaDataRoot(), (ExecutionContext)this.ec);
                        elementCls = clr.classForName(className);
                    }
                    ObjectProvider embeddedOP = this.getEmbeddedObjectProvider(elementCls, fieldNumber, null);
                    this.fieldManagerStateStack.addFirst(new DatastoreFieldManager.FieldManagerState(embeddedOP, embmd, i));
                    try {
                        embeddedOP.replaceFields(embeddedOP.getClassMetaData().getAllMemberPositions(), (FieldManager)this);
                    }
                    finally {
                        this.fieldManagerStateStack.removeFirst();
                    }
                    coll.add(embeddedOP.getObject());
                    ++i;
                }
                return coll;
            }
            if (mmd.hasArray()) {
                String arrPropName = this.getPropertyNameForMember(mmd) + ".size";
                Long arrSize = (Long)this.datastoreEntity.getProperty(arrPropName);
                if (arrSize == null || arrSize == -1L) {
                    return null;
                }
                Class elementType = clr.classForName(mmd.getArray().getElementType());
                AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                EmbeddedMetaData embmd = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getEmbeddedMetaData() : null;
                Object value = Array.newInstance(elementType, arrSize.intValue());
                String arrDiscName = null;
                if (elemCmd.hasDiscriminatorStrategy()) {
                    DiscriminatorMetaData dismd;
                    ColumnMetaData discolmd;
                    arrDiscName = elemCmd.getDiscriminatorColumnName();
                    if (embmd != null && embmd.getDiscriminatorMetaData() != null && (discolmd = (dismd = embmd.getDiscriminatorMetaData()).getColumnMetaData()) != null && discolmd.getName() != null) {
                        arrDiscName = discolmd.getName();
                    }
                    if (arrDiscName == null) {
                        arrDiscName = this.getPropertyNameForMember(mmd) + ".discrim";
                    }
                }
                int i = 0;
                while ((long)i < arrSize) {
                    Class elementCls = elementType;
                    if (arrDiscName != null) {
                        Object discVal = this.datastoreEntity.getProperty(arrDiscName + "." + i);
                        String className = org.datanucleus.metadata.MetaDataUtils.getClassNameFromDiscriminatorValue((String)((String)discVal), (DiscriminatorMetaData)elemCmd.getDiscriminatorMetaDataRoot(), (ExecutionContext)this.ec);
                        elementCls = clr.classForName(className);
                    }
                    ObjectProvider embeddedOP = this.getEmbeddedObjectProvider(elementCls, fieldNumber, null);
                    this.fieldManagerStateStack.addFirst(new DatastoreFieldManager.FieldManagerState(embeddedOP, embmd, i));
                    try {
                        embeddedOP.replaceFields(embeddedOP.getClassMetaData().getAllMemberPositions(), (FieldManager)this);
                    }
                    finally {
                        this.fieldManagerStateStack.removeFirst();
                    }
                    Array.set(value, i, embeddedOP.getObject());
                    ++i;
                }
                return value;
            }
            if (mmd.hasMap()) {
                throw new NucleusUserException("Don't currently support embedded maps at " + mmd.getFullFieldName());
            }
        }
        if (mmd.getRelationType(clr) != 0 && !mmd.isSerialized()) {
            return this.fetchRelationField(clr, mmd);
        }
        return this.fetchFieldFromEntity(fieldNumber);
    }

    Object fetchFieldFromEntity(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
        if (this.isPK(fieldNumber)) {
            if (mmd.getType().equals(Key.class)) {
                return this.datastoreEntity.getKey();
            }
            if (mmd.getType().equals(Long.class) || mmd.getType().equals(Long.TYPE)) {
                return this.datastoreEntity.getKey().getId();
            }
            throw this.exceptionForUnexpectedKeyType("Primary key", fieldNumber);
        }
        if (MetaDataUtils.isParentPKField(this.getClassMetaData(), fieldNumber)) {
            if (mmd.getType().equals(Key.class)) {
                return this.datastoreEntity.getKey().getParent();
            }
            throw this.exceptionForUnexpectedKeyType("Parent key", fieldNumber);
        }
        if (MetaDataUtils.isPKIdField(this.getClassMetaData(), fieldNumber)) {
            Key key = this.datastoreEntity.getKey();
            if (key.getName() != null) {
                throw new NucleusFatalUserException("Attempting to fetch field with \"gae.pk-id\" extension but the entity is identified by a name, not an id.");
            }
            return this.datastoreEntity.getKey().getId();
        }
        Object value = this.datastoreEntity.getProperty(this.getPropertyNameForMember(mmd));
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        if (mmd.isSerialized()) {
            if (value != null) {
                if (!(value instanceof Blob)) {
                    throw new NucleusException("Datastore value is of type " + value.getClass().getName() + " (must be Blob).").setFatal();
                }
                value = this.getStoreManager().getSerializationManager().deserialize(clr, mmd, (Blob)value);
            }
        } else {
            if (mmd.getAbsoluteFieldNumber() == -1) {
                mmd = this.getClassMetaData().getMetaDataForMember(mmd.getName());
            }
            if (mmd.getTypeConverterName() != null) {
                TypeConverter conv = this.ec.getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
                value = conv.toMemberType(value);
            } else {
                TypeManager typeMgr = this.ec.getNucleusContext().getTypeManager();
                value = ((DatastoreManager)this.ec.getStoreManager()).getTypeConversionUtils().datastoreValueToPojoValue(typeMgr, clr, value, mmd);
            }
            if (value != null && !(value instanceof SCO)) {
                value = this.getObjectProvider().wrapSCOField(fieldNumber, value, false, false, true);
            }
        }
        return value;
    }

    Object fetchRelationField(ClassLoaderResolver clr, AbstractMemberMetaData mmd) {
        Object value = null;
        int relationType = mmd.getRelationType(clr);
        if (Relation.isRelationMultiValued((int)relationType)) {
            String propName = this.getPropertyNameForMember(mmd);
            if (this.datastoreEntity.hasProperty(propName)) {
                if (mmd.hasCollection()) {
                    return this.getCollectionFromDatastoreObject(mmd, this.ec, clr, propName);
                }
                if (mmd.hasArray()) {
                    return this.getArrayFromDatastoreObject(mmd, this.ec, clr, propName);
                }
                if (mmd.hasMap()) {
                    return this.getMapFromDatastoreObject(mmd, this.ec, clr, propName);
                }
            }
            return null;
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            boolean owned = MetaDataUtils.isOwnedRelation(mmd, this.getStoreManager());
            if (owned) {
                DatastoreTable dt = this.getDatastoreTable();
                JavaTypeMapping mapping = dt.getMemberMappingInDatastoreClass(mmd);
                if (relationType == 2 || relationType == 1) {
                    if (dt.isParentKeyProvider(mmd)) {
                        return this.lookupParent(mmd, mapping, false);
                    }
                    return this.lookupOneToOneChild(mmd, clr);
                }
                if (relationType == 6) {
                    MetaData parent;
                    MetaData other = mmd.getRelatedMemberMetaData(clr)[0].getParent();
                    boolean allowNullParent = other == (parent = mmd.getParent()) && this.datastoreEntity.getKey().getParent() == null;
                    return this.lookupParent(mmd, mapping, allowNullParent);
                }
            } else {
                return this.lookupOneToOneChild(mmd, clr);
            }
        }
        return value;
    }

    private Object lookupParent(AbstractMemberMetaData mmd, JavaTypeMapping mapping, boolean allowNullParent) {
        Key parentKey = this.datastoreEntity.getParent();
        if (parentKey == null) {
            if (!allowNullParent) {
                String childClass = this.getObjectProvider().getClassMetaData().getFullClassName();
                throw new NucleusFatalUserException("Field " + mmd.getFullFieldName() + " should be able to " + "provide a reference to its parent but the entity does not have a parent.  " + "Did you perhaps try to establish an instance of " + childClass + " as " + "the child of an instance of " + mmd.getTypeName() + " after the child had already been " + "persisted?");
            }
            return null;
        }
        return mapping.getObject(this.ec, (Object)parentKey, NOT_USED);
    }

    private Object lookupOneToOneChild(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        AbstractClassMetaData childCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
        String kind = this.getStoreManager().getIdentifierFactory().newDatastoreContainerIdentifier(childCmd).getIdentifierName();
        if (MetaDataUtils.readRelatedKeysFromParent(this.getStoreManager(), mmd)) {
            String propName = this.getPropertyNameForMember(mmd);
            if (this.datastoreEntity.hasProperty(propName)) {
                Object value = this.datastoreEntity.getProperty(propName);
                if (value == null) {
                    return null;
                }
                if (value instanceof Key) {
                    DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
                    DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService(config);
                    try {
                        return EntityUtils.entityToPojo(datastoreService.get((Key)value), childCmd, clr, this.ec, false, this.ec.getFetchPlan());
                    }
                    catch (EntityNotFoundException enfe) {
                        NucleusLogger.PERSISTENCE.error((Object)("Member " + mmd.getFullFieldName() + " of " + this.getObjectProvider().getInternalObjectId() + " was pointing to object with key " + value + " but this doesn't exist! Returning null"));
                        return null;
                    }
                }
            } else if (MetaDataUtils.isOwnedRelation(mmd, this.getStoreManager())) {
                NucleusLogger.PERSISTENCE.info((Object)("Persistable object at member " + mmd.getFullFieldName() + " of " + this.getObjectProvider() + " not yet migrated to latest storage version, so reading the object via its parent key"));
            } else {
                NucleusLogger.PERSISTENCE.error((Object)("Object " + this.datastoreEntity.getKey() + " has unowned member " + mmd.getFullFieldName() + " but no corresponding property " + propName + " on its datastore entity, so returning null"));
                return null;
            }
        }
        Entity parentEntity = this.datastoreEntity;
        Query q = new Query(kind, parentEntity.getKey());
        DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
        DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService(config);
        for (Entity e : datastoreService.prepare(q).asIterable()) {
            if (!parentEntity.getKey().equals((Object)e.getKey().getParent())) continue;
            return EntityUtils.entityToPojo(e, childCmd, clr, this.ec, false, this.ec.getFetchPlan());
        }
        return null;
    }

    private Object checkAssignmentToNotNullField(Object val, int fieldNumber) {
        if (val != null) {
            return val;
        }
        AbstractMemberMetaData mmd = this.getMetaData(fieldNumber);
        String propertyName = this.getPropertyNameForMember(mmd);
        String msg = String.format(ILLEGAL_NULL_ASSIGNMENT_ERROR_FORMAT, this.datastoreEntity.getKind(), this.datastoreEntity.getKey(), propertyName, mmd.getFullFieldName());
        throw new NullPointerException(msg);
    }

    protected Collection getCollectionFromDatastoreObject(AbstractMemberMetaData mmd, ExecutionContext ec, ClassLoaderResolver clr, String propName) {
        Object propValue = this.datastoreEntity.getProperty(propName);
        if (propValue != null) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
            DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
            List keys = (List)propValue;
            Map entitiesByKey = ds.get((Iterable)keys);
            boolean changeDetected = false;
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, ec.getMetaDataManager());
            for (Key key : keys) {
                Entity entity = (Entity)entitiesByKey.get(key);
                if (entity == null) {
                    changeDetected = true;
                    NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Field " + mmd.getFullFieldName() + " of " + this.datastoreEntity.getKey() + " was marked as having child " + key + " but doesn't exist, so must have been deleted. Ignoring"));
                    continue;
                }
                Object pojo = EntityUtils.entityToPojo(entity, elemCmd, clr, ec, false, ec.getFetchPlan());
                coll.add(pojo);
            }
            if (mmd.getOrderMetaData() != null && mmd.getOrderMetaData().getOrdering() != null && !mmd.getOrderMetaData().getOrdering().equals("#PK")) {
                coll = QueryUtils.orderCandidates((List)((List)coll), (Class)mmd.getType(), (String)mmd.getOrderMetaData().getOrdering(), (ExecutionContext)ec, (ClassLoaderResolver)clr);
            }
            coll = (Collection)this.getObjectProvider().wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, false);
            if (changeDetected) {
                this.getObjectProvider().makeDirty(mmd.getAbsoluteFieldNumber());
            }
            return coll;
        }
        return null;
    }

    protected Object getArrayFromDatastoreObject(AbstractMemberMetaData mmd, ExecutionContext ec, ClassLoaderResolver clr, String propName) {
        Object propValue = this.datastoreEntity.getProperty(propName);
        if (propValue != null) {
            List keys = (List)propValue;
            Object value = Array.newInstance(mmd.getType().getComponentType(), keys.size());
            DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
            DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
            Map entitiesByKey = ds.get((Iterable)keys);
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, ec.getMetaDataManager());
            int i = 0;
            boolean changeDetected = false;
            for (Key key : keys) {
                Entity entity = (Entity)entitiesByKey.get(key);
                if (entity == null) {
                    changeDetected = true;
                    NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Field " + mmd.getFullFieldName() + " of " + this.datastoreEntity.getKey() + " was marked as having child " + key + " but doesn't exist, so must have been deleted. Ignoring"));
                    continue;
                }
                Object pojo = EntityUtils.entityToPojo(entity, elemCmd, clr, ec, false, ec.getFetchPlan());
                Array.set(value, i, pojo);
                ++i;
            }
            if (changeDetected) {
                this.getObjectProvider().makeDirty(mmd.getAbsoluteFieldNumber());
            }
            return value;
        }
        return null;
    }

    protected Map getMapFromDatastoreObject(AbstractMemberMetaData mmd, ExecutionContext ec, ClassLoaderResolver clr, String propName) {
        Object propValue = this.datastoreEntity.getProperty(propName);
        List keysValues = (List)propValue;
        if (propValue != null) {
            Map map = null;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager());
            AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, ec.getMetaDataManager());
            Iterator keyValIter = keysValues.iterator();
            ArrayList<Key> keysToRetrieve = new ArrayList<Key>();
            while (keyValIter.hasNext()) {
                Object key = keyValIter.next();
                if (keyCmd != null) {
                    keysToRetrieve.add((Key)key);
                }
                Object val = keyValIter.next();
                if (valCmd == null) continue;
                keysToRetrieve.add((Key)val);
            }
            DatastoreServiceConfig config = this.getStoreManager().getDefaultDatastoreServiceConfigForReads();
            DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
            Map entitiesByKey = ds.get(keysToRetrieve);
            keyValIter = keysValues.iterator();
            boolean changeDetected = false;
            while (keyValIter.hasNext()) {
                Object key = keyValIter.next();
                if (keyCmd != null) {
                    Entity entity = (Entity)entitiesByKey.get(key);
                    if (entity == null) {
                        changeDetected = true;
                        NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Field " + mmd.getFullFieldName() + " of " + this.datastoreEntity.getKey() + " has a map referring to key=" + key + " but doesn't exist, so must have been deleted. Ignoring"));
                        continue;
                    }
                    key = EntityUtils.entityToPojo(entity, keyCmd, clr, ec, false, ec.getFetchPlan());
                }
                Object val = keyValIter.next();
                if (valCmd != null) {
                    Entity entity = (Entity)entitiesByKey.get(val);
                    if (entity == null) {
                        changeDetected = true;
                        NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Field " + mmd.getFullFieldName() + " of " + this.datastoreEntity.getKey() + " has a map referring to value=" + val + " but doesn't exist, so must have been deleted. Ignoring"));
                        continue;
                    }
                    val = EntityUtils.entityToPojo(entity, valCmd, clr, ec, false, ec.getFetchPlan());
                }
                map.put(key, val);
            }
            map = (Map)this.getObjectProvider().wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, changeDetected, false);
            if (changeDetected) {
                this.getObjectProvider().makeDirty(mmd.getAbsoluteFieldNumber());
            }
            return map;
        }
        return null;
    }
}

