/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.datanucleus.DatastoreExceptionTranslator;
import com.google.appengine.datanucleus.Utils;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.QueryTimeoutException;

final class QueryExceptionWrappers {
    private QueryExceptionWrappers() {
    }

    static <T> Utils.Supplier<T> datastoreToDataNucleus(final Utils.Supplier<T> supplier) {
        return new Utils.Supplier<T>(){

            @Override
            public T get() {
                try {
                    return supplier.get();
                }
                catch (IllegalArgumentException e) {
                    throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
                }
                catch (DatastoreTimeoutException e) {
                    throw DatastoreExceptionTranslator.wrapDatastoreTimeoutExceptionForQuery(e);
                }
                catch (DatastoreFailureException e) {
                    throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
                }
            }
        };
    }

    static <T> Utils.Supplier<T> dataNucleusToApi(final ApiAdapter api, final Utils.Supplier<T> supplier) {
        return new Utils.Supplier<T>(){

            @Override
            public T get() {
                try {
                    return supplier.get();
                }
                catch (QueryTimeoutException te) {
                    throw api.getApiExceptionForNucleusException((NucleusException)((Object)te));
                }
                catch (NucleusException ne) {
                    throw api.getApiExceptionForNucleusException(ne);
                }
            }
        };
    }
}

