/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.EnumSet;
import org.w3c.dom.Element;

public class BackendsXmlReader
extends AbstractConfigXmlReader<BackendsXml> {
    private static final String FILENAME = "WEB-INF/backends.xml";

    public BackendsXmlReader(String appDir) {
        super(appDir, false);
    }

    public BackendsXml readBackendsXml() {
        return (BackendsXml)this.readConfigXml();
    }

    @Override
    protected BackendsXml processXml(InputStream is) {
        BackendsXml backendsXml = new BackendsXml();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        for (Element backendElement : XmlUtils.getChildren(root, "backend")) {
            backendsXml.addBackend(this.convertBackendNode(backendElement));
        }
        return backendsXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }

    private BackendsXml.Entry convertBackendNode(Element backendElement) {
        Element optionsElement;
        String maxConcurrentRequestsText;
        String name = this.trim(backendElement.getAttribute("name"));
        Integer instances = null;
        String instanceClass = XmlUtils.getOptionalChildElementBody(backendElement, "class");
        Integer maxConcurrentRequests = null;
        EnumSet<BackendsXml.Option> options = EnumSet.noneOf(BackendsXml.Option.class);
        String instancesText = XmlUtils.getOptionalChildElementBody(backendElement, "instances");
        if (instancesText != null) {
            instances = Integer.valueOf(instancesText);
        }
        if ((maxConcurrentRequestsText = XmlUtils.getOptionalChildElementBody(backendElement, "max-concurrent-requests")) != null) {
            maxConcurrentRequests = Integer.valueOf(maxConcurrentRequestsText);
        }
        if ((optionsElement = XmlUtils.getOptionalChildElement(backendElement, "options")) != null) {
            if (this.getBooleanOption(optionsElement, "fail-fast")) {
                options.add(BackendsXml.Option.FAIL_FAST);
            }
            if (this.getBooleanOption(optionsElement, "dynamic")) {
                options.add(BackendsXml.Option.DYNAMIC);
            }
            if (this.getBooleanOption(optionsElement, "public")) {
                options.add(BackendsXml.Option.PUBLIC);
            }
        }
        return new BackendsXml.Entry(name, instances, instanceClass, maxConcurrentRequests, options, null);
    }

    private boolean getBooleanOption(Element optionsElement, String optionName) {
        Element optionElement = XmlUtils.getOptionalChildElement(optionsElement, optionName);
        if (optionElement == null) {
            return false;
        }
        String value = XmlUtils.getText(optionElement);
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    private String trim(String attribute) {
        return attribute == null ? null : attribute.trim();
    }
}

