/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.io.ByteSink;
import com.google.appengine.repackaged.com.google.common.io.ByteSource;
import com.google.appengine.repackaged.com.google.common.io.CharSource;
import com.google.appengine.repackaged.com.google.common.labs.command.AutoValue_Command;
import com.google.appengine.repackaged.com.google.common.labs.command.AutoValue_Command_ExitCodeSuccessCondition;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandExecutor;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandFailureException;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandProcess;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandResult;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandStartException;
import com.google.appengine.repackaged.com.google.common.labs.command.InputSource;
import com.google.appengine.repackaged.com.google.common.labs.command.LineConsumingByteSink;
import com.google.appengine.repackaged.com.google.common.labs.command.NativeProcess;
import com.google.appengine.repackaged.com.google.common.labs.command.OutputSink;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import com.google.auto.value.AutoValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@AutoValue
public abstract class Command {
    public static final ImmutableMap<String, String> SYSTEM_ENVIRONMENT = ImmutableMap.copyOf(System.getenv());
    public static final CommandExecutor NATIVE_EXECUTOR = NativeProcess.EXECUTOR;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/appengine/repackaged/com/google/common/labs/command/Command");

    Command() {
    }

    public static Command command(String executable, String ... args) {
        return new AutoValue_Command(executable, ImmutableList.copyOf(args), SYSTEM_ENVIRONMENT, Optional.empty(), InputSource.fromProcess(), OutputSink.toProcessOut(), OutputSink.toProcessErr(), ExitCodeSuccessCondition.create(0, new int[0]), NATIVE_EXECUTOR);
    }

    public static Command command(Path executable, String ... args) {
        return Command.command(Command.sanitizePath(executable), args);
    }

    private static String sanitizePath(Path executable) {
        return executable.equals(executable.getFileName()) ? executable.getFileSystem().getPath(".", new String[0]).resolve(executable).toString() : executable.toString();
    }

    public abstract String executable();

    public abstract ImmutableList<String> arguments();

    public abstract ImmutableMap<String, String> environment();

    public abstract Optional<Path> workingDirectory();

    public abstract InputSource stdinSource();

    public abstract OutputSink stdoutSink();

    public abstract OutputSink stderrSink();

    public abstract SuccessCondition successCondition();

    public abstract CommandExecutor executor();

    public final Command withExecutable(Path executable) {
        return this.withExecutable(Command.sanitizePath(executable));
    }

    public final Command withExecutable(String executable) {
        return new AutoValue_Command(executable, this.arguments(), this.environment(), this.workingDirectory(), this.stdinSource(), this.stdoutSink(), this.stderrSink(), this.successCondition(), this.executor());
    }

    public final Command withArguments(List<String> arguments) {
        return new AutoValue_Command(this.executable(), ImmutableList.copyOf(arguments), this.environment(), this.workingDirectory(), this.stdinSource(), this.stdoutSink(), this.stderrSink(), this.successCondition(), this.executor());
    }

    public final Command withArguments(String first, String ... rest) {
        return this.withArguments(Lists.asList(first, rest));
    }

    public final Command withArgumentsAppended(List<String> arguments) {
        return this.withArguments((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.arguments())).addAll(arguments)).build()));
    }

    public final Command withArgumentsAppended(String first, String ... rest) {
        return this.withArgumentsAppended(Lists.asList(first, rest));
    }

    public final Command withEnvironment(Map<String, String> environment) {
        return new AutoValue_Command(this.executable(), this.arguments(), ImmutableMap.copyOf(environment), this.workingDirectory(), this.stdinSource(), this.stdoutSink(), this.stderrSink(), this.successCondition(), this.executor());
    }

    public final Command withEnvironment(String firstKey, String firstValue, String ... rest) {
        return this.withEnvironment(Command.mapFromVarArgs(firstKey, firstValue, rest));
    }

    public final Command withEnvironmentUpdated(Map<String, String> environment) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder().putAll(environment);
        for (Map.Entry e : this.environment().entrySet()) {
            if (environment.containsKey(e.getKey())) continue;
            builder.put(e);
        }
        return this.withEnvironment(builder.build());
    }

    public final Command withEnvironmentUpdated(String firstKey, String firstValue, String ... rest) {
        return this.withEnvironmentUpdated(Command.mapFromVarArgs(firstKey, firstValue, rest));
    }

    private static Map<String, String> mapFromVarArgs(String firstKey, String firstValue, String ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "odd number of key/value arguments");
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put(firstKey, firstValue);
        for (int i = 0; i < rest.length; i += 2) {
            builder.put(rest[i], rest[i + 1]);
        }
        return builder.build();
    }

    public final Command withWorkingDirectory(Optional<Path> directory) {
        return new AutoValue_Command(this.executable(), this.arguments(), this.environment(), directory, this.stdinSource(), this.stdoutSink(), this.stderrSink(), this.successCondition(), this.executor());
    }

    public final Command withWorkingDirectory(String directory) {
        return this.withWorkingDirectory(Paths.get(directory, new String[0]));
    }

    public final Command withWorkingDirectory(Path directory) {
        return this.withWorkingDirectory(Optional.of(directory));
    }

    public final Command withStdinFrom(Path file) {
        return this.withStdinFrom(InputSource.fromFile(file));
    }

    public final Command withStdinFrom(String string, Charset charset) {
        return this.withStdinFrom(CharSource.wrap(string).asByteSource(charset));
    }

    public final Command withStdinFrom(ByteSource byteSource) {
        return this.withStdinFrom(InputSource.fromStream(byteSource));
    }

    public final Command withStdinFrom(InputSource stdinSource) {
        return new AutoValue_Command(this.executable(), this.arguments(), this.environment(), this.workingDirectory(), stdinSource, this.stdoutSink(), this.stderrSink(), this.successCondition(), this.executor());
    }

    public final Command withStdinFromUtf8(String string) {
        return this.withStdinFrom(string, StandardCharsets.UTF_8);
    }

    public final Command withStdinFromJvm() {
        return this.withStdinFrom(InputSource.fromJvm());
    }

    public final Command withStdoutTo(Path file) {
        return this.withStdoutTo(OutputSink.toFile(file));
    }

    public final Command withStdoutTo(ByteSink byteSink) {
        return this.withStdoutTo(OutputSink.toStream(byteSink));
    }

    public final Command withStdoutTo(Consumer<String> lineConsumer, Charset charset) {
        return this.withStdoutTo(LineConsumingByteSink.create(lineConsumer, charset));
    }

    public final Command withStdoutTo(OutputSink outputSink) {
        return new AutoValue_Command(this.executable(), this.arguments(), this.environment(), this.workingDirectory(), this.stdinSource(), outputSink, this.stderrSink(), this.successCondition(), this.executor());
    }

    public final Command withStdoutToUtf8(Consumer<String> lineConsumer) {
        return this.withStdoutTo(lineConsumer, StandardCharsets.UTF_8);
    }

    public final Command withStdoutToJvm() {
        return this.withStdoutTo(OutputSink.toJvmOut());
    }

    public final Command withStderrTo(Path file) {
        return this.withStderrTo(OutputSink.toFile(file));
    }

    public final Command withStderrTo(ByteSink byteSink) {
        return this.withStderrTo(OutputSink.toStream(byteSink));
    }

    public final Command withStderrTo(Consumer<String> lineConsumer, Charset charset) {
        return this.withStderrTo(LineConsumingByteSink.create(lineConsumer, charset));
    }

    public final Command withStderrTo(OutputSink outputSink) {
        return new AutoValue_Command(this.executable(), this.arguments(), this.environment(), this.workingDirectory(), this.stdinSource(), this.stdoutSink(), outputSink, this.successCondition(), this.executor());
    }

    public final Command withStderrToUtf8(Consumer<String> lineConsumer) {
        return this.withStderrTo(lineConsumer, StandardCharsets.UTF_8);
    }

    public final Command withStderrToJvm() {
        return this.withStderrTo(OutputSink.toJvmErr());
    }

    public final Command withStdoutAndStderrTo(Path file) {
        return this.withStdoutTo(file).withStderrTo(file);
    }

    public final Command withStdoutAndStderrTo(ByteSink byteSink) {
        return this.withStdoutTo(byteSink).withStderrTo(byteSink);
    }

    public final Command withStdoutAndStderrTo(Consumer<String> lineConsumer, Charset charset) {
        return this.withStdoutTo(lineConsumer, charset).withStderrTo(lineConsumer, charset);
    }

    public final Command withStdoutAndStderrTo(OutputSink outputSink) {
        return this.withStdoutTo(outputSink).withStderrTo(outputSink);
    }

    public final Command withStdoutAndStderrToUtf8(Consumer<String> lineConsumer) {
        return this.withStdoutAndStderrTo(lineConsumer, StandardCharsets.UTF_8);
    }

    public final Command withStdoutAndStderrToJvm() {
        return this.withStdoutToJvm().withStderrToJvm();
    }

    public final Command withSuccessExitCodes(int first, int ... rest) {
        return this.withSuccessCondition(ExitCodeSuccessCondition.create(first, rest));
    }

    public final Command withSuccessCondition(SuccessCondition condition) {
        return new AutoValue_Command(this.executable(), this.arguments(), this.environment(), this.workingDirectory(), this.stdinSource(), this.stdoutSink(), this.stderrSink(), condition, this.executor());
    }

    public final Command withExecutor(CommandExecutor executor) {
        return new AutoValue_Command(this.executable(), this.arguments(), this.environment(), this.workingDirectory(), this.stdinSource(), this.stdoutSink(), this.stderrSink(), this.successCondition(), executor);
    }

    public final CommandProcess start() throws CommandStartException {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/Command", "start", 586, "Command.java")).log("Started command: %s", this);
        return this.executor().start(this);
    }

    @CanIgnoreReturnValue
    public final CommandResult execute() throws CommandStartException, CommandFailureException, InterruptedException {
        CommandProcess process = this.start();
        try {
            return process.await();
        }
        catch (InterruptedException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/Command", "execute", 609, "Command.java")).log("Thread interrupted; killing command: %s", this);
            process.kill();
            throw e;
        }
    }

    @CanIgnoreReturnValue
    public final CommandResult executeUninterruptibly() throws CommandStartException, CommandFailureException {
        return this.start().awaitUninterruptibly();
    }

    @CanIgnoreReturnValue
    public final <E extends Exception> CommandResult executeChecked(Function<Exception, E> factory) throws E {
        try {
            return this.execute();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (Exception)factory.apply(e);
        }
        catch (CommandFailureException | CommandStartException e) {
            throw (Exception)factory.apply(e);
        }
    }

    @Immutable
    @AutoValue
    static abstract class ExitCodeSuccessCondition
    implements SuccessCondition {
        ExitCodeSuccessCondition() {
        }

        abstract ImmutableSet<Integer> exitCodes();

        private static ExitCodeSuccessCondition create(int first, int ... rest) {
            ImmutableCollection.Builder builder = ImmutableSet.builder().add((Object)first);
            for (int exitCode : rest) {
                ((ImmutableSet.Builder)builder).add((Object)exitCode);
            }
            return new AutoValue_Command_ExitCodeSuccessCondition((ImmutableSet<Integer>)((ImmutableSet.Builder)builder).build());
        }

        @Override
        public boolean test(CommandResult result) {
            return this.exitCodes().contains(result.exitCode());
        }
    }

    @Immutable
    public static interface SuccessCondition
    extends Predicate<CommandResult> {
    }
}

