/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;

public class EnhancerTask
extends Java {
    private File dir;
    private String ifpropertyset;
    private String fileSuffixes = "jdo";
    Vector<FileSet> filesets = new Vector();

    public EnhancerTask() {
        this.setClassname("com.google.appengine.tools.enhancer.Enhance");
        this.setFork(true);
    }

    @Override
    public void execute() throws BuildException {
        if (this.ifpropertyset != null && this.getProject().getProperty(this.ifpropertyset) == null) {
            String string = this.ifpropertyset;
            this.log(new StringBuilder(49 + String.valueOf(string).length()).append("Property ").append(string).append(" is not set. This task will not execute.").toString(), 3);
            return;
        }
        File[] files = this.getFiles();
        if (files.length == 0) {
            String string = String.valueOf(this.fileSuffixes);
            this.log(string.length() != 0 ? "Scanning for files with suffixes: ".concat(string) : new String("Scanning for files with suffixes: "), 3);
            StringTokenizer token = new StringTokenizer(this.fileSuffixes, ",");
            while (token.hasMoreTokens()) {
                DirectoryScanner ds = this.getDirectoryScanner(this.getDir());
                String[] stringArray = new String[1];
                String string2 = String.valueOf(token.nextToken());
                stringArray[0] = string2.length() != 0 ? "**\\*.".concat(string2) : new String("**\\*.");
                ds.setIncludes(stringArray);
                ds.scan();
                for (int i = 0; i < ds.getIncludedFiles().length; ++i) {
                    this.createArg().setFile(new File(this.getDir(), ds.getIncludedFiles()[i]));
                }
            }
        } else {
            int token = files.length;
            this.log(new StringBuilder(80).append("FileSet has ").append(token).append(" files. Enhancer task will not scan for additional files.").toString(), 3);
            for (int i = 0; i < files.length; ++i) {
                this.createArg().setFile(files[i]);
            }
        }
        super.execute();
    }

    public void setCheckonly(boolean checkonly) {
        if (checkonly) {
            this.createArg().setValue("-checkonly");
            this.log(new StringBuilder(25).append("Enhancer checkonly: ").append(checkonly).toString(), 3);
        }
    }

    private DirectoryScanner getDirectoryScanner(File dir) {
        FileSet fileset = new FileSet();
        fileset.setDir(dir);
        return fileset.getDirectoryScanner(this.getProject());
    }

    public void setDestination(File destdir) {
        if (destdir != null && destdir.length() > 0L) {
            this.createArg().setValue("-d");
            this.createArg().setFile(destdir);
            String string = String.valueOf(destdir);
            this.log(new StringBuilder(18 + String.valueOf(string).length()).append("Enhancer destdir: ").append(string).toString(), 3);
        }
    }

    public void setApi(String api) {
        if (api != null && api.length() > 0) {
            this.createArg().setValue("-api");
            this.createArg().setValue(api);
            String string = String.valueOf(api);
            this.log(string.length() != 0 ? "Enhancer api: ".concat(string) : new String("Enhancer api: "), 3);
        }
    }

    public void setEnhancerName(String enhancer) {
        if (enhancer != null && enhancer.length() > 0) {
            this.createArg().setValue("-enhancerName");
            this.createArg().setValue(enhancer);
            String string = String.valueOf(enhancer);
            this.log(string.length() != 0 ? "Enhancer enhancerName: ".concat(string) : new String("Enhancer enhancerName: "), 3);
        }
    }

    public void setPersistenceUnit(String unit) {
        if (unit != null && unit.length() > 0) {
            this.createArg().setValue("-persistenceUnit");
            this.createArg().setValue(unit);
            String string = String.valueOf(unit);
            this.log(string.length() != 0 ? "Enhancer persistenceUnit: ".concat(string) : new String("Enhancer persistenceUnit: "), 3);
        }
    }

    @Override
    public void setDir(File dir) {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir == null ? this.getProject().getBaseDir() : this.dir;
    }

    public void setFileSuffixes(String suffixes) {
        this.fileSuffixes = suffixes;
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.createArg().setValue("-v");
            this.log(new StringBuilder(23).append("Enhancer verbose: ").append(verbose).toString(), 3);
        }
    }

    public void addFileSet(FileSet fs) {
        this.filesets.addElement(fs);
    }

    protected File[] getFiles() {
        Vector<File> v = new Vector<File>();
        int size = this.filesets.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] f = ds.getIncludedFiles();
            for (int j = 0; j < f.length; ++j) {
                String pathname = f[j];
                File file = new File(ds.getBasedir(), pathname);
                file = this.getProject().resolveFile(file.getPath());
                v.add(file);
            }
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    public void setIf(String ifpropertyset) {
        this.ifpropertyset = ifpropertyset;
    }
}

