/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.bridge.BaseMessageMarshaller;
import java.io.IOException;
import java.io.Serializable;

public class MessageMarshaller<T extends Message>
extends BaseMessageMarshaller<T>
implements Serializable {
    private static final long serialVersionUID = 233811181L;
    private final transient T defaultInstance;
    private final Class<? extends Message> messageClass;
    private boolean useExtensionRegistry = false;

    public MessageMarshaller(T defaultInstance) {
        this.messageClass = defaultInstance.getClass();
        this.defaultInstance = defaultInstance;
        this.useExtensionRegistry = false;
    }

    @Override
    protected T reconstituteMessage(CodedInputStream codedInputStream) throws IOException {
        if (this.useExtensionRegistry) {
            return (T)this.defaultInstance.getParserForType().parsePartialFrom(codedInputStream, (ExtensionRegistryLite)ExtensionRegistry.getGeneratedRegistry());
        }
        return (T)this.defaultInstance.getParserForType().parsePartialFrom(codedInputStream);
    }

    public static <T extends Message> MessageMarshaller<T> of(Class<T> messageClass) {
        return new MessageMarshaller<T>(MessageMarshaller.getDefaultInstanceOf(messageClass));
    }

    public MessageMarshaller<T> includingGeneratedExtensions() {
        this.useExtensionRegistry = true;
        return this;
    }

    private MessageMarshaller<T> includingGeneratedExtensions(boolean useExtensionRegistry) {
        this.useExtensionRegistry = useExtensionRegistry;
        return this;
    }

    private Object readResolve() {
        return super.includingGeneratedExtensions(this.useExtensionRegistry);
    }
}

