/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import java.util.Map;

public class DevAppServerPortPropertyHelper {
    public static final int DEFAULT_PORT = 0;
    public static final String SYSTEM_PROPERTY_STATIC_MODULE_PORT_NUM_PREFIX = "com.google.appengine.devappserver_module.";

    private DevAppServerPortPropertyHelper() {
    }

    public static int setPort(String moduleName, int port, Map<String, String> serviceProperties) {
        return DevAppServerPortPropertyHelper.setPort(moduleName, -1, port, serviceProperties);
    }

    public static int setPort(String moduleName, int instance, int port, Map<String, String> serviceProperties) {
        String propertyName = DevAppServerPortPropertyHelper.getInstancePropertyName(moduleName, instance);
        serviceProperties.put(propertyName, Integer.toString(port));
        return port;
    }

    public static int getPort(String moduleName, Map<String, String> serviceProperties) {
        return DevAppServerPortPropertyHelper.getPort(moduleName, -1, serviceProperties);
    }

    public static int getPort(String moduleName, int instance, Map<String, String> serviceProperties) {
        String propertyName = DevAppServerPortPropertyHelper.getInstancePropertyName(moduleName, instance);
        if (serviceProperties.containsKey(propertyName)) {
            return Integer.parseInt(serviceProperties.get(propertyName));
        }
        return 0;
    }

    private static String getInstancePropertyName(String moduleName, int instance) {
        String instanceSpec = instance == -1 ? "" : new StringBuilder(12).append(".").append(instance).toString();
        return new StringBuilder(46 + String.valueOf(moduleName).length() + String.valueOf(instanceSpec).length()).append(SYSTEM_PROPERTY_STATIC_MODULE_PORT_NUM_PREFIX).append(moduleName).append(instanceSpec).append(".port").toString();
    }
}

