/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Transaction;
import java.sql.SQLException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.store.appengine.DatastoreExceptionTranslator;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreTransaction {
    private final Transaction txn;
    private final Map<Key, Entity> putEntities = Utils.newHashMap();
    private final Set<Key> deletedKeys = Utils.newHashSet(new Object[0]);

    DatastoreTransaction(Transaction txn) {
        if (txn == null) {
            throw new NullPointerException("txn cannot be null");
        }
        this.txn = txn;
    }

    private void clear() {
        this.putEntities.clear();
        this.deletedKeys.clear();
    }

    void commit() throws SQLException {
        try {
            this.txn.commit();
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (ConcurrentModificationException e) {
            SQLException sql = new SQLException("Concurrent Modification");
            sql.initCause(e);
            throw sql;
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
        this.clear();
    }

    void rollback() {
        try {
            this.txn.rollback();
            this.clear();
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    public Transaction getInnerTxn() {
        return this.txn;
    }

    void addPutEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            this.putEntities.put(entity.getKey(), this.makeCopy(entity));
        }
    }

    private Entity makeCopy(Entity entity) {
        Entity copy = new Entity(entity.getKind());
        DatastoreFieldManager.copyProperties(entity, copy);
        return copy;
    }

    void addDeletedKey(Key key) {
        this.deletedKeys.add(key);
    }

    Map<Key, Entity> getPutEntities() {
        return this.putEntities;
    }

    Set<Key> getDeletedKeys() {
        return this.deletedKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatastoreTransaction that = (DatastoreTransaction)o;
        return this.txn.equals(that.txn);
    }

    public int hashCode() {
        return this.txn.hashCode();
    }
}

