/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLevel2Cache
implements Level2Cache {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected NucleusContext nucleusCtx;
    protected int maxSize = -1;
    protected boolean clearAtClose = true;
    protected long timeout = -1L;
    protected String cacheName;

    public AbstractLevel2Cache(NucleusContext nucleusCtx) {
        this.nucleusCtx = nucleusCtx;
        PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
        this.maxSize = conf.getIntProperty("datanucleus.cache.level2.maxSize");
        this.clearAtClose = conf.getBooleanProperty("datanucleus.cache.level2.clearAtClose", true);
        if (conf.hasProperty("datanucleus.cache.level2.timeout")) {
            this.timeout = conf.getIntProperty("datanucleus.cache.level2.timeout");
        }
        this.cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn("No 'datanucleus.cache.level2.cacheName' specified so using name of 'dataNucleus'");
            this.cacheName = "dataNucleus";
        }
    }

    @Override
    public Map<Object, CachedPC> getAll(Collection oids) {
        if (oids == null) {
            return null;
        }
        HashMap<Object, CachedPC> objs = new HashMap<Object, CachedPC>();
        for (Object id : oids) {
            CachedPC value = this.get(id);
            objs.put(id, value);
        }
        return objs;
    }

    @Override
    public void putAll(Map<Object, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        for (Map.Entry<Object, CachedPC> entry : objs.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not supported by this plugin");
    }

    @Override
    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not supported by this plugin");
    }

    @Override
    public void pin(Object arg0) {
        throw new UnsupportedOperationException("pin(Object) method not supported by this plugin");
    }

    @Override
    public void pinAll(Collection arg0) {
        throw new UnsupportedOperationException("pinAll(Collection) method not supported by this plugin");
    }

    @Override
    public void pinAll(Object[] arg0) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not supported by this plugin");
    }

    @Override
    public void pinAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("pinAll(Class,boolean) method not supported by this plugin");
    }

    @Override
    public void unpin(Object arg0) {
        throw new UnsupportedOperationException("unpin(Object) method not supported by this plugin");
    }

    @Override
    public void unpinAll(Collection arg0) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not supported by this plugin");
    }

    @Override
    public void unpinAll(Object[] arg0) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not supported by this plugin");
    }

    @Override
    public void unpinAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("unpinAll(Class,boolean) method not supported by this plugin");
    }
}

