/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.GetIndexesRequest;
import com.google.appengine.api.search.GetRequest;
import com.google.appengine.api.search.GetResponse;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.Query;
import com.google.appengine.api.search.QueryOptions;
import com.google.appengine.api.search.Results;
import com.google.appengine.api.search.ScoredDocument;
import com.google.appengine.api.search.SearchService;
import com.google.appengine.api.search.SearchServiceFactory;
import com.google.appengine.api.search.StatusCode;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.servlet.DatastoreViewerServlet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SearchServlet
extends HttpServlet {
    private static final String APPLICATION_NAME = "applicationName";
    private static final String SUBSECTION = "subsection";
    private static final String NAMESPACE = "namespace";
    private static final String INDEX_NAME = "indexName";
    private static final String QUERY = "query";
    private static final String DOC_ID = "docid";
    private static final String MATCHED_COUNT = "matchedCount";
    private static final String PREV_LINK = "prev";
    private static final String DOCUMENT = "document";
    private static final String FIELDS = "fields";
    private static final String FIELD_NAMES = "fieldNames";
    private static final String CURRENT_LINK = "current";
    private static final String START = "start";
    private static final String END = "end";
    private static final String DOC = "doc";
    private static final String NUM_PER_PAGE = "numPerPage";
    private static final String DOCUMENTS = "documents";
    private static final String INDEXES = "indexes";
    private static final String START_BASE_URL = "startBaseURL";
    private static final String DELETE_ACTION = "Delete";
    private static final String ACTION = "action";
    private static final String NUM_DOCS = "numdocs";
    private static final String PAGES = "pages";
    private static final String CURRENT_PAGE = "currentPage";
    private static final String PREV_START = "prevStart";
    private static final String NEXT_START = "nextStart";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final int MAX_PAGER_LINKS = 8;
    private static final Logger logger = Logger.getLogger(DatastoreViewerServlet.class.getName());

    private static String urlencode(String val) throws UnsupportedEncodingException {
        return URLEncoder.encode(val, "UTF-8");
    }

    private static int getIntParam(ServletRequest request, String paramName, int defaultVal) {
        String val = request.getParameter(paramName);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    private static String getStringParam(ServletRequest request, String paramName, String defaultVal) {
        String val = request.getParameter(paramName);
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    private static String getPrevLink(ServletRequest request, String defaultVal) {
        String val = request.getParameter(PREV_LINK);
        if (val == null || !val.startsWith("/")) {
            val = defaultVal;
        }
        return val;
    }

    private static String filterURL(HttpServletRequest req, String ... paramsToInclude) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(String.valueOf(req.getRequestURI()).concat("?"));
        for (String arg : paramsToInclude) {
            String value = req.getParameter(arg);
            if (value == null) continue;
            sb.append(String.format("&%s=%s", arg, SearchServlet.urlencode(value)));
        }
        return sb.toString();
    }

    private String makeErrorMessage(Object msg) {
        if (msg == null) {
            return "Error: unknown error occurred";
        }
        String string = String.valueOf(msg);
        return new StringBuilder(7 + String.valueOf(string).length()).append("Error: ").append(string).toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String subsectionStr = req.getParameter(SUBSECTION);
        Subsection subsection = Subsection.searchIndexesList;
        if (subsectionStr != null) {
            subsection = Subsection.valueOf(subsectionStr);
        }
        switch (subsection) {
            case searchIndexesList: {
                this.doGetIndexesList(req, resp);
                break;
            }
            case searchIndex: {
                this.doGetIndex(req, resp);
                break;
            }
            case searchDocument: {
                this.doGetDocument(req, resp);
                break;
            }
            default: {
                resp.sendError(404);
            }
        }
    }

    private void doGetIndexesList(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int start = SearchServlet.getIntParam((ServletRequest)req, START, 0);
        int numPerPage = SearchServlet.getIntParam((ServletRequest)req, NUM_PER_PAGE, 10);
        String requestedNamespace = req.getParameter(NAMESPACE);
        ArrayList indexes = null;
        String namespace = requestedNamespace != null ? requestedNamespace : "";
        boolean hasMore = false;
        try {
            SearchService search = SearchServiceFactory.getSearchService((String)namespace);
            GetIndexesRequest.Builder searchRequest = GetIndexesRequest.newBuilder();
            searchRequest.setIncludeStartIndex(true);
            searchRequest.setLimit(Integer.valueOf(numPerPage + 1));
            searchRequest.setOffset(Integer.valueOf(start));
            GetResponse searchResponse = search.getIndexes(searchRequest.build());
            indexes = searchResponse.getResults();
            if (indexes.size() > numPerPage) {
                hasMore = true;
                indexes = new ArrayList(indexes);
                indexes.remove(numPerPage - 1);
            }
            int currentPage = start / numPerPage;
            req.setAttribute(END, (Object)(start + indexes.size()));
            req.setAttribute(PREV_START, (Object)(currentPage > 0 ? (currentPage - 1) * numPerPage : -1));
            req.setAttribute(NEXT_START, (Object)(hasMore ? (currentPage + 1) * numPerPage : -1));
            req.setAttribute(INDEXES, indexes);
        }
        catch (RuntimeException e) {
            logger.logp(Level.SEVERE, "com.google.apphosting.utils.servlet.SearchServlet", "doGetIndexesList", "failed to retrieve indexes list", e);
            req.setAttribute(ERROR_MESSAGE, (Object)this.makeErrorMessage(e.getMessage()));
        }
        this.setCommonAttributes(req, namespace);
        req.setAttribute(CURRENT_LINK, (Object)SearchServlet.urlencode(SearchServlet.filterURL(req, NAMESPACE, START, NUM_PER_PAGE)));
        req.setAttribute(START_BASE_URL, (Object)SearchServlet.filterURL(req, NAMESPACE, NUM_PER_PAGE));
        try {
            String string = String.valueOf(Subsection.searchIndexesList.name());
            this.getServletContext().getRequestDispatcher(string.length() != 0 ? "/_ah/adminConsole?subsection=".concat(string) : new String("/_ah/adminConsole?subsection=")).forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    private void fillInSearchResults(HttpServletRequest req, Results<ScoredDocument> searchResponse, int start, int numPerPage) {
        Collection searchResults = searchResponse.getResults();
        long matchedCount = searchResponse.getNumberFound();
        HashSet<String> fieldNames = new HashSet<String>();
        for (ScoredDocument result : searchResults) {
            for (Field field : result.getFields()) {
                fieldNames.add(field.getName());
            }
        }
        ArrayList<String> sortedFieldNames = new ArrayList<String>(fieldNames);
        Collections.sort(sortedFieldNames);
        req.setAttribute(FIELD_NAMES, sortedFieldNames);
        ArrayList<DocumentView> docViews = new ArrayList<DocumentView>();
        for (ScoredDocument result : searchResults) {
            docViews.add(new DocumentView((Document)result, sortedFieldNames));
        }
        req.setAttribute(DOCUMENTS, docViews);
        int currentPage = start / numPerPage;
        int numPages = (int)Math.ceil((double)matchedCount * (1.0 / (double)numPerPage));
        int pageStart = (int)Math.max(Math.floor(currentPage - 4), 0.0);
        int pageEnd = Math.min(pageStart + 8, numPages);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = pageStart + 1; i < pageEnd + 1; ++i) {
            pages.add(new Page(i, (i - 1) * numPerPage));
        }
        req.setAttribute(END, (Object)(start + searchResults.size()));
        req.setAttribute(MATCHED_COUNT, (Object)matchedCount);
        req.setAttribute(PAGES, pages);
        req.setAttribute(CURRENT_PAGE, (Object)(currentPage + 1));
        req.setAttribute(PREV_START, (Object)(currentPage > 0 ? (currentPage - 1) * numPerPage : -1));
        req.setAttribute(NEXT_START, (Object)(currentPage < numPages - 1 ? (currentPage + 1) * numPerPage : -1));
    }

    private void doGetIndex(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int start = SearchServlet.getIntParam((ServletRequest)req, START, 0);
        int numPerPage = SearchServlet.getIntParam((ServletRequest)req, NUM_PER_PAGE, 10);
        String indexName = req.getParameter(INDEX_NAME);
        String requestedNamespace = req.getParameter(NAMESPACE);
        String query = SearchServlet.getStringParam((ServletRequest)req, QUERY, "");
        String namespace = requestedNamespace != null ? requestedNamespace : "";
        try {
            SearchService search = SearchServiceFactory.getSearchService((String)namespace);
            Index index = search.getIndex(IndexSpec.newBuilder().setName(indexName));
            Query searchRequest = Query.newBuilder().setOptions(QueryOptions.newBuilder().setLimit(numPerPage).setOffset(start)).build(query);
            Results searchResponse = index.search(searchRequest);
            if (searchResponse.getOperationResult().getCode() == StatusCode.OK) {
                this.fillInSearchResults(req, (Results<ScoredDocument>)searchResponse, start, numPerPage);
            } else {
                req.setAttribute(ERROR_MESSAGE, (Object)this.makeErrorMessage(searchResponse.getOperationResult().getMessage()));
            }
        }
        catch (RuntimeException e) {
            logger.logp(Level.SEVERE, "com.google.apphosting.utils.servlet.SearchServlet", "doGetIndex", "failed to retrieve documents list", e);
            req.setAttribute(ERROR_MESSAGE, (Object)this.makeErrorMessage(e.getMessage()));
        }
        this.setCommonAttributes(req, requestedNamespace);
        req.setAttribute(INDEX_NAME, (Object)indexName);
        req.setAttribute(QUERY, (Object)query);
        req.setAttribute(START_BASE_URL, (Object)SearchServlet.filterURL(req, SUBSECTION, NAMESPACE, INDEX_NAME, QUERY, NUM_PER_PAGE, PREV_LINK));
        req.setAttribute(PREV_LINK, (Object)SearchServlet.getPrevLink((ServletRequest)req, String.format("/_ah/admin/search?namespace=%s", requestedNamespace)));
        req.setAttribute(CURRENT_LINK, (Object)SearchServlet.urlencode(SearchServlet.filterURL(req, SUBSECTION, NAMESPACE, INDEX_NAME, QUERY, START, NUM_PER_PAGE, PREV_LINK)));
        resp.setContentType("text/html; charset=UTF-8");
        String url = String.format("/_ah/adminConsole?subsection=%s&indexName=%s&namespace=%s", Subsection.searchIndex.name(), indexName, namespace);
        try {
            this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    private void doGetDocument(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestedNamespace = req.getParameter(NAMESPACE);
        String namespace = requestedNamespace != null ? requestedNamespace : "";
        String indexName = req.getParameter(INDEX_NAME);
        String docId = req.getParameter(DOC_ID);
        Document doc = null;
        ArrayList<FieldView> fields = new ArrayList<FieldView>();
        try {
            SearchService search = SearchServiceFactory.getSearchService((String)namespace);
            Index index = search.getIndex(IndexSpec.newBuilder().setName(indexName));
            GetRequest getRequest = GetRequest.newBuilder().setLimit(Integer.valueOf(1)).setStartId(docId).setIncludeStart(true).build();
            GetResponse getResponse = index.getRange(getRequest);
            Iterator it = getResponse.iterator();
            if (it.hasNext()) {
                doc = (Document)it.next();
            }
            if (doc != null && docId.equals(doc.getId())) {
                for (Field field : doc.getFields()) {
                    fields.add(new FieldView(field));
                }
            } else {
                doc = null;
                req.setAttribute(ERROR_MESSAGE, (Object)"Document is not found");
            }
        }
        catch (RuntimeException e) {
            logger.logp(Level.SEVERE, "com.google.apphosting.utils.servlet.SearchServlet", "doGetDocument", "failed to retrieve document", e);
            req.setAttribute(ERROR_MESSAGE, (Object)this.makeErrorMessage(e.getMessage()));
        }
        this.setCommonAttributes(req, requestedNamespace);
        req.setAttribute(PREV_LINK, (Object)SearchServlet.getPrevLink((ServletRequest)req, String.format("/_ah/admin/search?subsection=%s&namespace=%s&indexName=%s", Subsection.searchIndex.name(), requestedNamespace, indexName)));
        req.setAttribute(DOCUMENT, (Object)doc);
        req.setAttribute(FIELDS, fields);
        resp.setContentType("text/html; charset=UTF-8");
        try {
            String string = String.valueOf(Subsection.searchDocument.name());
            this.getServletContext().getRequestDispatcher(string.length() != 0 ? "/_ah/adminConsole?subsection=".concat(string) : new String("/_ah/adminConsole?subsection=")).forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (DELETE_ACTION.equals(req.getParameter(ACTION))) {
            this.deleteDocuments(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void deleteDocuments(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String message;
        String indexName = req.getParameter(INDEX_NAME);
        String namespace = req.getParameter(NAMESPACE);
        ArrayList<String> docIds = new ArrayList<String>();
        int numDocs = Integer.parseInt(req.getParameter(NUM_DOCS));
        for (int i = 1; i <= numDocs; ++i) {
            int n = i;
            String docId = req.getParameter(new StringBuilder(14).append(DOC).append(n).toString());
            if (docId == null) continue;
            docIds.add(docId);
        }
        try {
            SearchService search = SearchServiceFactory.getSearchService((String)namespace);
            Index index = search.getIndex(IndexSpec.newBuilder().setName(indexName));
            index.delete(docIds);
            message = String.format("%d document%s deleted.", docIds.size(), docIds.size() == 1 ? "" : "s");
        }
        catch (RuntimeException e) {
            logger.logp(Level.SEVERE, "com.google.apphosting.utils.servlet.SearchServlet", "deleteDocuments", "failed to retrieve documents list", e);
            message = this.makeErrorMessage(e.getMessage());
        }
        resp.sendRedirect(String.format("%s&msg=%s", req.getParameter("next"), SearchServlet.urlencode(message)));
    }

    private void setCommonAttributes(HttpServletRequest req, String namespace) {
        req.setAttribute(NAMESPACE, (Object)namespace);
        req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
    }

    public static class FieldView {
        private String name;
        private String type;
        private String value;

        public FieldView(Field field) {
            if (field == null) {
                this.name = "";
                this.type = "";
                this.value = "";
                return;
            }
            this.name = field.getName();
            this.type = field.getType().toString();
            switch (field.getType()) {
                case TEXT: {
                    this.value = field.getText();
                    break;
                }
                case HTML: {
                    this.value = field.getHTML();
                    break;
                }
                case ATOM: {
                    this.value = field.getAtom();
                    break;
                }
                case NUMBER: {
                    this.value = Double.toString(field.getNumber());
                    break;
                }
                case DATE: {
                    this.value = new SimpleDateFormat("yyyy-MM-dd").format(field.getDate());
                    break;
                }
                case GEO_POINT: {
                    this.value = field.getGeoPoint().toString();
                    break;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getTruncatedValue() {
            if (this.value.length() < 32) {
                return this.value;
            }
            return String.valueOf(this.value.substring(0, 32)).concat("...");
        }
    }

    public static class DocumentView {
        String id;
        int orderId;
        List<FieldView> fieldViews;

        public DocumentView(Document doc, List<String> fieldNames) {
            this.id = doc.getId();
            this.orderId = doc.getRank();
            this.fieldViews = new ArrayList<FieldView>();
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            for (Field field : doc.getFields()) {
                fieldMap.put(field.getName(), field);
            }
            for (String fieldName : fieldNames) {
                this.fieldViews.add(new FieldView((Field)fieldMap.get(fieldName)));
            }
        }

        public String getId() {
            return this.id;
        }

        public int getOrderId() {
            return this.orderId;
        }

        public List<FieldView> getFieldViews() {
            return this.fieldViews;
        }
    }

    public static final class Page {
        private final int number;
        private final int start;

        private Page(int number, int start) {
            this.number = number;
            this.start = start;
        }

        public int getNumber() {
            return this.number;
        }

        public int getStart() {
            return this.start;
        }
    }

    private static enum Subsection {
        searchIndexesList,
        searchIndex,
        searchDocument;

    }
}

