/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.escape;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.escape.ArrayBasedCharEscaper;
import com.google.appengine.repackaged.com.google.common.escape.ArrayBasedUnicodeEscaper;
import com.google.appengine.repackaged.com.google.common.escape.CharEscaper;
import com.google.appengine.repackaged.com.google.common.escape.CharEscaperBuilder;
import com.google.appengine.repackaged.com.google.common.escape.Escaper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@GoogleInternal
@GwtCompatible
public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final Escaper JAVA_CHAR_ESCAPER;
    private static final Escaper JAVA_CHAR_ESCAPER_WITH_OCTAL;
    private static final Escaper JAVA_STRING_ESCAPER_WITH_OCTAL;
    private static final Escaper JAVA_STRING_UNICODE_ESCAPER;
    private static final Escaper JAVASCRIPT_ESCAPER;
    private static final Escaper PYTHON_ESCAPER;
    @GoogleInternal
    private static final Escaper SIMPLE_PYTHON_ESCAPER;
    private static final Escaper DART_STRING_ESCAPER;
    @GoogleInternal
    private static final Escaper C_STRING_ESCAPER;

    private SourceCodeEscapers() {
    }

    public static Escaper javaCharEscaper() {
        return JAVA_CHAR_ESCAPER;
    }

    @GoogleInternal
    public static Escaper javaCharEscaperWithOctal() {
        return JAVA_CHAR_ESCAPER_WITH_OCTAL;
    }

    @GoogleInternal
    public static Escaper javaStringEscaperWithOctal() {
        return JAVA_STRING_ESCAPER_WITH_OCTAL;
    }

    public static Escaper javaStringUnicodeEscaper() {
        return JAVA_STRING_UNICODE_ESCAPER;
    }

    public static Escaper javascriptEscaper() {
        return JAVASCRIPT_ESCAPER;
    }

    public static Escaper pythonEscaper() {
        return PYTHON_ESCAPER;
    }

    @GoogleInternal
    public static Escaper simplePythonEscaper() {
        return SIMPLE_PYTHON_ESCAPER;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    private static char[] asOctalEscape(char c) {
        char[] r = new char[4];
        r[0] = 92;
        r[3] = HEX_DIGITS[c & 7];
        c = (char)(c >>> 3);
        r[2] = HEX_DIGITS[c & 7];
        c = (char)(c >>> 3);
        r[1] = HEX_DIGITS[c & 3];
        return r;
    }

    private static char[] asHexEscape(char cp) {
        char[] r = new char[4];
        r[3] = HEX_DIGITS[cp & 0xF];
        cp = (char)(cp >>> 4);
        r[2] = HEX_DIGITS[cp & 0xF];
        r[1] = 120;
        r[0] = 92;
        return r;
    }

    public static Escaper dartStringEscaper() {
        return DART_STRING_ESCAPER;
    }

    @GoogleInternal
    public static Escaper cStringEscaper() {
        return C_STRING_ESCAPER;
    }

    static {
        HashMap<Character, String> javaMap = new HashMap<Character, String>();
        javaMap.put(Character.valueOf('\b'), "\\b");
        javaMap.put(Character.valueOf('\f'), "\\f");
        javaMap.put(Character.valueOf('\n'), "\\n");
        javaMap.put(Character.valueOf('\r'), "\\r");
        javaMap.put(Character.valueOf('\t'), "\\t");
        javaMap.put(Character.valueOf('\"'), "\\\"");
        javaMap.put(Character.valueOf('\\'), "\\\\");
        JAVA_STRING_ESCAPER_WITH_OCTAL = new JavaCharEscaperWithOctal(javaMap);
        javaMap.put(Character.valueOf('\''), "\\'");
        JAVA_CHAR_ESCAPER = new JavaCharEscaper(javaMap);
        JAVA_CHAR_ESCAPER_WITH_OCTAL = new JavaCharEscaperWithOctal(javaMap);
        JAVA_STRING_UNICODE_ESCAPER = new CharEscaper(){

            @Override
            protected char[] escape(char c) {
                if (c < '\u0080') {
                    return null;
                }
                return SourceCodeEscapers.asUnicodeHexEscape(c);
            }
        };
        HashMap<Character, String> jsMap = new HashMap<Character, String>();
        jsMap.put(Character.valueOf('\''), "\\x27");
        jsMap.put(Character.valueOf('\"'), "\\x22");
        jsMap.put(Character.valueOf('<'), "\\x3c");
        jsMap.put(Character.valueOf('='), "\\x3d");
        jsMap.put(Character.valueOf('>'), "\\x3e");
        jsMap.put(Character.valueOf('&'), "\\x26");
        jsMap.put(Character.valueOf('\b'), "\\b");
        jsMap.put(Character.valueOf('\t'), "\\t");
        jsMap.put(Character.valueOf('\n'), "\\n");
        jsMap.put(Character.valueOf('\f'), "\\f");
        jsMap.put(Character.valueOf('\r'), "\\r");
        jsMap.put(Character.valueOf('\\'), "\\\\");
        JAVASCRIPT_ESCAPER = new ArrayBasedCharEscaper(jsMap, ' ', '~'){

            @Override
            protected char[] escapeUnsafe(char c) {
                if (c < '\u0100') {
                    char[] r = new char[4];
                    r[3] = HEX_DIGITS[c & 0xF];
                    c = (char)(c >>> 4);
                    r[2] = HEX_DIGITS[c & 0xF];
                    r[1] = 120;
                    r[0] = 92;
                    return r;
                }
                return SourceCodeEscapers.asUnicodeHexEscape(c);
            }
        };
        HashMap<Character, String> pythonMap = new HashMap<Character, String>();
        pythonMap.put(Character.valueOf('\n'), "\\n");
        pythonMap.put(Character.valueOf('\r'), "\\r");
        pythonMap.put(Character.valueOf('\t'), "\\t");
        pythonMap.put(Character.valueOf('\\'), "\\\\");
        pythonMap.put(Character.valueOf('\''), "\\'");
        pythonMap.put(Character.valueOf('\"'), "\\\"");
        PYTHON_ESCAPER = new ArrayBasedUnicodeEscaper(pythonMap, 32, 126, null){

            @Override
            protected char[] escapeUnsafe(int cp) {
                if (cp < 256) {
                    return SourceCodeEscapers.asHexEscape((char)cp);
                }
                if (cp < 65536) {
                    return SourceCodeEscapers.asUnicodeHexEscape((char)cp);
                }
                char[] r = new char[10];
                r[9] = HEX_DIGITS[cp & 0xF];
                r[8] = HEX_DIGITS[(cp >>>= 4) & 0xF];
                r[7] = HEX_DIGITS[(cp >>>= 4) & 0xF];
                r[6] = HEX_DIGITS[(cp >>>= 4) & 0xF];
                r[5] = HEX_DIGITS[(cp >>>= 4) & 0xF];
                r[4] = HEX_DIGITS[(cp >>>= 4) & 0xF];
                r[3] = HEX_DIGITS[(cp >>>= 4) & 0xF];
                r[2] = HEX_DIGITS[(cp >>>= 4) & 0xF];
                r[1] = 85;
                r[0] = 92;
                return r;
            }
        };
        SIMPLE_PYTHON_ESCAPER = new CharEscaperBuilder().addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").addEscape('\\', "\\\\").addEscape('\"', "\\\"").addEscape('\'', "\\'").toEscaper();
        HashMap<Character, String> dartMap = new HashMap<Character, String>();
        dartMap.put(Character.valueOf('\n'), "\\n");
        dartMap.put(Character.valueOf('\r'), "\\r");
        dartMap.put(Character.valueOf('\f'), "\\f");
        dartMap.put(Character.valueOf('\b'), "\\b");
        dartMap.put(Character.valueOf('\t'), "\\t");
        dartMap.put(Character.valueOf('\u000b'), "\\v");
        dartMap.put(Character.valueOf('\"'), "\\\"");
        dartMap.put(Character.valueOf('\''), "\\'");
        dartMap.put(Character.valueOf('\\'), "\\\\");
        dartMap.put(Character.valueOf('$'), "\\$");
        DART_STRING_ESCAPER = new DartStringEscaper(dartMap);
        C_STRING_ESCAPER = new CharEscaperBuilder().addEscape('\'', "\\'").addEscape('\"', "\\\"").addEscape('?', "\\?").addEscape('\\', "\\\\").addEscape('\f', "\\f").addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").addEscape('\u0007', "\\a").addEscape('\b', "\\b").addEscape('\u000b', "\\v").toEscaper();
    }

    private static class DartStringEscaper
    extends ArrayBasedUnicodeEscaper {
        DartStringEscaper(Map<Character, String> replacements) {
            super(replacements, 32, 126, null);
        }

        private char[] asVariableLengthUnicodeHexEscape(int cp) {
            int i;
            char[] r = new char[10];
            r[9] = 125;
            for (i = 8; cp != 0 && i > 2; cp >>>= 4, --i) {
                r[i] = HEX_DIGITS[cp & 0xF];
            }
            r[i--] = 123;
            r[i--] = 117;
            r[i] = 92;
            if (i == 0) {
                return r;
            }
            return Arrays.copyOfRange(r, i, 10);
        }

        @Override
        protected char[] escapeUnsafe(int cp) {
            if (cp < 256) {
                return SourceCodeEscapers.asHexEscape((char)cp);
            }
            if (cp < 4096) {
                return this.asVariableLengthUnicodeHexEscape(cp);
            }
            if (cp < 65536) {
                return SourceCodeEscapers.asUnicodeHexEscape((char)cp);
            }
            return this.asVariableLengthUnicodeHexEscape(cp);
        }
    }

    private static class JavaCharEscaperWithOctal
    extends ArrayBasedCharEscaper {
        JavaCharEscaperWithOctal(Map<Character, String> replacements) {
            super(replacements, ' ', '~');
        }

        @Override
        protected char[] escapeUnsafe(char c) {
            if (c < '\u0100') {
                return SourceCodeEscapers.asOctalEscape(c);
            }
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }
    }

    private static class JavaCharEscaper
    extends ArrayBasedCharEscaper {
        JavaCharEscaper(Map<Character, String> replacements) {
            super(replacements, ' ', '~');
        }

        @Override
        protected char[] escapeUnsafe(char c) {
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }
    }
}

