/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.chrono.AssembledChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicFixedMonthChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicSingleEraDateTimeField;
import com.google.appengine.repackaged.org.joda.time.chrono.LimitChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.ZonedChronology;
import com.google.appengine.repackaged.org.joda.time.field.SkipDateTimeField;
import java.util.concurrent.ConcurrentHashMap;

public final class EthiopicChronology
extends BasicFixedMonthChronology {
    private static final long serialVersionUID = -5972804258688333942L;
    public static final int EE = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("EE");
    private static final int MIN_YEAR = -292269337;
    private static final int MAX_YEAR = 292272984;
    private static final ConcurrentHashMap<DateTimeZone, EthiopicChronology[]> cCache = new ConcurrentHashMap();
    private static final EthiopicChronology INSTANCE_UTC = EthiopicChronology.getInstance(DateTimeZone.UTC);

    public static EthiopicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static EthiopicChronology getInstance() {
        return EthiopicChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static EthiopicChronology getInstance(DateTimeZone zone) {
        return EthiopicChronology.getInstance(zone, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EthiopicChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        EthiopicChronology chrono;
        EthiopicChronology[] oldChronos;
        EthiopicChronology[] chronos;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if ((chronos = cCache.get(zone)) == null && (oldChronos = cCache.putIfAbsent(zone, chronos = new EthiopicChronology[7])) != null) {
            chronos = oldChronos;
        }
        try {
            chrono = chronos[minDaysInFirstWeek - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Invalid min days in first week: ").append(minDaysInFirstWeek).toString());
        }
        if (chrono != null) return chrono;
        EthiopicChronology[] ethiopicChronologyArray = chronos;
        synchronized (chronos) {
            chrono = chronos[minDaysInFirstWeek - 1];
            if (chrono != null) return chrono;
            if (zone == DateTimeZone.UTC) {
                chrono = new EthiopicChronology(null, null, minDaysInFirstWeek);
                DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                chrono = new EthiopicChronology(LimitChronology.getInstance(chrono, lowerLimit, null), null, minDaysInFirstWeek);
            } else {
                chrono = EthiopicChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                chrono = new EthiopicChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
            }
            chronos[minDaysInFirstWeek - 1] = chrono;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return chrono;
        }
    }

    EthiopicChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? EthiopicChronology.getInstance(DateTimeZone.UTC, this.getMinimumDaysInFirstWeek()) : EthiopicChronology.getInstance(base.getZone(), this.getMinimumDaysInFirstWeek());
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return EthiopicChronology.getInstance(zone);
    }

    @Override
    long calculateFirstDayOfYearMillis(int year) {
        int leapYears;
        int relativeYear = year - 1963;
        if (relativeYear <= 0) {
            leapYears = relativeYear + 3 >> 2;
        } else {
            leapYears = relativeYear >> 2;
            if (!this.isLeapYear(year)) {
                ++leapYears;
            }
        }
        long millis = ((long)relativeYear * 365L + (long)leapYears) * 86400000L;
        return millis + 21859200000L;
    }

    @Override
    int getMinYear() {
        return -292269337;
    }

    @Override
    int getMaxYear() {
        return 292272984;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 30962844000000L;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 13);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }
}

