/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.chrono.AssembledChronology;
import com.google.appengine.repackaged.org.joda.time.field.StrictDateTimeField;

public final class StrictChronology
extends AssembledChronology {
    private static final long serialVersionUID = 6633006628097111960L;
    private transient Chronology iWithUTC;

    public static StrictChronology getInstance(Chronology base) {
        if (base == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        return new StrictChronology(base);
    }

    private StrictChronology(Chronology base) {
        super(base, null);
    }

    @Override
    public Chronology withUTC() {
        if (this.iWithUTC == null) {
            this.iWithUTC = this.getZone() == DateTimeZone.UTC ? this : StrictChronology.getInstance(this.getBase().withUTC());
        }
        return this.iWithUTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == DateTimeZone.UTC) {
            return this.withUTC();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return StrictChronology.getInstance(this.getBase().withZone(zone));
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        fields.year = StrictChronology.convertField(fields.year);
        fields.yearOfEra = StrictChronology.convertField(fields.yearOfEra);
        fields.yearOfCentury = StrictChronology.convertField(fields.yearOfCentury);
        fields.centuryOfEra = StrictChronology.convertField(fields.centuryOfEra);
        fields.era = StrictChronology.convertField(fields.era);
        fields.dayOfWeek = StrictChronology.convertField(fields.dayOfWeek);
        fields.dayOfMonth = StrictChronology.convertField(fields.dayOfMonth);
        fields.dayOfYear = StrictChronology.convertField(fields.dayOfYear);
        fields.monthOfYear = StrictChronology.convertField(fields.monthOfYear);
        fields.weekOfWeekyear = StrictChronology.convertField(fields.weekOfWeekyear);
        fields.weekyear = StrictChronology.convertField(fields.weekyear);
        fields.weekyearOfCentury = StrictChronology.convertField(fields.weekyearOfCentury);
        fields.millisOfSecond = StrictChronology.convertField(fields.millisOfSecond);
        fields.millisOfDay = StrictChronology.convertField(fields.millisOfDay);
        fields.secondOfMinute = StrictChronology.convertField(fields.secondOfMinute);
        fields.secondOfDay = StrictChronology.convertField(fields.secondOfDay);
        fields.minuteOfHour = StrictChronology.convertField(fields.minuteOfHour);
        fields.minuteOfDay = StrictChronology.convertField(fields.minuteOfDay);
        fields.hourOfDay = StrictChronology.convertField(fields.hourOfDay);
        fields.hourOfHalfday = StrictChronology.convertField(fields.hourOfHalfday);
        fields.clockhourOfDay = StrictChronology.convertField(fields.clockhourOfDay);
        fields.clockhourOfHalfday = StrictChronology.convertField(fields.clockhourOfHalfday);
        fields.halfdayOfDay = StrictChronology.convertField(fields.halfdayOfDay);
    }

    private static final DateTimeField convertField(DateTimeField field) {
        return StrictDateTimeField.getInstance(field);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StrictChronology)) {
            return false;
        }
        StrictChronology chrono = (StrictChronology)obj;
        return this.getBase().equals(chrono.getBase());
    }

    public int hashCode() {
        return 352831696 + this.getBase().hashCode() * 7;
    }

    @Override
    public String toString() {
        String string = this.getBase().toString();
        return new StringBuilder(18 + String.valueOf(string).length()).append("StrictChronology[").append(string).append(']').toString();
    }
}

