/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.field;

import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

public final class UnsupportedDateTimeField
extends DateTimeField
implements Serializable {
    private static final long serialVersionUID = -1934618396111902255L;
    private static HashMap<DateTimeFieldType, UnsupportedDateTimeField> cCache;
    private final DateTimeFieldType iType;
    private final DurationField iDurationField;

    public static synchronized UnsupportedDateTimeField getInstance(DateTimeFieldType type, DurationField durationField) {
        UnsupportedDateTimeField field;
        if (cCache == null) {
            cCache = new HashMap(7);
            field = null;
        } else {
            field = cCache.get(type);
            if (field != null && field.getDurationField() != durationField) {
                field = null;
            }
        }
        if (field == null) {
            field = new UnsupportedDateTimeField(type, durationField);
            cCache.put(type, field);
        }
        return field;
    }

    private UnsupportedDateTimeField(DateTimeFieldType type, DurationField durationField) {
        if (type == null || durationField == null) {
            throw new IllegalArgumentException();
        }
        this.iType = type;
        this.iDurationField = durationField;
    }

    @Override
    public DateTimeFieldType getType() {
        return this.iType;
    }

    @Override
    public String getName() {
        return this.iType.getName();
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long instant) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(long instant, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(long instant) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(ReadablePartial partial, int fieldValue, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(ReadablePartial partial, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(int fieldValue, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(long instant, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(long instant) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(ReadablePartial partial, int fieldValue, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(ReadablePartial partial, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(int fieldValue, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public long add(long instant, int value) {
        return this.getDurationField().add(instant, value);
    }

    @Override
    public long add(long instant, long value) {
        return this.getDurationField().add(instant, value);
    }

    @Override
    public int[] add(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        throw this.unsupported();
    }

    @Override
    public int[] addWrapPartial(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        throw this.unsupported();
    }

    @Override
    public long addWrapField(long instant, int value) {
        throw this.unsupported();
    }

    @Override
    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        throw this.unsupported();
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifference(minuendInstant, subtrahendInstant);
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    @Override
    public long set(long instant, int value) {
        throw this.unsupported();
    }

    @Override
    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, int newValue) {
        throw this.unsupported();
    }

    @Override
    public long set(long instant, String text, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public long set(long instant, String text) {
        throw this.unsupported();
    }

    @Override
    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, String text, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public DurationField getDurationField() {
        return this.iDurationField;
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public boolean isLeap(long instant) {
        throw this.unsupported();
    }

    @Override
    public int getLeapAmount(long instant) {
        throw this.unsupported();
    }

    @Override
    public DurationField getLeapDurationField() {
        return null;
    }

    @Override
    public int getMinimumValue() {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(long instant) {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(ReadablePartial instant) {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(ReadablePartial instant, int[] values) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue() {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(long instant) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(ReadablePartial instant) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(ReadablePartial instant, int[] values) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumShortTextLength(Locale locale) {
        throw this.unsupported();
    }

    @Override
    public long roundFloor(long instant) {
        throw this.unsupported();
    }

    @Override
    public long roundCeiling(long instant) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfFloor(long instant) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfCeiling(long instant) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfEven(long instant) {
        throw this.unsupported();
    }

    @Override
    public long remainder(long instant) {
        throw this.unsupported();
    }

    @Override
    public String toString() {
        return "UnsupportedDateTimeField";
    }

    private Object readResolve() {
        return UnsupportedDateTimeField.getInstance(this.iType, this.iDurationField);
    }

    private UnsupportedOperationException unsupported() {
        String string = String.valueOf(this.iType);
        return new UnsupportedOperationException(new StringBuilder(21 + String.valueOf(string).length()).append(string).append(" field is unsupported").toString());
    }
}

