/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.CloudTraceContext;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class CloudTrace {
    private static final String KEY = "com.google.apphosting.api.cloudTrace";
    private static final ThreadLocal<CloudTraceContext> perThreadContext = new ThreadLocal();

    @Nullable
    private static CloudTrace get(ApiProxy.Environment env) {
        return (CloudTrace)env.getAttributes().get(KEY);
    }

    @Nullable
    public static CloudTraceContext getCurrentContext(ApiProxy.Environment env) {
        CloudTrace cloudTrace = CloudTrace.get(env);
        return cloudTrace == null ? null : cloudTrace.getCurrentContext();
    }

    @Nullable
    private CloudTraceContext getCurrentContext() {
        CloudTraceContext context = perThreadContext.get();
        if (context == null) {
            context = this.getDefaultContext();
            perThreadContext.set(context);
        }
        return context;
    }

    public static void setCurrentContext(ApiProxy.Environment env, @Nullable CloudTraceContext context) {
        CloudTrace cloudTrace = CloudTrace.get(env);
        if (cloudTrace != null) {
            perThreadContext.set(context);
        }
    }

    public CloudTrace(ApiProxy.Environment env) {
        this.bind(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(ApiProxy.Environment env) {
        CloudTrace original;
        Map<String, Object> attrs;
        Map<String, Object> map = attrs = env.getAttributes();
        synchronized (map) {
            original = (CloudTrace)attrs.get(KEY);
            if (original == null) {
                attrs.put(KEY, this);
                return;
            }
        }
        if (original != this) {
            throw new IllegalStateException("Cannot replace existing CloudTrace object");
        }
    }

    @Nullable
    protected abstract CloudTraceContext getDefaultContext();

    @Nullable
    public static CloudTraceContext startChildSpan(ApiProxy.Environment env, CloudTraceContext context, String name) {
        CloudTrace cloudTrace = CloudTrace.get(env);
        if (cloudTrace == null) {
            return null;
        }
        if (context != perThreadContext.get()) {
            throw new IllegalStateException("Can not startChildSpan for a different context");
        }
        CloudTraceContext childContext = cloudTrace.startChildSpanImpl(context, name);
        perThreadContext.set(childContext);
        return childContext;
    }

    public static void setLabel(ApiProxy.Environment env, CloudTraceContext context, String key, String value) {
        CloudTrace cloudTrace = CloudTrace.get(env);
        if (cloudTrace == null) {
            return;
        }
        if (context != perThreadContext.get()) {
            throw new IllegalStateException("Can not setLabel for a different context");
        }
        cloudTrace.setLabelImpl(context, key, value);
    }

    public static void endSpan(ApiProxy.Environment env, CloudTraceContext context, CloudTraceContext parent) {
        CloudTrace cloudTrace = CloudTrace.get(env);
        if (cloudTrace == null) {
            return;
        }
        if (context != perThreadContext.get()) {
            throw new IllegalStateException("Can not endSpan for a different context");
        }
        cloudTrace.endSpanImpl(context);
        perThreadContext.set(parent);
    }

    @Nullable
    protected abstract CloudTraceContext startChildSpanImpl(CloudTraceContext var1, String var2);

    protected abstract void setLabelImpl(CloudTraceContext var1, String var2, String var3);

    protected abstract void endSpanImpl(CloudTraceContext var1);
}

