/**********************************************************************
Copyright (c) 2009 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.jdo.metadata;

import javax.jdo.metadata.ColumnMetadata;
import javax.jdo.metadata.FieldMetadata;
import javax.jdo.metadata.IndexMetadata;
import javax.jdo.metadata.MemberMetadata;
import javax.jdo.metadata.PropertyMetadata;

import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.PropertyMetaData;

/**
 * Implementation of JDO IndexMetadata object.
 */
public class IndexMetadataImpl extends AbstractMetadataImpl implements IndexMetadata
{
    public IndexMetadataImpl(IndexMetaData internal)
    {
        super(internal);
    }

    public IndexMetaData getInternal()
    {
        return (IndexMetaData)internalMD;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#getColumns()
     */
    public ColumnMetadata[] getColumns()
    {
        ColumnMetaData[] internalColmds = getInternal().getColumnMetaData();
        if (internalColmds == null)
        {
            return null;
        }
        ColumnMetadataImpl[] colmds = new ColumnMetadataImpl[internalColmds.length];
        for (int i=0;i<colmds.length;i++)
        {
            colmds[i] = new ColumnMetadataImpl(internalColmds[i]);
            colmds[i].parent = this;
        }
        return colmds;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#getMembers()
     */
    public MemberMetadata[] getMembers()
    {
        AbstractMemberMetaData[] internalMmds = getInternal().getMemberMetaData();
        if (internalMmds == null)
        {
            return null;
        }
        MemberMetadataImpl[] mmds = new MemberMetadataImpl[internalMmds.length];
        for (int i=0;i<mmds.length;i++)
        {
            if (internalMmds[i] instanceof FieldMetaData)
            {
                mmds[i] = new FieldMetadataImpl((FieldMetaData)internalMmds[i]);
            }
            else
            {
                mmds[i] = new PropertyMetadataImpl((PropertyMetaData)internalMmds[i]);
            }
            mmds[i].parent = this;
        }
        return mmds;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#getName()
     */
    public String getName()
    {
        return getInternal().getName();
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#getNumberOfColumns()
     */
    public int getNumberOfColumns()
    {
        ColumnMetaData[] colmds = getInternal().getColumnMetaData();
        return (colmds != null ? colmds.length : 0);
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#getNumberOfMembers()
     */
    public int getNumberOfMembers()
    {
        AbstractMemberMetaData[] mmds = getInternal().getMemberMetaData();
        return (mmds != null ? mmds.length : 0);
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#getTable()
     */
    public String getTable()
    {
        return getInternal().getTable();
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#getUnique()
     */
    public boolean getUnique()
    {
        return getInternal().isUnique();
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#newColumn()
     */
    public ColumnMetadata newColumn()
    {
        ColumnMetaData internalColmd = getInternal().newColumnMetaData();
        ColumnMetadataImpl colmd = new ColumnMetadataImpl(internalColmd);
        colmd.parent = this;
        return colmd;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#newFieldMetadata(java.lang.String)
     */
    public FieldMetadata newFieldMetadata(String name)
    {
        FieldMetaData internalFmd = getInternal().newFieldMetaData(name);
        FieldMetadataImpl fmd = new FieldMetadataImpl(internalFmd);
        fmd.parent = this;
        return fmd;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#newPropertyMetadata(java.lang.String)
     */
    public PropertyMetadata newPropertyMetadata(String name)
    {
        PropertyMetaData internalPmd = getInternal().newPropertyMetaData(name);
        PropertyMetadataImpl pmd = new PropertyMetadataImpl(internalPmd);
        pmd.parent = this;
        return pmd;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#setName(java.lang.String)
     */
    public IndexMetadata setName(String name)
    {
        getInternal().setName(name);
        return this;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#setTable(java.lang.String)
     */
    public IndexMetadata setTable(String name)
    {
        getInternal().setTable(name);
        return this;
    }

    /* (non-Javadoc)
     * @see javax.jdo.metadata.IndexMetadata#setUnique(boolean)
     */
    public IndexMetadata setUnique(boolean flag)
    {
        getInternal().setUnique(flag);
        return this;
    }
}