/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kerby.config.Conf;
import org.apache.kerby.config.Config;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.config.Resource;
import org.apache.kerby.kerberos.kerb.common.Krb5Parser;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;

public class Krb5Conf
extends Conf {
    private static final String LIST_SPLITTER = " |,";
    private Map<String, Object> krb5Map;

    public void addKrb5Config(File krb5File) throws IOException {
        Krb5Parser krb5Parser = new Krb5Parser(krb5File);
        krb5Parser.load();
        this.krb5Map = krb5Parser.getItems();
        this.addResource(Resource.createMapResource(this.krb5Map));
    }

    protected String getString(ConfigKey key, boolean useDefault, String ... sections) {
        String value = this.getString(key, false);
        if (value == null) {
            String section;
            Config subConfig;
            String[] arr$ = sections;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((subConfig = this.getConfig(section = arr$[i$])) == null || (value = subConfig.getString(key, false)) == null); ++i$) {
            }
        }
        if (value == null && useDefault) {
            value = (String)key.getDefaultValue();
        }
        return value;
    }

    protected Boolean getBoolean(ConfigKey key, boolean useDefault, String ... sections) {
        Boolean value = this.getBoolean(key, false);
        if (value == null) {
            String section;
            Config subConfig;
            String[] arr$ = sections;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((subConfig = this.getConfig(section = arr$[i$])) == null || (value = subConfig.getBoolean(key, false)) == null); ++i$) {
            }
        }
        if (value == null && useDefault) {
            value = (Boolean)key.getDefaultValue();
        }
        return value;
    }

    protected Long getLong(ConfigKey key, boolean useDefault, String ... sections) {
        Long value = this.getLong(key, false);
        if (value == null) {
            String section;
            Config subConfig;
            String[] arr$ = sections;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((subConfig = this.getConfig(section = arr$[i$])) == null || (value = subConfig.getLong(key, false)) == null); ++i$) {
            }
        }
        if (value == null && useDefault) {
            value = (Long)key.getDefaultValue();
        }
        return value;
    }

    protected Integer getInt(ConfigKey key, boolean useDefault, String ... sections) {
        Integer value = this.getInt(key, false);
        if (value == null) {
            String section;
            Config subConfig;
            String[] arr$ = sections;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((subConfig = this.getConfig(section = arr$[i$])) == null || (value = subConfig.getInt(key, false)) == null); ++i$) {
            }
        }
        if (value == null && useDefault) {
            value = (Integer)key.getDefaultValue();
        }
        return value;
    }

    protected List<EncryptionType> getEncTypes(ConfigKey key, boolean useDefault, String ... sections) {
        String[] encTypesNames = this.getStringArray(key, useDefault, sections);
        return this.getEncryptionTypes(encTypesNames);
    }

    protected List<EncryptionType> getEncryptionTypes(String[] encTypeNames) {
        return this.getEncryptionTypes(Arrays.asList(encTypeNames));
    }

    protected List<EncryptionType> getEncryptionTypes(List<String> encTypeNames) {
        ArrayList<EncryptionType> results = new ArrayList<EncryptionType>(encTypeNames.size());
        for (String eTypeName : encTypeNames) {
            EncryptionType eType = EncryptionType.fromName(eTypeName);
            if (eType == EncryptionType.NONE) continue;
            results.add(eType);
        }
        return results;
    }

    protected String[] getStringArray(ConfigKey key, boolean useDefault, String ... sections) {
        String value = this.getString(key, useDefault, sections);
        if (value != null) {
            return value.split(LIST_SPLITTER);
        }
        return new String[0];
    }

    protected Object getSection(String sectionName) {
        if (this.krb5Map != null) {
            for (Map.Entry<String, Object> entry : this.krb5Map.entrySet()) {
                if (!entry.getKey().equals(sectionName)) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

