/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SparseArrayIterator
implements Iterator {
    public static final SparseArrayIterator EMPTY_ITERATOR = new SparseArrayIterator(new Object[0]);
    private Object[] m_array;
    private int m_offset;

    private SparseArrayIterator(Object[] array) {
        this.m_array = array;
        this.m_offset = -1;
        this.advance();
    }

    protected boolean advance() {
        while (++this.m_offset < this.m_array.length) {
            if (this.m_array[this.m_offset] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.m_offset < this.m_array.length;
    }

    public Object next() {
        if (this.m_offset < this.m_array.length) {
            Object result = this.m_array[this.m_offset];
            this.advance();
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static Iterator buildIterator(Object[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_ITERATOR;
        }
        return new SparseArrayIterator(array);
    }
}

