/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.addressing.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.metadata.InterfaceName;
import org.apache.axis2.addressing.metadata.ServiceName;
import org.apache.axis2.addressing.metadata.WSDLLocation;
import org.apache.axis2.jaxws.addressing.factory.Axis2EndpointReferenceFactory;
import org.apache.axis2.jaxws.addressing.factory.JAXWSEndpointReferenceFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Element;

public final class EndpointReferenceUtils {
    private static OMFactory omFactory = OMAbstractFactory.getOMFactory();

    private EndpointReferenceUtils() {
    }

    public static EndpointReference convertFromAxis2(org.apache.axis2.addressing.EndpointReference axis2EPR, String addressingNamespace) throws Exception {
        QName qname = new QName(addressingNamespace, "EndpointReference", "wsa");
        OMElement omElement = EndpointReferenceHelper.toOM((OMFactory)omFactory, (org.apache.axis2.addressing.EndpointReference)axis2EPR, (QName)qname, (String)addressingNamespace);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        omElement.serialize((OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        StreamSource eprInfoset = new StreamSource(bais);
        return EndpointReferenceUtils.convertFromSource(eprInfoset);
    }

    public static EndpointReference convertFromSource(Source eprInfoset) throws Exception {
        JAXWSEndpointReferenceFactory factory = (JAXWSEndpointReferenceFactory)FactoryRegistry.getFactory(JAXWSEndpointReferenceFactory.class);
        return factory.createEndpointReference(eprInfoset);
    }

    public static String convertToAxis2(org.apache.axis2.addressing.EndpointReference axis2EPR, EndpointReference jaxwsEPR) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jaxwsEPR.writeTo((Result)new StreamResult(baos));
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        OMElement eprElement = (OMElement)XMLUtils.toOM((InputStream)bais);
        return EndpointReferenceHelper.fromOM((org.apache.axis2.addressing.EndpointReference)axis2EPR, (OMElement)eprElement);
    }

    public static <T extends EndpointReference> String getAddressingNamespace(Class<T> clazz) {
        JAXWSEndpointReferenceFactory factory = (JAXWSEndpointReferenceFactory)FactoryRegistry.getFactory(JAXWSEndpointReferenceFactory.class);
        return factory.getAddressingNamespace(clazz);
    }

    public static org.apache.axis2.addressing.EndpointReference createAxis2EndpointReference(String address, QName serviceName, QName portName, String wsdlDocumentLocation, String addressingNamespace) {
        Axis2EndpointReferenceFactory factory = (Axis2EndpointReferenceFactory)FactoryRegistry.getFactory(Axis2EndpointReferenceFactory.class);
        return factory.createEndpointReference(address, serviceName, portName, wsdlDocumentLocation, addressingNamespace);
    }

    public static org.apache.axis2.addressing.EndpointReference createAxis2EndpointReference(String address) {
        Axis2EndpointReferenceFactory factory = (Axis2EndpointReferenceFactory)FactoryRegistry.getFactory(Axis2EndpointReferenceFactory.class);
        return factory.createEndpointReference(address);
    }

    public static void addReferenceParameters(org.apache.axis2.addressing.EndpointReference axis2EPR, Element ... referenceParameters) throws Exception {
        if (referenceParameters != null) {
            for (Element element : referenceParameters) {
                OMElement omElement = XMLUtils.toOM((Element)element);
                axis2EPR.addReferenceParameter(omElement);
            }
        }
    }

    public static void addExtensibleElements(org.apache.axis2.addressing.EndpointReference axis2EPR, Element ... elements) throws Exception {
        if (elements != null) {
            for (Element element : elements) {
                OMElement omElement = XMLUtils.toOM((Element)element);
                axis2EPR.addExtensibleElement(omElement);
            }
        }
    }

    public static void addExtensibleAttributes(org.apache.axis2.addressing.EndpointReference axis2EPR, Map<QName, String> attributes) throws Exception {
        if (attributes != null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            for (Map.Entry<QName, String> attribute : attributes.entrySet()) {
                QName qName = attribute.getKey();
                OMNamespace omNamespace = fac.createOMNamespace(qName.getNamespaceURI(), qName.getPrefix());
                axis2EPR.addAttribute(qName.getLocalPart(), omNamespace, attribute.getValue());
            }
        }
    }

    public static void addMetadata(org.apache.axis2.addressing.EndpointReference axis2EPR, Element ... metadata) throws Exception {
        if (metadata != null) {
            for (Element element : metadata) {
                OMElement omElement = XMLUtils.toOM((Element)element);
                axis2EPR.addMetaData((OMNode)omElement);
            }
        }
    }

    public static void addInterface(org.apache.axis2.addressing.EndpointReference axis2EPR, QName portType, String addressingNamespace) throws Exception {
        if (portType != null) {
            InterfaceName interfaceName = new InterfaceName(portType);
            EndpointReferenceHelper.setInterfaceNameMetadata((OMFactory)omFactory, (org.apache.axis2.addressing.EndpointReference)axis2EPR, (String)addressingNamespace, (InterfaceName)interfaceName);
        }
    }

    public static void addService(org.apache.axis2.addressing.EndpointReference axis2EPR, QName service, QName port, String addressingNamespace) throws Exception {
        if (service != null && port != null) {
            ServiceName serviceName = new ServiceName(service, port.getLocalPart());
            EndpointReferenceHelper.setServiceNameMetadata((OMFactory)omFactory, (org.apache.axis2.addressing.EndpointReference)axis2EPR, (String)addressingNamespace, (ServiceName)serviceName);
        }
    }

    public static void addLocation(org.apache.axis2.addressing.EndpointReference axis2EPR, String targetNamespace, String wsdlDocumentLocation, String addressingNamespace) throws Exception {
        if (targetNamespace != null && wsdlDocumentLocation != null) {
            WSDLLocation wsdlLocation = new WSDLLocation(targetNamespace, wsdlDocumentLocation);
            EndpointReferenceHelper.setWSDLLocationMetadata((OMFactory)omFactory, (org.apache.axis2.addressing.EndpointReference)axis2EPR, (String)addressingNamespace, (WSDLLocation)wsdlLocation);
        }
    }
}

