/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.stax.push;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.serializer.Serializer;
import org.apache.axiom.core.stream.serializer.writer.UnmappableCharacterHandler;
import org.apache.axiom.core.stream.stax.push.InternalXMLStreamWriter;
import org.apache.axiom.core.stream.stax.push.XMLStreamWriterExtensionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class XmlHandlerStreamWriter
implements InternalXMLStreamWriter,
NamespaceContext {
    private static final Log log = LogFactory.getLog(XmlHandlerStreamWriter.class);
    private final XmlHandler handler;
    private final Serializer serializer;
    private final XMLStreamWriterExtensionFactory extensionFactory;
    private Map<String, Object> extensions;
    private boolean inStartElement;
    private boolean inEmptyElement;
    private String[] prefixArray = new String[16];
    private String[] uriArray = new String[16];
    private int bindings;
    private int[] scopeIndexes = new int[16];
    private int scopes;

    public XmlHandlerStreamWriter(XmlHandler handler, Serializer serializer, XMLStreamWriterExtensionFactory extensionFactory) {
        this.handler = handler;
        this.serializer = serializer;
        this.extensionFactory = extensionFactory;
    }

    public XmlHandler getHandler() {
        return this.handler;
    }

    private static String normalize(String s) {
        return s == null ? "" : s;
    }

    private static XMLStreamException toXMLStreamException(StreamException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof XMLStreamException) {
            return (XMLStreamException)cause;
        }
        return new XMLStreamException(ex);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        Object extension;
        if (this.extensions != null && (extension = this.extensions.get(name)) != null) {
            return extension;
        }
        if (this.extensionFactory != null && (extension = this.extensionFactory.createExtension(name, this)) != null) {
            if (this.extensions == null) {
                this.extensions = new HashMap<String, Object>();
            }
            this.extensions.put(name, extension);
            return extension;
        }
        throw new IllegalArgumentException("Unsupported property " + name);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("namespaceURI can't be null");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        block0: for (int i = this.bindings - 1; i >= 0; --i) {
            if (!uri.equals(this.uriArray[i])) continue;
            String prefix = this.prefixArray[i];
            for (int j = i + 1; j < this.bindings; ++j) {
                if (prefix.equals(this.prefixArray[j])) continue block0;
            }
            return prefix;
        }
        return null;
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.setPrefix("", uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (this.inEmptyElement) {
            log.warn((Object)"The behavior of XMLStreamWriter#setPrefix and XMLStreamWriter#setDefaultNamespace is undefined when invoked in the context of an empty element");
        }
        this.internalSetPrefix(XmlHandlerStreamWriter.normalize(prefix), XmlHandlerStreamWriter.normalize(uri));
    }

    private void internalSetPrefix(String prefix, String uri) {
        if (this.bindings == this.prefixArray.length) {
            int len = this.prefixArray.length;
            int newLen = len * 2;
            String[] newPrefixArray = new String[newLen];
            System.arraycopy(this.prefixArray, 0, newPrefixArray, 0, len);
            String[] newUriArray = new String[newLen];
            System.arraycopy(this.uriArray, 0, newUriArray, 0, len);
            this.prefixArray = newPrefixArray;
            this.uriArray = newUriArray;
        }
        this.prefixArray[this.bindings] = prefix;
        this.uriArray[this.bindings] = uri;
        ++this.bindings;
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        try {
            this.handler.startDocument(null, "1.0", null, null);
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        try {
            this.handler.startDocument(null, version, encoding, null);
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        try {
            this.handler.startDocument(null, version, null, null);
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        try {
            this.handler.completed();
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        if (this.serializer != null) {
            try {
                this.serializer.writeRaw(dtd, UnmappableCharacterHandler.CONVERT_TO_CHARACTER_REFERENCE);
            }
            catch (StreamException ex) {
                throw XmlHandlerStreamWriter.toXMLStreamException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void doWriteStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.finishStartElement();
        try {
            this.handler.startElement(XmlHandlerStreamWriter.normalize(namespaceURI), localName, XmlHandlerStreamWriter.normalize(prefix));
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
        this.inStartElement = true;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.doWriteStartElement(prefix, localName, namespaceURI);
        if (this.scopes == this.scopeIndexes.length) {
            int[] newScopeIndexes = new int[this.scopeIndexes.length * 2];
            System.arraycopy(this.scopeIndexes, 0, newScopeIndexes, 0, this.scopeIndexes.length);
            this.scopeIndexes = newScopeIndexes;
        }
        this.scopeIndexes[this.scopes++] = this.bindings;
        this.inEmptyElement = false;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    private void doWriteEndElement() throws XMLStreamException {
        this.finishStartElement();
        try {
            this.handler.endElement();
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndElement();
        this.bindings = this.scopeIndexes[--this.scopes];
        this.inEmptyElement = false;
    }

    private void finishStartElement() throws XMLStreamException {
        if (this.inStartElement) {
            try {
                this.handler.attributesCompleted();
            }
            catch (StreamException ex) {
                throw XmlHandlerStreamWriter.toXMLStreamException(ex);
            }
            this.inStartElement = false;
        }
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.doWriteStartElement(prefix, localName, namespaceURI);
        this.finishStartElement();
        this.doWriteEndElement();
        this.inEmptyElement = true;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            this.handler.processAttribute(XmlHandlerStreamWriter.normalize(namespaceURI), localName, XmlHandlerStreamWriter.normalize(prefix), value, "CDATA", true);
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        prefix = XmlHandlerStreamWriter.normalize(prefix);
        namespaceURI = XmlHandlerStreamWriter.normalize(namespaceURI);
        try {
            this.handler.processNamespaceDeclaration(prefix, namespaceURI);
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
        this.internalSetPrefix(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writeNamespace("", namespaceURI);
    }

    private String internalGetPrefix(String namespaceURI) throws XMLStreamException {
        String prefix = this.getPrefix(namespaceURI);
        if (prefix == null) {
            throw new XMLStreamException("Unbound namespace URI '" + namespaceURI + "'");
        }
        return prefix;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(this.internalGetPrefix(namespaceURI), localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(this.internalGetPrefix(namespaceURI), localName, namespaceURI);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(this.internalGetPrefix(namespaceURI), namespaceURI, localName, value);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacterData(new String(text, start, len));
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writeCharacterData(text);
    }

    @Override
    public void writeCharacterData(Object data) throws XMLStreamException {
        this.finishStartElement();
        try {
            this.handler.processCharacterData(data, false);
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
        this.inEmptyElement = false;
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.finishStartElement();
        try {
            this.handler.startCDATASection();
            this.handler.processCharacterData(data, false);
            this.handler.endCDATASection();
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
        this.inEmptyElement = false;
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.finishStartElement();
        try {
            this.handler.startComment();
            this.handler.processCharacterData(data, false);
            this.handler.endComment();
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
        this.inEmptyElement = false;
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.finishStartElement();
        try {
            this.handler.processEntityReference(name, null);
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
        this.inEmptyElement = false;
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.finishStartElement();
        try {
            this.handler.startProcessingInstruction(target);
            this.handler.processCharacterData(data, false);
            this.handler.endProcessingInstruction();
        }
        catch (StreamException ex) {
            throw XmlHandlerStreamWriter.toXMLStreamException(ex);
        }
        this.inEmptyElement = false;
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, "");
    }

    @Override
    public void flush() throws XMLStreamException {
        if (this.serializer != null) {
            try {
                this.serializer.flushBuffer();
            }
            catch (StreamException ex) {
                throw XmlHandlerStreamWriter.toXMLStreamException(ex);
            }
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.flush();
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix can't be null");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (int i = this.bindings - 1; i >= 0; --i) {
            if (!prefix.equals(this.prefixArray[i])) continue;
            return this.uriArray[i];
        }
        return "";
    }

    @Override
    public final Iterator<String> getPrefixes(final String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI can't be null");
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return Collections.singleton("xml").iterator();
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return Collections.singleton("xmlns").iterator();
        }
        return new Iterator<String>(){
            private int binding;
            private String next;
            {
                this.binding = XmlHandlerStreamWriter.this.bindings;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    block0: while (--this.binding >= 0) {
                        if (!namespaceURI.equals(XmlHandlerStreamWriter.this.uriArray[this.binding])) continue;
                        String prefix = XmlHandlerStreamWriter.this.prefixArray[this.binding];
                        for (int j = this.binding + 1; j < XmlHandlerStreamWriter.this.bindings; ++j) {
                            if (prefix.equals(XmlHandlerStreamWriter.this.prefixArray[j])) continue block0;
                        }
                        this.next = prefix;
                        break;
                    }
                }
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    String result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

