/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.moshi.rpc;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.Rfc3339DateJsonAdapter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonUtils {
    private static final Log log = LogFactory.getLog(JsonUtils.class);

    public static Object invokeServiceClass(JsonReader jsonReader, Object service, Method operation, Class[] paramClasses, int paramCount) throws InvocationTargetException, IllegalAccessException, IOException {
        Object[] methodParam = new Object[paramCount];
        try {
            JsonAdapter.Factory objectFactory = new JsonAdapter.Factory(){

                @Nullable
                public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
                    if (type != Object.class) {
                        return null;
                    }
                    final JsonAdapter delegate = moshi.nextAdapter((JsonAdapter.Factory)this, Object.class, annotations);
                    return new JsonAdapter<Object>(){

                        @Nullable
                        public Object fromJson(JsonReader reader) throws IOException {
                            if (reader.peek() != JsonReader.Token.NUMBER) {
                                return delegate.fromJson(reader);
                            }
                            String n = reader.nextString();
                            if (n.indexOf(46) != -1) {
                                return Double.parseDouble(n);
                            }
                            try {
                                Long longValue = Long.parseLong(n);
                                return longValue;
                            }
                            catch (Exception exception) {
                                return Double.parseDouble(n);
                            }
                        }

                        public void toJson(JsonWriter writer, @Nullable Object value) {
                            try {
                                delegate.toJson(writer, value);
                            }
                            catch (Exception ex) {
                                log.error((Object)ex.getMessage(), (Throwable)ex);
                            }
                        }
                    };
                }
            };
            Moshi moshiFrom = new Moshi.Builder().add(objectFactory).add(Date.class, (JsonAdapter)new Rfc3339DateJsonAdapter()).build();
            String[] argNames = new String[paramCount];
            jsonReader.beginObject();
            String messageName = jsonReader.nextName();
            if (messageName == null || !messageName.equals(operation.getName())) {
                log.error((Object)("JsonUtils.invokeServiceClass() throwing IOException, messageName: " + messageName + " is unknown, it does not match the axis2 operation, the method name: " + operation.getName()));
                throw new IOException("Bad Request");
            }
            jsonReader.beginArray();
            int i = 0;
            for (Class paramType : paramClasses) {
                JsonAdapter moshiFromJsonAdapter = null;
                moshiFromJsonAdapter = moshiFrom.adapter(paramType);
                jsonReader.beginObject();
                argNames[i] = jsonReader.nextName();
                methodParam[i] = moshiFromJsonAdapter.fromJson(jsonReader);
                log.trace((Object)("JsonUtils.invokeServiceClass() completed processing on messageName: " + messageName + " , arg name: " + argNames[i] + " , methodParam: " + methodParam[i].getClass().getName() + " , from argNames.length: " + argNames.length));
                jsonReader.endObject();
                ++i;
            }
            jsonReader.endArray();
            jsonReader.endObject();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IOException("Bad Request");
        }
        return operation.invoke(service, methodParam);
    }

    public static Method getOpMethod(String methodName, Method[] methodSet) {
        for (Method method : methodSet) {
            String mName = method.getName();
            if (!mName.equals(methodName)) continue;
            return method;
        }
        log.error((Object)("JsonUtils.getOpMethod() returning null, cannot find methodName: " + methodName + " , from methodSet.length: " + methodSet.length));
        return null;
    }
}

