/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.jibx.binding.Compile;
import org.jibx.runtime.JiBXException;

public class CompileTask
extends Task {
    private boolean m_load;
    private boolean m_verbose;
    private Path m_classpath;
    private List m_fileSet;
    private List m_bindingFileSet;
    private String m_bindingFile;

    public void init() throws BuildException {
        super.init();
        this.m_fileSet = new ArrayList();
        this.m_bindingFileSet = new ArrayList();
    }

    private String[] getPaths() {
        String[] pathArray = null;
        if (this.m_classpath != null) {
            pathArray = this.m_classpath.list();
        } else {
            pathArray = new String[this.m_fileSet.size()];
            for (int i = 0; i < this.m_fileSet.size(); ++i) {
                FileSet fileSet = (FileSet)this.m_fileSet.get(i);
                File directory = fileSet.getDir(this.project);
                pathArray[i] = directory.getAbsolutePath();
            }
        }
        try {
            System.setProperty("java.class.path", ((AntClassLoader)CompileTask.class.getClassLoader()).getClasspath());
        }
        catch (Exception e) {
            System.err.println("Failed setting classpath from Ant task");
        }
        if (this.m_verbose) {
            this.log("Using the following paths:");
            for (int i = 0; i < pathArray.length; ++i) {
                this.log("  " + pathArray[i]);
            }
        }
        return pathArray;
    }

    private String[] getBindings() {
        String[] bindings = null;
        if (this.m_bindingFileSet.size() == 0) {
            bindings = new String[]{this.m_bindingFile};
        } else {
            ArrayList<String> paths = new ArrayList<String>();
            for (int i = 0; i < this.m_bindingFileSet.size(); ++i) {
                FileSet bPath = (FileSet)this.m_bindingFileSet.get(i);
                DirectoryScanner dirScn = bPath.getDirectoryScanner(this.project);
                String[] bndingFiles = dirScn.getIncludedFiles();
                for (int x = 0; x < bndingFiles.length; ++x) {
                    String fullPath = dirScn.getBasedir() + System.getProperty("file.separator") + bndingFiles[x];
                    paths.add(fullPath);
                }
            }
            bindings = paths.toArray(new String[paths.size()]);
        }
        if (this.m_verbose) {
            this.log("Using the following binding paths:");
            for (int i = 0; i < bindings.length; ++i) {
                this.log("  " + bindings[i]);
            }
        }
        return bindings;
    }

    private void validateRequiredFields() throws BuildException {
        if (this.m_bindingFileSet.isEmpty() && this.m_bindingFile == null) {
            throw new BuildException("Either the binding attribute or at least one bindingset nested element must be defined.");
        }
        if (!this.m_bindingFileSet.isEmpty() && this.m_bindingFile != null) {
            throw new BuildException("You cannot specify both a binding attribute and a bindingset nested element.");
        }
        if (this.m_classpath == null && this.m_fileSet.isEmpty()) {
            throw new BuildException("You must specify either a classpath or at least one nested classpathset element.");
        }
        if (this.m_classpath != null && !this.m_fileSet.isEmpty()) {
            throw new BuildException("You cannot specify both a classpath and a classpathset nested element.");
        }
    }

    public void execute() throws BuildException {
        try {
            this.validateRequiredFields();
            String[] pathArr = this.getPaths();
            String[] bindings = this.getBindings();
            Compile compiler = new Compile();
            compiler.setLoad(this.m_load);
            compiler.setVerbose(this.m_verbose);
            compiler.compile(pathArr, bindings);
        }
        catch (JiBXException jEx) {
            jEx.printStackTrace();
            throw new BuildException("JiBXException in JiBX binding compilation", (Throwable)jEx);
        }
    }

    public void addClassPathSet(FileSet fSet) {
        this.m_fileSet.add(fSet);
    }

    public Path getClasspath() {
        return this.m_classpath;
    }

    public void setClasspath(Path classpath) {
        if (this.m_classpath == null) {
            this.m_classpath = classpath;
        } else {
            this.m_classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.project);
        }
        return this.m_classpath;
    }

    public void setBinding(String file) {
        this.m_bindingFile = file;
    }

    public void addBindingFileSet(FileSet bfSet) {
        this.m_bindingFileSet.add(bfSet);
    }

    public void setLoad(boolean bool) {
        this.m_load = bool;
    }

    public void setVerbose(boolean bool) {
        this.m_verbose = bool;
    }
}

