/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import org.apache.axis2.tool.service.bean.WizardBean;
import org.apache.axis2.tool.service.control.Controller;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.apache.axis2.tool.service.eclipse.ui.ClassFileLocationPage;
import org.apache.axis2.tool.service.eclipse.ui.LibraryAddingPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceArchiveOutputLocationPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceXMLFileSelectionPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceXMLGenerationPage;
import org.apache.axis2.tool.service.eclipse.ui.WSDLFileSelectionPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ServiceArchiveWizard
extends Wizard
implements INewWizard {
    private ClassFileLocationPage classFileLocationPage;
    private WSDLFileSelectionPage wsdlFileSelectionPage;
    private ServiceXMLFileSelectionPage serviceXMLFileSelectionPage;
    private ServiceXMLGenerationPage serviceXMLGenerationPage;
    private ServiceArchiveOutputLocationPage serviceArchiveOutputLocationPage;
    private LibraryAddingPage libPage;
    private String classFileLocation;
    private String wsdlFileGenerationStatus;

    public String getWsdlFileGenerationStatus() {
        return this.wsdlFileGenerationStatus;
    }

    public void updateWsdlFileGenerationStatus(String message) {
        this.wsdlFileGenerationStatus = message;
    }

    public String getClassFileLocation() {
        return this.classFileLocation;
    }

    public String[] getLibFileList() {
        return this.libPage.getBean().getFileList();
    }

    public void setClassFileLocation(String location) {
        this.classFileLocation = location;
    }

    public void updateServiceXMLGeneration(boolean status) {
        this.serviceXMLGenerationPage.setPageComplete(status);
    }

    public ServiceArchiveWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(ServiceArchiver.getResourceString("main.title"));
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        AbstractServiceWizardPage wizardPage = null;
        for (int i = 0; i < pages.length; ++i) {
            wizardPage = (AbstractServiceWizardPage)pages[i];
            if (!wizardPage.getName().equals("page4.name") || wizardPage.getWizardComplete()) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractServiceWizardPage thisPage = (AbstractServiceWizardPage)page;
        AbstractServiceWizardPage nextPage = (AbstractServiceWizardPage)super.getNextPage(page);
        while (thisPage != null && thisPage.isSkipNext() && nextPage != null) {
            thisPage = nextPage;
            nextPage = (AbstractServiceWizardPage)super.getNextPage((IWizardPage)nextPage);
        }
        return nextPage;
    }

    public void addPages() {
        this.classFileLocationPage = new ClassFileLocationPage();
        this.addPage((IWizardPage)this.classFileLocationPage);
        this.wsdlFileSelectionPage = new WSDLFileSelectionPage();
        this.addPage((IWizardPage)this.wsdlFileSelectionPage);
        this.libPage = new LibraryAddingPage();
        this.addPage((IWizardPage)this.libPage);
        this.serviceXMLFileSelectionPage = new ServiceXMLFileSelectionPage();
        this.addPage((IWizardPage)this.serviceXMLFileSelectionPage);
        this.serviceXMLGenerationPage = new ServiceXMLGenerationPage();
        this.addPage((IWizardPage)this.serviceXMLGenerationPage);
        this.serviceArchiveOutputLocationPage = new ServiceArchiveOutputLocationPage();
        this.addPage((IWizardPage)this.serviceArchiveOutputLocationPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(ServiceArchiver.getResourceString("wizard.codegen.startmsg"), 8);
                try {
                    monitor.worked(1);
                    WizardBean wizBean = new WizardBean();
                    monitor.worked(1);
                    wizBean.setPage1bean(ServiceArchiveWizard.this.classFileLocationPage.getBean());
                    monitor.worked(1);
                    wizBean.setWsdlBean(ServiceArchiveWizard.this.wsdlFileSelectionPage.getBean());
                    monitor.worked(1);
                    wizBean.setPage2bean(ServiceArchiveWizard.this.serviceXMLGenerationPage.getBean(ServiceArchiveWizard.this.serviceXMLFileSelectionPage.getBean()));
                    monitor.worked(1);
                    wizBean.setLibraryBean(ServiceArchiveWizard.this.libPage.getBean());
                    monitor.worked(1);
                    wizBean.setPage3bean(ServiceArchiveWizard.this.serviceArchiveOutputLocationPage.getBean());
                    monitor.worked(1);
                    new Controller().process(wizBean);
                    monitor.worked(1);
                }
                catch (Throwable e) {
                    throw new InterruptedException(e.getMessage());
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
            this.showSuccessMessage(ServiceArchiver.getResourceString("wizard.codegen.success"));
            return true;
        }
        catch (InvocationTargetException e1) {
            this.showErrorMessage(e1.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException e1) {
            this.showErrorMessage(e1.getMessage());
            return false;
        }
        catch (Exception e) {
            this.showErrorMessage(ServiceArchiver.getResourceString("wizard.codegen.unknown.error") + "  " + e.getMessage());
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private void showErrorMessage(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)ServiceArchiver.getResourceString("wizard.codegen.error.msg.heading"), (String)message);
    }

    private void showSuccessMessage(String message) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)ServiceArchiver.getResourceString("wizard.codegen.success.msg.heading"), (String)message);
    }
}

