/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextStyle;
import org.apache.commons.lang3.StringUtils;

public class WeirdOptionFormat
implements Function<Iterable<Option>, TableDefinition> {
    private final String[] headers = new String[]{"Opt", "Since", "Required", "LongOpt", "Deprecated", "Arg Name", "Type", "Description"};
    private final List<TextStyle> styles = new ArrayList<TextStyle>();

    public WeirdOptionFormat() {
        TextStyle.Builder builder = TextStyle.builder();
        this.styles.add(builder.setLeftPad(1).setIndent(3).get());
        this.styles.add(builder.setLeftPad(5).get());
        this.styles.add(builder.get());
        this.styles.add(builder.get());
        this.styles.add(builder.get());
        this.styles.add(builder.get());
        this.styles.add(builder.get());
        this.styles.add(builder.get());
    }

    @Override
    public TableDefinition apply(Iterable<Option> options) {
        ArrayList rows = new ArrayList();
        for (Option option : options) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(option.getOpt());
            row.add((String)StringUtils.defaultIfEmpty((CharSequence)option.getSince(), (CharSequence)"--"));
            row.add(option.isRequired() ? "T" : "F");
            row.add(option.getLongOpt());
            row.add(option.isDeprecated() ? "T" : "F");
            row.add(option.hasArg() ? option.getArgName() : "--");
            row.add(option.getType() == null ? "--" : option.getValue().toString());
            row.add(option.getDescription());
            rows.add(row);
        }
        return TableDefinition.from((String)"", this.styles, Arrays.asList(this.headers), rows);
    }
}

