/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore.status;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.deployment.version.VersionParseException;
import org.apache.ignite3.internal.deployunit.DeploymentStatus;
import org.jetbrains.annotations.Nullable;

public final class SerializeUtils {
    private static final String SEPARATOR = ";";
    private static final String LIST_SEPARATOR = ":";

    private SerializeUtils() {
    }

    static byte[] serialize(Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            if (arg == null) {
                sb.append(SEPARATOR);
                continue;
            }
            if (arg instanceof Collection) {
                SerializeUtils.appendWithEncoding(sb, (Collection)arg);
                continue;
            }
            SerializeUtils.appendWithEncoding(sb, arg.toString());
        }
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    static String[] deserialize(byte[] bytes) {
        String s = new String(bytes, StandardCharsets.UTF_8);
        return s.split(SEPARATOR, -1);
    }

    static Set<String> decodeAsSet(String s) {
        if (s == null || s.isBlank()) {
            return Collections.emptySet();
        }
        String[] split = s.split(LIST_SEPARATOR, -1);
        return Arrays.stream(split).map(SerializeUtils::decode).collect(Collectors.toSet());
    }

    private static void appendWithEncoding(StringBuilder sb, String content) {
        sb.append(SerializeUtils.encode(content)).append(SEPARATOR);
    }

    private static void appendWithEncoding(StringBuilder sb, Collection<String> content) {
        String list = content.stream().map(SerializeUtils::encode).collect(Collectors.joining(LIST_SEPARATOR));
        sb.append(list).append(SEPARATOR);
    }

    private static String encode(String s) {
        return new String(Base64.getEncoder().encode(s.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    static String decode(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }

    static boolean checkElement(String[] arr, int index) {
        return arr.length > index && arr[index] != null && !arr[index].isBlank();
    }

    @Nullable
    static Version deserializeVersion(String[] values, int index) {
        try {
            return SerializeUtils.checkElement(values, index) ? Version.parseVersion(SerializeUtils.decode(values[index])) : null;
        }
        catch (VersionParseException e) {
            return null;
        }
    }

    @Nullable
    static DeploymentStatus deserializeStatus(String[] values, int index) {
        try {
            return SerializeUtils.checkElement(values, index) ? DeploymentStatus.valueOf(SerializeUtils.decode(values[index])) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    static UUID deserializeUuid(String[] values, int index) {
        try {
            return SerializeUtils.checkElement(values, index) ? UUID.fromString(SerializeUtils.decode(values[index])) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

