/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization;

import org.apache.ignite3.internal.network.serialization.ClassDescriptor;
import org.apache.ignite3.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite3.internal.network.serialization.ClassIndexedDescriptors;
import org.apache.ignite3.internal.network.serialization.DescriptorRegistry;
import org.apache.ignite3.internal.network.serialization.IdIndexedDescriptors;
import org.jetbrains.annotations.Nullable;

public class CompositeDescriptorRegistry
implements DescriptorRegistry {
    private final IdIndexedDescriptors idIndexedDescriptors;
    private final ClassIndexedDescriptors classIndexedDescriptors;
    private final ClassDescriptorRegistry ctx;

    public CompositeDescriptorRegistry(IdIndexedDescriptors idIndexedDescriptors, ClassIndexedDescriptors classIndexedDescriptors, ClassDescriptorRegistry ctx) {
        this.idIndexedDescriptors = idIndexedDescriptors;
        this.classIndexedDescriptors = classIndexedDescriptors;
        this.ctx = ctx;
    }

    @Override
    @Nullable
    public ClassDescriptor getDescriptor(int descriptorId) {
        if (ClassDescriptorRegistry.shouldBeBuiltIn(descriptorId)) {
            return this.ctx.getDescriptor(descriptorId);
        }
        return this.idIndexedDescriptors.getDescriptor(descriptorId);
    }

    @Override
    @Nullable
    public ClassDescriptor getDescriptor(Class<?> clazz) {
        if (this.classIndexedDescriptors.hasDescriptor(clazz)) {
            return this.classIndexedDescriptors.getDescriptor(clazz);
        }
        return this.ctx.getDescriptor(clazz);
    }
}

