/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.fun;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlAbstractTimeFunction;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlMonotonicBinaryOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import org.apache.ignite3.internal.sql.engine.sql.fun.SameFamilyOperandTypeChecker;
import org.apache.ignite3.internal.sql.engine.sql.fun.SqlDateTimeIntervalTypeChecker;
import org.apache.ignite3.internal.sql.engine.sql.fun.SqlSystemRangeFunction;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlOperatorTable
extends ReflectiveSqlOperatorTable {
    private static final SqlSingleOperandTypeChecker SAME_SAME = new SameFamilyOperandTypeChecker(2);
    private static final SqlOperandTypeChecker DATETIME_MATCHING_INTERVAL = new SqlDateTimeIntervalTypeChecker(true);
    private static final SqlOperandTypeChecker MATCHING_INTERVAL_DATETIME = new SqlDateTimeIntervalTypeChecker(false);
    private static final SqlOperandTypeChecker PLUS_OPERATOR_TYPES_CHECKER = OperandTypes.NUMERIC_NUMERIC.and(SAME_SAME).or(OperandTypes.INTERVAL_SAME_SAME).or(DATETIME_MATCHING_INTERVAL).or(MATCHING_INTERVAL_DATETIME);
    private static final SqlOperandTypeChecker MINUS_OPERATOR_TYPES_CHECKER = OperandTypes.NUMERIC_NUMERIC.and(SAME_SAME).or(OperandTypes.INTERVAL_SAME_SAME).or(OperandTypes.DATETIME_INTERVAL.and(DATETIME_MATCHING_INTERVAL));
    private static final SqlSingleOperandTypeChecker DIVISION_OPERATOR_TYPES_CHECKER = OperandTypes.NUMERIC_NUMERIC.and(SAME_SAME).or(OperandTypes.INTERVAL_NUMERIC);
    public static final SqlSingleOperandTypeChecker MULTIPLY_OPERATOR_TYPES_CHECKER = OperandTypes.NUMERIC_NUMERIC.and(SAME_SAME).or(OperandTypes.INTERVAL_NUMERIC).or(OperandTypes.NUMERIC_INTERVAL);
    public static final SqlFunction LENGTH = new SqlFunction("LENGTH", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.CHARACTER.or(OperandTypes.BINARY), SqlFunctionCategory.NUMERIC);
    public static final SqlFunction SYSTEM_RANGE = new SqlSystemRangeFunction();
    public static final SqlFunction TYPEOF = new SqlFunction("TYPEOF", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, null, (SqlOperandTypeChecker)OperandTypes.ANY, SqlFunctionCategory.SYSTEM);
    public static final SqlFunction LEAST2 = new SqlFunction("$LEAST2", SqlKind.OTHER_FUNCTION, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), null, (SqlOperandTypeChecker)SAME_SAME, SqlFunctionCategory.SYSTEM);
    public static final SqlFunction GREATEST2 = new SqlFunction("$GREATEST2", SqlKind.OTHER_FUNCTION, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), null, (SqlOperandTypeChecker)SAME_SAME, SqlFunctionCategory.SYSTEM);
    public static final SqlFunction SUBSTR = new SqlFunction("SUBSTR", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, (SqlOperandTypeChecker)OperandTypes.STRING_INTEGER.or(OperandTypes.STRING_INTEGER_INTEGER), SqlFunctionCategory.STRING);
    public static final SqlFunction RAND_UUID = new SqlFunction("RAND_UUID", SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.UUID), null, (SqlOperandTypeChecker)OperandTypes.NILADIC, SqlFunctionCategory.SYSTEM){

        public boolean isDynamicFunction() {
            return true;
        }

        public boolean isDeterministic() {
            return false;
        }
    };
    public static final SqlFunction ROUND = SqlBasicFunction.create((String)"ROUND", (SqlReturnTypeInference)new SetScaleToZeroIfSingleArgument(), (SqlOperandTypeChecker)OperandTypes.NUMERIC.or(OperandTypes.NUMERIC_INTEGER), (SqlFunctionCategory)SqlFunctionCategory.NUMERIC);
    public static final SqlFunction TRUNCATE = SqlBasicFunction.create((String)"TRUNCATE", (SqlReturnTypeInference)new SetScaleToZeroIfSingleArgument(), (SqlOperandTypeChecker)OperandTypes.NUMERIC.or(OperandTypes.NUMERIC_INTEGER), (SqlFunctionCategory)SqlFunctionCategory.NUMERIC);
    public static final SqlFunction OCTET_LENGTH = SqlBasicFunction.create((String)"OCTET_LENGTH", (SqlReturnTypeInference)ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.CHARACTER.or(OperandTypes.BINARY), (SqlFunctionCategory)SqlFunctionCategory.NUMERIC);
    public static final SqlFunction DECIMAL_DIVIDE = SqlBasicFunction.create((String)"DECIMAL_DIVIDE", (SqlReturnTypeInference)new SqlReturnTypeInference(){

        public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType arg0 = opBinding.getOperandType(0);
            Integer precision = (Integer)opBinding.getOperandLiteralValue(2, Integer.class);
            Integer scale = (Integer)opBinding.getOperandLiteralValue(3, Integer.class);
            assert (precision != null) : "precision is not specified: " + opBinding.getOperator();
            assert (scale != null) : "scale is not specified: " + opBinding.getOperator();
            boolean nullable = arg0.isNullable();
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType returnType = typeFactory.createSqlType(SqlTypeName.DECIMAL, precision.intValue(), scale.intValue());
            return typeFactory.createTypeWithNullability(returnType, nullable);
        }
    }, (SqlOperandTypeChecker)OperandTypes.DIVISION_OPERATOR, (SqlFunctionCategory)SqlFunctionCategory.NUMERIC);
    public static final SqlBinaryOperator LESS_THAN = new SqlBinaryOperator("<", SqlKind.LESS_THAN, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator LESS_THAN_OR_EQUAL = new SqlBinaryOperator("<=", SqlKind.LESS_THAN_OR_EQUAL, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator EQUALS = new SqlBinaryOperator("=", SqlKind.EQUALS, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator GREATER_THAN = new SqlBinaryOperator(">", SqlKind.GREATER_THAN, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator IS_DISTINCT_FROM = new SqlBinaryOperator("IS DISTINCT FROM", SqlKind.IS_DISTINCT_FROM, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator IS_NOT_DISTINCT_FROM = new SqlBinaryOperator("IS NOT DISTINCT FROM", SqlKind.IS_NOT_DISTINCT_FROM, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator GREATER_THAN_OR_EQUAL = new SqlBinaryOperator(">=", SqlKind.GREATER_THAN_OR_EQUAL, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator NOT_EQUALS = new SqlBinaryOperator("<>", SqlKind.NOT_EQUALS, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)SAME_SAME);
    public static final SqlBinaryOperator PLUS = new SqlMonotonicBinaryOperator("+", SqlKind.PLUS, 40, true, new SqlReturnTypeInference(){

        public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type1 = opBinding.getOperandType(0);
            RelDataType type2 = opBinding.getOperandType(1);
            boolean nullable = type1.isNullable() || type2.isNullable();
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            if (TypeUtils.typeFamiliesAreCompatible(typeFactory, type1, type2)) {
                RelDataType resultType = typeFactory.getTypeSystem().deriveDecimalPlusType(typeFactory, type1, type2);
                if (resultType == null) {
                    resultType = typeFactory.leastRestrictive(List.of(type1, type2));
                }
                if (resultType != null) {
                    return typeFactory.createTypeWithNullability(resultType, nullable);
                }
            } else {
                if (SqlTypeUtil.isDatetime((RelDataType)type1) && SqlTypeUtil.isInterval((RelDataType)type2)) {
                    return IgniteSqlOperatorTable.deriveDatetimePlusMinusIntervalType(typeFactory, type1, type2, nullable);
                }
                if (SqlTypeUtil.isDatetime((RelDataType)type2) && SqlTypeUtil.isInterval((RelDataType)type1)) {
                    return IgniteSqlOperatorTable.deriveDatetimePlusMinusIntervalType(typeFactory, type2, type1, nullable);
                }
            }
            return null;
        }
    }, InferTypes.FIRST_KNOWN, PLUS_OPERATOR_TYPES_CHECKER);
    public static final SqlBinaryOperator MINUS = new SqlMonotonicBinaryOperator("-", SqlKind.MINUS, 40, true, new SqlReturnTypeInference(){

        public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type1 = opBinding.getOperandType(0);
            RelDataType type2 = opBinding.getOperandType(1);
            boolean nullable = type1.isNullable() || type2.isNullable();
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            if (TypeUtils.typeFamiliesAreCompatible(typeFactory, type1, type2)) {
                RelDataType resultType = typeFactory.getTypeSystem().deriveDecimalPlusType(typeFactory, type1, type2);
                if (resultType == null) {
                    resultType = typeFactory.leastRestrictive(List.of(type1, type2));
                }
                if (resultType != null) {
                    return typeFactory.createTypeWithNullability(resultType, nullable);
                }
            } else if (SqlTypeUtil.isDatetime((RelDataType)type1) && SqlTypeUtil.isInterval((RelDataType)type2)) {
                return IgniteSqlOperatorTable.deriveDatetimePlusMinusIntervalType(typeFactory, type1, type2, nullable);
            }
            return null;
        }
    }, InferTypes.FIRST_KNOWN, MINUS_OPERATOR_TYPES_CHECKER);
    public static final SqlBinaryOperator DIVIDE = new SqlBinaryOperator("/", SqlKind.DIVIDE, 60, true, ReturnTypes.QUOTIENT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)DIVISION_OPERATOR_TYPES_CHECKER);
    public static final SqlBinaryOperator MULTIPLY = new SqlMonotonicBinaryOperator("*", SqlKind.TIMES, 60, true, ReturnTypes.PRODUCT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)MULTIPLY_OPERATOR_TYPES_CHECKER);
    public static final SqlBinaryOperator PERCENT_REMAINDER = new SqlBinaryOperator("%", SqlKind.MOD, 60, true, ReturnTypes.NULLABLE_MOD, null, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC.and(SAME_SAME));
    public static final SqlAggFunction EVERY = new SqlMinMaxAggFunction("EVERY", SqlKind.MIN, (SqlOperandTypeChecker)OperandTypes.BOOLEAN);
    public static final SqlAggFunction SOME = new SqlMinMaxAggFunction("SOME", SqlKind.MAX, (SqlOperandTypeChecker)OperandTypes.BOOLEAN);
    public static final SqlFunction CURRENT_TIMESTAMP = new SqlAbstractTimeFunction("CURRENT_TIMESTAMP", SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE){};
    public static final IgniteSqlOperatorTable INSTANCE = new IgniteSqlOperatorTable();
    public static final List<SqlFunction> CUSTOM_TYPE_FUNCTIONS = List.of(SqlStdOperatorTable.CAST, SqlStdOperatorTable.COALESCE, SqlStdOperatorTable.NULLIF, TYPEOF, SqlStdOperatorTable.COUNT, SqlStdOperatorTable.MIN, SqlStdOperatorTable.MAX, SqlStdOperatorTable.ANY_VALUE, SOME, SqlStdOperatorTable.SINGLE_VALUE, EVERY);

    private static RelDataType deriveDatetimePlusMinusIntervalType(RelDataTypeFactory typeFactory, RelDataType datetimeType, RelDataType intervalType, boolean nullable) {
        assert (SqlTypeUtil.isDatetime((RelDataType)datetimeType)) : "not datetime: " + datetimeType;
        assert (SqlTypeUtil.isInterval((RelDataType)intervalType)) : "not interval: " + intervalType;
        if (datetimeType.getSqlTypeName().allowsPrecScale(true, false) && intervalType.getScale() > datetimeType.getPrecision()) {
            datetimeType = typeFactory.createSqlType(datetimeType.getSqlTypeName(), intervalType.getScale());
        }
        return typeFactory.createTypeWithNullability(datetimeType, nullable);
    }

    public IgniteSqlOperatorTable() {
        this.init0();
    }

    private void init0() {
        ImmutableList.Builder definedOperatorsBuilder = ImmutableList.builder();
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.UNION);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.UNION_ALL);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.EXCEPT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.EXCEPT_ALL);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.INTERSECT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.INTERSECT_ALL);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.AND);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.OR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NOT);
        definedOperatorsBuilder.add((Object)LESS_THAN);
        definedOperatorsBuilder.add((Object)LESS_THAN_OR_EQUAL);
        definedOperatorsBuilder.add((Object)GREATER_THAN);
        definedOperatorsBuilder.add((Object)GREATER_THAN_OR_EQUAL);
        definedOperatorsBuilder.add((Object)EQUALS);
        definedOperatorsBuilder.add((Object)NOT_EQUALS);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.BETWEEN);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NOT_BETWEEN);
        definedOperatorsBuilder.add((Object)PLUS);
        definedOperatorsBuilder.add((Object)MINUS);
        definedOperatorsBuilder.add((Object)MULTIPLY);
        definedOperatorsBuilder.add((Object)DIVIDE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DIVIDE_INTEGER);
        definedOperatorsBuilder.add((Object)PERCENT_REMAINDER);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.UNARY_MINUS);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.UNARY_PLUS);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.COUNT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SUM);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SUM0);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.AVG);
        definedOperatorsBuilder.add((Object)DECIMAL_DIVIDE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.MIN);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.MAX);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ANY_VALUE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SINGLE_VALUE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.FILTER);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.GROUPING);
        definedOperatorsBuilder.add((Object)EVERY);
        definedOperatorsBuilder.add((Object)SOME);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NULL);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_NULL);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_TRUE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_TRUE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_FALSE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_FALSE);
        definedOperatorsBuilder.add((Object)IS_DISTINCT_FROM);
        definedOperatorsBuilder.add((Object)IS_NOT_DISTINCT_FROM);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.LIKE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NOT_LIKE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SIMILAR_TO);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NOT_SIMILAR_TO);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NULLS_FIRST);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NULLS_LAST);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DESC);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.EXISTS);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.UPPER);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.LOWER);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.INITCAP);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.TO_BASE64);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.FROM_BASE64);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.MD5);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.SHA1);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SUBSTRING);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.LEFT);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.RIGHT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.REPLACE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.TRANSLATE3);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.CHR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CHAR_LENGTH);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CHARACTER_LENGTH);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CONCAT);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.CONCAT_FUNCTION);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.OVERLAY);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.POSITION);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ASCII);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.REPEAT);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.SPACE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.STRCMP);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.SOUNDEX);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.DIFFERENCE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.REVERSE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.TRIM);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.LTRIM);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.RTRIM);
        definedOperatorsBuilder.add((Object)SUBSTR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.MOD);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.EXP);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.POWER);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.LN);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.LOG10);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ABS);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.RAND);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.RAND_INTEGER);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ACOS);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ASIN);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ATAN);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ATAN2);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SQRT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CBRT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.COS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.COSH);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.COT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DEGREES);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.RADIANS);
        definedOperatorsBuilder.add((Object)ROUND);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SIGN);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SIN);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.SINH);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.TAN);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.TANH);
        definedOperatorsBuilder.add((Object)TRUNCATE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.PI);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DATETIME_PLUS);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.MINUS_DATE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.EXTRACT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.FLOOR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CEIL);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.TIMESTAMP_ADD);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.TIMESTAMP_DIFF);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.LAST_DAY);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.DAYNAME);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.MONTHNAME);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DAYOFMONTH);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DAYOFWEEK);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DAYOFYEAR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.YEAR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.QUARTER);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.MONTH);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.WEEK);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.HOUR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.MINUTE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.SECOND);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.TIMESTAMP_SECONDS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.TIMESTAMP_MILLIS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.TIMESTAMP_MICROS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.UNIX_SECONDS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.UNIX_MILLIS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.UNIX_MICROS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.UNIX_DATE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.DATE_FROM_UNIX_DATE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.DATE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.POSIX_REGEX_CASE_INSENSITIVE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.REGEXP_REPLACE_2);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.REGEXP_REPLACE_3);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.REGEXP_REPLACE_4);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.REGEXP_REPLACE_5);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.REGEXP_REPLACE_6);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ITEM);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CARDINALITY);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_EMPTY);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_EMPTY);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.ROW);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CAST);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.INFIX_CAST);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.COALESCE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.NVL);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.NULLIF);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CASE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.DECODE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.LEAST);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.GREATEST);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.COMPRESS);
        definedOperatorsBuilder.add((Object)OCTET_LENGTH);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.DEFAULT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.REINTERPRET);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.EXTRACT_VALUE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.XML_TRANSFORM);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.EXTRACT_XML);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.EXISTS_NODE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.JSON_TYPE_OPERATOR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.JSON_VALUE_EXPRESSION);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.JSON_VALUE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.JSON_QUERY);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.JSON_TYPE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.JSON_EXISTS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.JSON_DEPTH);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.JSON_KEYS);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.JSON_PRETTY);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.JSON_LENGTH);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.JSON_REMOVE);
        definedOperatorsBuilder.add((Object)SqlLibraryOperators.JSON_STORAGE_SIZE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.JSON_OBJECT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.JSON_ARRAY);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_JSON_VALUE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_JSON_OBJECT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_JSON_ARRAY);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_JSON_SCALAR);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_JSON_VALUE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_JSON_OBJECT);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_JSON_ARRAY);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.IS_NOT_JSON_SCALAR);
        definedOperatorsBuilder.add((Object)SqlInternalOperators.LITERAL_AGG);
        definedOperatorsBuilder.add((Object)CURRENT_TIMESTAMP);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CURRENT_DATE);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.LOCALTIME);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.LOCALTIMESTAMP);
        definedOperatorsBuilder.add((Object)SqlStdOperatorTable.CURRENT_USER);
        definedOperatorsBuilder.add((Object)LENGTH);
        definedOperatorsBuilder.add((Object)SYSTEM_RANGE);
        definedOperatorsBuilder.add((Object)TYPEOF);
        definedOperatorsBuilder.add((Object)LEAST2);
        definedOperatorsBuilder.add((Object)GREATEST2);
        definedOperatorsBuilder.add((Object)RAND_UUID);
        this.setOperators((Multimap)IgniteSqlOperatorTable.buildIndex((Iterable)definedOperatorsBuilder.build()));
    }

    private static class SetScaleToZeroIfSingleArgument
    implements SqlReturnTypeInference {
        private SetScaleToZeroIfSingleArgument() {
        }

        public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType operandType = opBinding.getOperandType(0);
            if (opBinding.getOperandCount() == 1 && operandType.getSqlTypeName().allowsPrecScale(true, true)) {
                int precision = operandType.getPrecision();
                IgniteTypeFactory typeFactory = Commons.typeFactory();
                RelDataType returnType = typeFactory.createSqlType(operandType.getSqlTypeName(), precision, 0);
                boolean nullable = operandType.isNullable();
                return typeFactory.createTypeWithNullability(returnType, nullable);
            }
            return operandType;
        }
    }
}

