/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryIdentityResolver;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySerializedFieldComparator;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshallerInaccessibleClassException;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public abstract class BinaryObjectExImpl
implements BinaryObjectEx {
    public abstract int length();

    public abstract int start();

    public abstract boolean hasArray();

    public abstract byte[] array();

    public abstract long offheapAddress();

    @Nullable
    public abstract <F> F field(int var1) throws BinaryObjectException;

    @Override
    public int enumOrdinal() throws BinaryObjectException {
        throw new BinaryObjectException("Object is not enum.");
    }

    @Override
    public String enumName() throws BinaryObjectException {
        throw new BinaryObjectException("Object is not enum.");
    }

    public abstract int dataStartOffset();

    public abstract int footerStartOffset();

    @Nullable
    public abstract <F> F fieldByOrder(int var1);

    public abstract BinarySerializedFieldComparator createFieldComparator();

    protected abstract boolean writeFieldByOrder(int var1, ByteBuffer var2);

    @Nullable
    protected abstract <F> F field(BinaryReaderHandles var1, String var2);

    public abstract boolean hasSchema();

    public abstract int schemaId();

    public abstract BinarySchema createSchema();

    public abstract BinaryContext context();

    @Override
    public BinaryObjectBuilder toBuilder() throws BinaryObjectException {
        return BinaryObjectBuilderImpl.wrap(this);
    }

    @Override
    public BinaryObject clone() throws CloneNotSupportedException {
        return (BinaryObject)super.clone();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryObject)) {
            return false;
        }
        BinaryIdentityResolver identity = this.context().identity(this.typeId());
        return identity.equals(this, (BinaryObject)other);
    }

    public String toString() {
        try {
            BinaryReaderHandles ctx = new BinaryReaderHandles();
            ctx.put(this.start(), this);
            return this.toString(ctx, new IdentityHashMap<BinaryObject, Integer>());
        }
        catch (BinaryObjectException e) {
            throw new IgniteException("Failed to create string representation of binary object.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(BinaryReaderHandles ctx, IdentityHashMap<BinaryObject, Integer> handles) {
        BinaryType meta;
        int idHash = System.identityHashCode(this);
        int hash = this.hashCode();
        IgniteThread.onForbidBinaryMetadataRequestSectionEntered();
        try {
            meta = this.rawType();
        }
        catch (BinaryObjectException ignore) {
            meta = null;
        }
        finally {
            IgniteThread.onForbidBinaryMetadataRequestSectionLeft();
        }
        if (meta == null || !S.includeSensitive()) {
            return S.toString(S.includeSensitive() ? BinaryObject.class.getSimpleName() : "BinaryObject", "idHash", (Object)idHash, false, "hash", (Object)hash, false, "typeId", (Object)this.typeId(), true);
        }
        handles.put(this, idHash);
        SB buf = new SB(meta.typeName());
        if (meta.fieldNames() != null) {
            buf.a(" [idHash=").a(idHash).a(", hash=").a(hash);
            for (String name : meta.fieldNames()) {
                Object val = this.fieldForToString(ctx, name);
                buf.a(", ").a(name).a('=');
                this.appendValue(val, buf, ctx, handles);
            }
            buf.a(']');
        }
        return buf.toString();
    }

    private Object fieldForToString(BinaryReaderHandles ctx, String name) {
        try {
            return this.field(ctx, name);
        }
        catch (Exception e) {
            OptimizedMarshallerInaccessibleClassException e1 = X.cause(e, OptimizedMarshallerInaccessibleClassException.class);
            String msg = "Failed to create a string representation";
            return e1 != null ? "(" + msg + ": class not found " + e1.inaccessibleClass() + ")" : "(" + msg + ")";
        }
    }

    private void appendValue(Object val, SB buf, BinaryReaderHandles ctx, IdentityHashMap<BinaryObject, Integer> handles) {
        if (val instanceof byte[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof short[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof int[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof long[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof float[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof double[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof char[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof boolean[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof BigDecimal[]) {
            buf.a(S.arrayToString(val));
        } else if (val instanceof IgniteUuid) {
            buf.a(val);
        } else if (val instanceof BinaryObjectExImpl) {
            BinaryObjectExImpl po = (BinaryObjectExImpl)val;
            Integer idHash0 = handles.get(val);
            if (idHash0 != null) {
                BinaryType meta0 = po.rawType();
                assert (meta0 != null);
                buf.a(meta0.typeName()).a(" [hash=").a(idHash0).a(", ...]");
            } else {
                buf.a(po.toString(ctx, handles));
            }
        } else if (val instanceof Object[]) {
            Object[] arr = (Object[])val;
            buf.a('[');
            int len = Math.min(arr.length, GridToStringBuilder.COLLECTION_LIMIT);
            for (int i = 0; i < len; ++i) {
                Object o = arr[i];
                this.appendValue(o, buf, ctx, handles);
                if (i >= len - 1) continue;
                buf.a(", ");
            }
            BinaryObjectExImpl.handleOverflow(buf, arr.length);
            buf.a(']');
        } else if (val instanceof Iterable) {
            Iterable col = (Iterable)val;
            buf.a(col.getClass().getSimpleName()).a(" {");
            Iterator it = col.iterator();
            int cnt = 0;
            while (it.hasNext()) {
                Object o = it.next();
                this.appendValue(o, buf, ctx, handles);
                if (++cnt == GridToStringBuilder.COLLECTION_LIMIT) break;
                if (!it.hasNext()) continue;
                buf.a(", ");
            }
            if (it.hasNext()) {
                buf.a("... and more");
            }
            buf.a('}');
        } else if (val instanceof Map) {
            Map map = (Map)val;
            buf.a(map.getClass().getSimpleName()).a(" {");
            Iterator it = map.entrySet().iterator();
            int cnt = 0;
            while (it.hasNext()) {
                Map.Entry e = it.next();
                this.appendValue(e.getKey(), buf, ctx, handles);
                buf.a('=');
                this.appendValue(e.getValue(), buf, ctx, handles);
                if (++cnt == GridToStringBuilder.COLLECTION_LIMIT) break;
                if (!it.hasNext()) continue;
                buf.a(", ");
            }
            BinaryObjectExImpl.handleOverflow(buf, map.size());
            buf.a('}');
        } else {
            buf.a(val);
        }
    }

    private static void handleOverflow(SB buf, int size) {
        int overflow = size - GridToStringBuilder.COLLECTION_LIMIT;
        if (overflow > 0) {
            buf.a("... and ").a(overflow).a(" more");
        }
    }

    public boolean hasCircularReferences() {
        try {
            BinaryReaderHandles ctx = new BinaryReaderHandles();
            ctx.put(this.start(), this);
            return this.hasCircularReferences(ctx, new IdentityHashMap<BinaryObject, Integer>());
        }
        catch (BinaryObjectException e) {
            throw new IgniteException("Failed to check binary object for circular references", e);
        }
    }

    private boolean hasCircularReferences(BinaryReaderHandles ctx, IdentityHashMap<BinaryObject, Integer> handles) {
        BinaryType meta;
        try {
            meta = this.rawType();
        }
        catch (BinaryObjectException ignore) {
            meta = null;
        }
        if (meta == null) {
            return false;
        }
        int idHash = System.identityHashCode(this);
        handles.put(this, idHash);
        if (meta.fieldNames() != null) {
            ctx.put(this.start(), this);
            for (String name : meta.fieldNames()) {
                Object val = this.field(ctx, name);
                if (!(val instanceof BinaryObjectExImpl)) continue;
                BinaryObjectExImpl po = (BinaryObjectExImpl)val;
                Integer idHash0 = handles.get(val);
                if (idHash0 == null && !po.hasCircularReferences(ctx, handles)) continue;
                return true;
            }
        }
        return false;
    }
}

