/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.model;

import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractChunkOffset;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractDeviceChunkMetaData;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.ChunkOffset;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;

public class DeviceChunkMetaData
extends AbstractDeviceChunkMetaData {
    private final List<IChunkMetadata> measurementChunkMetadata;
    private int index;

    public DeviceChunkMetaData(IDeviceID devicePath, List<IChunkMetadata> measurementChunkMetadataMap) {
        super(devicePath);
        this.measurementChunkMetadata = measurementChunkMetadataMap;
        this.index = -1;
    }

    @Override
    public boolean hasNextValueChunkMetadata() {
        return this.index < this.measurementChunkMetadata.size() - 1;
    }

    @Override
    public IChunkMetadata nextValueChunkMetadata() {
        ++this.index;
        return this.measurementChunkMetadata.get(this.index);
    }

    @Override
    public AbstractChunkOffset getChunkOffset() {
        return new ChunkOffset(this.measurementChunkMetadata.get(this.index).getOffsetOfChunkHeader(), this.getDevicePath(), this.measurementChunkMetadata.get(this.index).getMeasurementUid());
    }
}

